/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class EventLoopContext
extends ContextImpl {
    private static final Logger log = LoggerFactory.getLogger(EventLoopContext.class);

    public EventLoopContext(VertxInternal vertx, WorkerPool internalBlockingPool, WorkerPool workerPool, String deploymentID, JsonObject config, ClassLoader tccl) {
        super(vertx, internalBlockingPool, workerPool, deploymentID, config, tccl);
    }

    public EventLoopContext(VertxInternal vertx, EventLoop eventLoop, WorkerPool internalBlockingPool, WorkerPool workerPool, String deploymentID, JsonObject config, ClassLoader tccl) {
        super(vertx, eventLoop, internalBlockingPool, workerPool, deploymentID, config, tccl);
    }

    @Override
    public void executeAsync(Handler<Void> task) {
        this.nettyEventLoop().execute(this.wrapTask(null, task, true, null));
    }

    @Override
    public boolean isEventLoopContext() {
        return true;
    }

    @Override
    public boolean isMultiThreadedWorkerContext() {
        return false;
    }

    @Override
    protected void checkCorrectThread() {
        Thread current = Thread.currentThread();
        if (!(current instanceof VertxThread)) {
            throw new IllegalStateException("Expected to be on Vert.x thread, but actually on: " + current);
        }
        if (this.contextThread != null && current != this.contextThread) {
            throw new IllegalStateException("Event delivered on unexpected thread " + current + " expected: " + (Object)((Object)this.contextThread));
        }
    }
}

