/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemKeyCertOptions;
import java.util.ArrayList;
import java.util.Base64;

class PemKeyCertOptionsConverter {
    PemKeyCertOptionsConverter() {
    }

    static void fromJson(JsonObject json, PemKeyCertOptions obj) {
        ArrayList<String> list;
        if (json.getValue("certPath") instanceof String) {
            obj.setCertPath((String)json.getValue("certPath"));
        }
        if (json.getValue("certPaths") instanceof JsonArray) {
            list = new ArrayList<String>();
            json.getJsonArray("certPaths").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setCertPaths(list);
        }
        if (json.getValue("certValue") instanceof String) {
            obj.setCertValue(Buffer.buffer(Base64.getDecoder().decode((String)json.getValue("certValue"))));
        }
        if (json.getValue("certValues") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("certValues").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)((Object)Buffer.buffer(Base64.getDecoder().decode((String)item))));
                }
            });
            obj.setCertValues(list);
        }
        if (json.getValue("keyPath") instanceof String) {
            obj.setKeyPath((String)json.getValue("keyPath"));
        }
        if (json.getValue("keyPaths") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("keyPaths").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setKeyPaths(list);
        }
        if (json.getValue("keyValue") instanceof String) {
            obj.setKeyValue(Buffer.buffer(Base64.getDecoder().decode((String)json.getValue("keyValue"))));
        }
        if (json.getValue("keyValues") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("keyValues").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)((Object)Buffer.buffer(Base64.getDecoder().decode((String)item))));
                }
            });
            obj.setKeyValues(list);
        }
    }

    static void toJson(PemKeyCertOptions obj, JsonObject json) {
        JsonArray array;
        if (obj.getCertPaths() != null) {
            array = new JsonArray();
            obj.getCertPaths().forEach(item -> array.add((String)item));
            json.put("certPaths", array);
        }
        if (obj.getCertValues() != null) {
            array = new JsonArray();
            obj.getCertValues().forEach(item -> array.add(item.getBytes()));
            json.put("certValues", array);
        }
        if (obj.getKeyPaths() != null) {
            array = new JsonArray();
            obj.getKeyPaths().forEach(item -> array.add((String)item));
            json.put("keyPaths", array);
        }
        if (obj.getKeyValues() != null) {
            array = new JsonArray();
            obj.getKeyValues().forEach(item -> array.add(item.getBytes()));
            json.put("keyValues", array);
        }
    }
}

