/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.net.impl.ConnectionBase;

public abstract class VertxHandler<C extends ConnectionBase>
extends ChannelDuplexHandler {
    protected abstract C getConnection(Channel var1);

    protected abstract C removeConnection(Channel var1);

    protected ContextImpl getContext(C connection) {
        return ((ConnectionBase)connection).getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteBuf safeBuffer(ByteBuf buf, ByteBufAllocator allocator) {
        if (buf == Unpooled.EMPTY_BUFFER) {
            return buf;
        }
        if (buf.isDirect() || buf instanceof CompositeByteBuf) {
            try {
                if (buf.isReadable()) {
                    ByteBuf buffer = allocator.heapBuffer(buf.readableBytes());
                    buffer.writeBytes(buf);
                    ByteBuf byteBuf = buffer;
                    return byteBuf;
                }
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            finally {
                buf.release();
            }
        }
        return buf;
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Channel ch = ctx.channel();
        C conn = this.getConnection(ch);
        if (conn != null) {
            ContextImpl context = this.getContext(conn);
            context.executeFromIO(() -> conn.handleInterestedOpsChanged());
        }
    }

    public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
        Channel ch = chctx.channel();
        Object connection = this.getConnection(ch);
        if (connection != null) {
            ContextImpl context = this.getContext(connection);
            context.executeFromIO(() -> {
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                connection.handleException(t);
            });
        } else {
            ch.close();
        }
    }

    public void channelInactive(ChannelHandlerContext chctx) throws Exception {
        Channel ch = chctx.channel();
        C connection = this.removeConnection(ch);
        if (connection != null) {
            ContextImpl context = this.getContext(connection);
            context.executeFromIO(() -> connection.handleClosed());
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        C conn = this.getConnection(ctx.channel());
        if (conn != null) {
            ContextImpl context = this.getContext(conn);
            context.executeFromIO(() -> conn.endReadAndFlush());
        }
    }

    public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
        ContextImpl context;
        Object message = this.safeObject(msg, chctx.alloc());
        C connection = this.getConnection(chctx.channel());
        if (connection != null) {
            context = this.getContext(connection);
            context.executeFromIO(() -> connection.startRead());
        } else {
            context = null;
        }
        this.channelRead(connection, context, chctx, message);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.close();
        }
    }

    protected abstract void channelRead(C var1, ContextImpl var2, ChannelHandlerContext var3, Object var4) throws Exception;

    protected abstract Object safeObject(Object var1, ByteBufAllocator var2) throws Exception;
}

