/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Future;
import org.vertx.java.core.Handler;

public class DefaultFutureResult<T>
implements Future<T> {
    private boolean failed;
    private boolean succeeded;
    private Handler<AsyncResult<T>> handler;
    private T result;
    private Throwable throwable;

    public DefaultFutureResult() {
    }

    public DefaultFutureResult(Throwable t) {
        if (t == null) {
            this.setResult((Object)null);
        } else {
            this.setFailure(t);
        }
    }

    public DefaultFutureResult(T result) {
        this.setResult((Object)result);
    }

    @Override
    public T result() {
        return this.result;
    }

    @Override
    public Throwable cause() {
        return this.throwable;
    }

    @Override
    public boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public boolean failed() {
        return this.failed;
    }

    @Override
    public boolean complete() {
        return this.failed || this.succeeded;
    }

    @Override
    public DefaultFutureResult<T> setHandler(Handler<AsyncResult<T>> handler) {
        this.handler = handler;
        this.checkCallHandler();
        return this;
    }

    @Override
    public DefaultFutureResult<T> setResult(T result) {
        this.result = result;
        this.succeeded = true;
        this.checkCallHandler();
        return this;
    }

    @Override
    public DefaultFutureResult<T> setFailure(Throwable throwable) {
        this.throwable = throwable;
        this.failed = true;
        this.checkCallHandler();
        return this;
    }

    private void checkCallHandler() {
        if (this.handler != null && this.complete()) {
            this.handler.handle(this);
        }
    }
}

