/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.dns.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.dns.DnsClient;
import org.vertx.java.core.dns.DnsException;
import org.vertx.java.core.dns.DnsResponseCode;
import org.vertx.java.core.dns.MxRecord;
import org.vertx.java.core.dns.SrvRecord;
import org.vertx.java.core.dns.impl.DefaultMxRecord;
import org.vertx.java.core.dns.impl.DefaultMxRecordComparator;
import org.vertx.java.core.dns.impl.DefaultSrvRecord;
import org.vertx.java.core.dns.impl.DefaultSrvRecordComparator;
import org.vertx.java.core.dns.impl.netty.DnsQuery;
import org.vertx.java.core.dns.impl.netty.DnsQueryEncoder;
import org.vertx.java.core.dns.impl.netty.DnsQuestion;
import org.vertx.java.core.dns.impl.netty.DnsResource;
import org.vertx.java.core.dns.impl.netty.DnsResponse;
import org.vertx.java.core.dns.impl.netty.DnsResponseDecoder;
import org.vertx.java.core.dns.impl.netty.DnsResponseHeader;
import org.vertx.java.core.dns.impl.netty.decoder.RecordDecoderFactory;
import org.vertx.java.core.dns.impl.netty.decoder.record.MailExchangerRecord;
import org.vertx.java.core.dns.impl.netty.decoder.record.ServiceRecord;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;

public final class DefaultDnsClient
implements DnsClient {
    private final Bootstrap bootstrap;
    private final List<InetSocketAddress> dnsServers;
    private static final char[] HEX_TABLE = "0123456789abcdef".toCharArray();
    private final DefaultContext actualCtx;
    private final VertxInternal vertx;

    public DefaultDnsClient(VertxInternal vertx, InetSocketAddress ... dnsServers) {
        if (dnsServers == null || dnsServers.length == 0) {
            throw new IllegalArgumentException("Need at least one default DNS Server");
        }
        this.dnsServers = new LinkedList<InetSocketAddress>(Arrays.asList(dnsServers));
        this.actualCtx = vertx.getOrCreateContext();
        this.vertx = vertx;
        this.bootstrap = new Bootstrap();
        this.bootstrap.group((EventLoopGroup)this.actualCtx.getEventLoop());
        this.bootstrap.channel(NioDatagramChannel.class);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new DnsQueryEncoder()});
                pipeline.addLast(new ChannelHandler[]{new DnsResponseDecoder()});
            }
        });
    }

    @Override
    public DnsClient lookup4(String name, Handler<AsyncResult<Inet4Address>> handler) {
        this.lookup(name, new HandlerAdapter(handler), 1);
        return this;
    }

    @Override
    public DnsClient lookup6(String name, Handler<AsyncResult<Inet6Address>> handler) {
        this.lookup(name, new HandlerAdapter(handler), 28);
        return this;
    }

    @Override
    public DnsClient lookup(String name, Handler<AsyncResult<InetAddress>> handler) {
        this.lookup(name, new HandlerAdapter(handler), 1, 28);
        return this;
    }

    @Override
    public DnsClient resolveA(String name, Handler<AsyncResult<List<Inet4Address>>> handler) {
        this.lookup(name, handler, 1);
        return this;
    }

    @Override
    public DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookup(name, handler, 5);
        return this;
    }

    @Override
    public DnsClient resolveMX(String name, Handler<AsyncResult<List<MxRecord>>> handler) {
        this.lookup(name, new ConvertingHandler<MailExchangerRecord, MxRecord>(handler, DefaultMxRecordComparator.INSTANCE){

            @Override
            protected MxRecord convert(MailExchangerRecord entry) {
                return new DefaultMxRecord(entry);
            }
        }, 15);
        return this;
    }

    @Override
    public DnsClient resolveTXT(String name, final Handler<AsyncResult<List<String>>> handler) {
        this.lookup(name, new Handler<AsyncResult>(){

            @Override
            public void handle(AsyncResult event) {
                if (event.failed()) {
                    handler.handle(event);
                } else {
                    ArrayList txts = new ArrayList();
                    List records = (List)event.result();
                    for (List txt : records) {
                        txts.addAll(txt);
                    }
                    handler.handle(new DefaultFutureResult(txts));
                }
            }
        }, 16);
        return this;
    }

    @Override
    public DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.lookup(name, new HandlerAdapter(handler), 12);
        return this;
    }

    @Override
    public DnsClient resolveAAAA(String name, Handler<AsyncResult<List<Inet6Address>>> handler) {
        this.lookup(name, handler, 28);
        return this;
    }

    @Override
    public DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookup(name, handler, 2);
        return this;
    }

    @Override
    public DnsClient resolveSRV(String name, Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.lookup(name, new ConvertingHandler<ServiceRecord, SrvRecord>(handler, DefaultSrvRecordComparator.INSTANCE){

            @Override
            protected SrvRecord convert(ServiceRecord entry) {
                return new DefaultSrvRecord(entry);
            }
        }, 33);
        return this;
    }

    @Override
    public DnsClient reverseLookup(String address, final Handler<AsyncResult<InetAddress>> handler) {
        try {
            final InetAddress inetAddress = InetAddress.getByName(address);
            byte[] addr = inetAddress.getAddress();
            StringBuilder reverseName = new StringBuilder(64);
            if (inetAddress instanceof Inet4Address) {
                reverseName.append(addr[3] & 0xFF).append(".").append(addr[2] & 0xFF).append(".").append(addr[1] & 0xFF).append(".").append(addr[0] & 0xFF);
            } else {
                for (int i = 0; i < 16; ++i) {
                    reverseName.append(HEX_TABLE[addr[15 - i] & 0xF]);
                    reverseName.append(".");
                    reverseName.append(HEX_TABLE[addr[15 - i] >> 4 & 0xF]);
                    if (i == 15) continue;
                    reverseName.append(".");
                }
            }
            reverseName.append(".in-addr.arpa");
            return this.resolvePTR(reverseName.toString(), new Handler<AsyncResult<String>>(){

                @Override
                public void handle(AsyncResult event) {
                    if (event.failed()) {
                        handler.handle(event);
                    } else {
                        String result = (String)event.result();
                        try {
                            handler.handle(new DefaultFutureResult<InetAddress>(InetAddress.getByAddress(result, inetAddress.getAddress())));
                        }
                        catch (UnknownHostException e) {
                            handler.handle(new DefaultFutureResult<UnknownHostException>(e));
                        }
                    }
                }
            });
        }
        catch (UnknownHostException e) {
            this.actualCtx.execute(new Runnable(){

                @Override
                public void run() {
                    handler.handle(new DefaultFutureResult<UnknownHostException>(e));
                }
            });
            return this;
        }
    }

    private void lookup(String name, Handler handler, int ... types) {
        DefaultFutureResult result = new DefaultFutureResult();
        result.setHandler(handler);
        this.lookup(this.dnsServers.iterator(), name, result, types);
    }

    private void lookup(final Iterator<InetSocketAddress> dns, final String name, final DefaultFutureResult result, final int ... types) {
        this.bootstrap.connect((SocketAddress)dns.next()).addListener((GenericFutureListener)new RetryChannelFutureListener(dns, name, result, types){

            @Override
            public void onSuccess(ChannelFuture future) throws Exception {
                DnsQuery query = new DnsQuery(ThreadLocalRandom.current().nextInt());
                for (int type : types) {
                    query.addQuestion(new DnsQuestion(name, type));
                }
                future.channel().writeAndFlush((Object)query).addListener((GenericFutureListener)new RetryChannelFutureListener(dns, name, result, types){

                    @Override
                    public void onSuccess(ChannelFuture future) throws Exception {
                        future.channel().pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DnsResponse>(){

                            protected void channelRead0(ChannelHandlerContext ctx, DnsResponse msg) throws Exception {
                                DnsResponseCode code = DnsResponseCode.valueOf(((DnsResponseHeader)msg.getHeader()).getResponseCode());
                                if (code == DnsResponseCode.NOERROR) {
                                    List<DnsResource> resources = msg.getAnswers();
                                    ArrayList records = new ArrayList(resources.size());
                                    for (DnsResource resource : msg.getAnswers()) {
                                        Object record = RecordDecoderFactory.getFactory().decode(resource.type(), msg, resource);
                                        records.add(record);
                                    }
                                    DefaultDnsClient.this.setResult(result, ctx.channel().eventLoop(), records);
                                } else {
                                    DefaultDnsClient.this.setResult(result, ctx.channel().eventLoop(), new DnsException(code));
                                }
                                ctx.close();
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                DefaultDnsClient.this.setResult(result, ctx.channel().eventLoop(), cause);
                                ctx.close();
                            }
                        }});
                    }
                });
            }
        });
    }

    private void setResult(final DefaultFutureResult r, EventLoop loop, final Object result) {
        block6: {
            if (r.complete()) {
                return;
            }
            if (this.actualCtx.isOnCorrectWorker(loop)) {
                try {
                    this.vertx.setContext(this.actualCtx);
                    if (result instanceof Throwable) {
                        r.setFailure((Throwable)result);
                        break block6;
                    }
                    r.setResult(result);
                }
                catch (Throwable t) {
                    this.actualCtx.reportException(t);
                }
            } else {
                this.actualCtx.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (result instanceof Throwable) {
                            r.setFailure((Throwable)result);
                        } else {
                            r.setResult(result);
                        }
                    }
                });
            }
        }
    }

    private abstract class RetryChannelFutureListener
    implements ChannelFutureListener {
        private final Iterator<InetSocketAddress> dns;
        private final String name;
        private final DefaultFutureResult result;
        private final int[] types;

        RetryChannelFutureListener(Iterator<InetSocketAddress> dns, String name, DefaultFutureResult result, int ... types) {
            this.dns = dns;
            this.name = name;
            this.result = result;
            this.types = types;
        }

        public final void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                if (!this.result.complete()) {
                    if (this.dns.hasNext()) {
                        DefaultDnsClient.this.lookup(this.dns, this.name, this.result, this.types);
                    } else {
                        this.result.setFailure(future.cause());
                    }
                }
            } else {
                this.onSuccess(future);
            }
        }

        protected abstract void onSuccess(ChannelFuture var1) throws Exception;
    }

    protected abstract class ConvertingHandler<F, T>
    implements Handler<AsyncResult<List<F>>> {
        private final Handler handler;
        private final Comparator comparator;

        ConvertingHandler(Handler<AsyncResult<List<T>>> handler, Comparator comparator) {
            this.handler = handler;
            this.comparator = comparator;
        }

        @Override
        public void handle(AsyncResult<List<F>> event) {
            if (event.failed()) {
                this.handler.handle(event);
            } else {
                List<F> records = event.result();
                for (int i = 0; i < records.size(); ++i) {
                    F record = records.get(i);
                    records.set(i, this.convert(record));
                }
                Collections.sort(records, this.comparator);
                this.handler.handle(new DefaultFutureResult<List<F>>(records));
            }
        }

        protected abstract T convert(F var1);
    }

    private static final class HandlerAdapter<T>
    implements Handler<AsyncResult<List<T>>> {
        private final Handler handler;

        HandlerAdapter(Handler handler) {
            this.handler = handler;
        }

        @Override
        public void handle(AsyncResult<List<T>> event) {
            if (event.failed()) {
                this.handler.handle(event);
            } else {
                List<T> result = event.result();
                if (result.isEmpty()) {
                    this.handler.handle(new DefaultFutureResult<Object>((Object)null));
                } else {
                    this.handler.handle(new DefaultFutureResult<T>(result.get(0)));
                }
            }
        }
    }
}

