/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.nio.charset.Charset;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.streams.Pump;

class DefaultHttpServerFileUpload
implements HttpServerFileUpload {
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private AsyncFile file;
    private Handler<Throwable> exceptionHandler;
    private final HttpServerRequest req;
    private final Vertx vertx;
    private final String name;
    private final String filename;
    private final String contentType;
    private final String contentTransferEncoding;
    private final Charset charset;
    private long size;
    private boolean lazyCalculateSize;
    private boolean paused;
    private Buffer pauseBuff;
    private boolean complete;

    DefaultHttpServerFileUpload(Vertx vertx, HttpServerRequest req, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        this.vertx = vertx;
        this.req = req;
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentTransferEncoding = contentTransferEncoding;
        this.charset = charset;
        this.size = size;
        if (size == 0L) {
            this.lazyCalculateSize = true;
        }
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public String contentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public HttpServerFileUpload dataHandler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    @Override
    public HttpServerFileUpload pause() {
        this.req.pause();
        this.paused = true;
        return this;
    }

    @Override
    public HttpServerFileUpload resume() {
        if (this.paused) {
            this.req.resume();
            this.paused = false;
            if (this.pauseBuff != null) {
                this.receiveData(this.pauseBuff);
                this.pauseBuff = null;
            }
            if (this.complete && this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
        return this;
    }

    @Override
    public HttpServerFileUpload exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public HttpServerFileUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public HttpServerFileUpload streamToFileSystem(String filename) {
        this.pause();
        this.vertx.fileSystem().open(filename, (Handler<AsyncResult<AsyncFile>>)new AsyncResultHandler<AsyncFile>(){

            @Override
            public void handle(AsyncResult<AsyncFile> ar) {
                if (ar.succeeded()) {
                    DefaultHttpServerFileUpload.this.file = ar.result();
                    Pump p = Pump.createPump(DefaultHttpServerFileUpload.this, ar.result());
                    p.start();
                    DefaultHttpServerFileUpload.this.resume();
                } else {
                    DefaultHttpServerFileUpload.this.notifyExceptionHandler(ar.cause());
                }
            }
        });
        return this;
    }

    @Override
    public boolean isSizeAvailable() {
        return !this.lazyCalculateSize;
    }

    void receiveData(Buffer data) {
        if (this.lazyCalculateSize) {
            this.size += (long)data.length();
        }
        if (!this.paused) {
            if (this.dataHandler != null) {
                this.dataHandler.handle(data);
            }
        } else {
            if (this.pauseBuff == null) {
                this.pauseBuff = new Buffer();
            }
            this.pauseBuff.appendBuffer(data);
        }
    }

    void complete() {
        this.lazyCalculateSize = false;
        if (this.paused) {
            this.complete = true;
        } else if (this.file == null) {
            this.notifyEndHandler();
        } else {
            this.file.close((Handler<AsyncResult<Void>>)new AsyncResultHandler<Void>(){

                @Override
                public void handle(AsyncResult<Void> event) {
                    if (event.failed()) {
                        DefaultHttpServerFileUpload.this.notifyExceptionHandler(event.cause());
                    }
                    DefaultHttpServerFileUpload.this.notifyEndHandler();
                }
            });
        }
    }

    private void notifyEndHandler() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    private void notifyExceptionHandler(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(cause);
        }
    }
}

