/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.impl.PartialPooledByteBufAllocator;
import org.vertx.java.core.net.impl.SocketDefaults;

public class TCPSSLHelper {
    private static final Logger log = LoggerFactory.getLogger(TCPSSLHelper.class);
    private boolean ssl;
    private boolean verifyHost = true;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean trustAll;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private static SocketDefaults defaults = SocketDefaults.instance;
    private boolean tcpNoDelay = true;
    private int tcpSendBufferSize = -1;
    private int tcpReceiveBufferSize = -1;
    private boolean tcpKeepAlive = defaults.isTcpKeepAlive();
    private boolean reuseAddress = defaults.isReuseAddress();
    private int soLinger = defaults.getSoLinger();
    private int trafficClass = -1;
    private int acceptBackLog = 1024;
    private int connectTimeout = 60000;
    private boolean usePooledBuffers;
    private SSLContext sslContext;
    private SSLContext externalSSLContext = null;

    public void checkSSL(VertxInternal vertx) {
        if (this.ssl) {
            this.sslContext = this.createContext(vertx, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword, this.trustAll);
        }
    }

    public void applyConnectionOptions(ServerBootstrap bootstrap) {
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
        if (this.tcpSendBufferSize != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.tcpSendBufferSize);
        }
        if (this.tcpReceiveBufferSize != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.tcpReceiveBufferSize);
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.tcpReceiveBufferSize));
        }
        bootstrap.option(ChannelOption.SO_LINGER, (Object)this.soLinger);
        if (this.trafficClass != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, (Object)this.trafficClass);
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepAlive);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.reuseAddress);
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.acceptBackLog);
    }

    public void applyConnectionOptions(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
        if (this.tcpSendBufferSize != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.tcpSendBufferSize);
        }
        if (this.tcpReceiveBufferSize != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.tcpReceiveBufferSize);
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.tcpReceiveBufferSize));
        }
        bootstrap.option(ChannelOption.SO_LINGER, (Object)this.soLinger);
        if (this.trafficClass != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)this.trafficClass);
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout);
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepAlive);
    }

    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSendBufferSize() {
        return this.tcpSendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.tcpReceiveBufferSize;
    }

    public boolean isTCPKeepAlive() {
        return this.tcpKeepAlive;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setSendBufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("TCP send buffer size must be >= 1");
        }
        this.tcpSendBufferSize = size;
    }

    public void setReceiveBufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("TCP receive buffer size must be >= 1");
        }
        this.tcpReceiveBufferSize = size;
    }

    public void setTCPKeepAlive(boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
    }

    public void setReuseAddress(boolean reuse) {
        this.reuseAddress = reuse;
    }

    public void setSoLinger(int linger) {
        this.soLinger = linger;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public void setExternalSSLContext(SSLContext externalSSLContext) {
        this.externalSSLContext = externalSSLContext;
    }

    public void setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    public void setKeyStorePath(String path) {
        this.keyStorePath = path;
    }

    public void setKeyStorePassword(String pwd) {
        this.keyStorePassword = pwd;
    }

    public void setTrustStorePath(String path) {
        this.trustStorePath = path;
    }

    public void setTrustStorePassword(String pwd) {
        this.trustStorePassword = pwd;
    }

    public void setClientAuthRequired(boolean required) {
        this.clientAuth = required ? ClientAuth.REQUIRED : ClientAuth.NONE;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public int getAcceptBacklog() {
        return this.acceptBackLog;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = connectTimeout;
    }

    public void setAcceptBacklog(int acceptBackLog) {
        if (acceptBackLog < 0) {
            throw new IllegalArgumentException("acceptBackLog must be >= 0");
        }
        this.acceptBackLog = acceptBackLog;
    }

    public void setUsePooledBuffers(boolean usePooledBuffers) {
        this.usePooledBuffers = usePooledBuffers;
    }

    public boolean isUsePooledBuffers() {
        return this.usePooledBuffers;
    }

    public SSLContext createContext(VertxInternal vertx, String ksPath, String ksPassword, String tsPath, String tsPassword, boolean trustAll) {
        if (this.externalSSLContext != null) {
            return this.externalSSLContext;
        }
        try {
            KeyManager[] keyMgrs;
            SSLContext context = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = keyMgrs = ksPath == null ? null : TCPSSLHelper.getKeyMgrs(vertx, ksPath, ksPassword);
            TrustManager[] trustMgrs = trustAll ? new TrustManager[]{TCPSSLHelper.createTrustAllTrustManager()} : (tsPath == null ? null : TCPSSLHelper.getTrustMgrs(vertx, tsPath, tsPassword));
            context.init(keyMgrs, trustMgrs, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            log.error("Failed to create context", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private static TrustManager[] getTrustMgrs(VertxInternal vertx, String tsPath, String tsPassword) throws Exception {
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ts = TCPSSLHelper.loadStore(vertx, tsPath, tsPassword);
        fact.init(ts);
        return fact.getTrustManagers();
    }

    private static KeyManager[] getKeyMgrs(VertxInternal vertx, String ksPath, String ksPassword) throws Exception {
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = TCPSSLHelper.loadStore(vertx, ksPath, ksPassword);
        fact.init(ks, ksPassword != null ? ksPassword.toCharArray() : null);
        return fact.getKeyManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadStore(VertxInternal vertx, String path, String ksPassword) throws Exception {
        String ksPath = PathAdjuster.adjust(vertx, path);
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream in = null;
        try {
            in = new FileInputStream(new File(ksPath));
            ks.load(in, ksPassword != null ? ksPassword.toCharArray() : null);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        return ks;
    }

    public SslHandler createSslHandler(VertxInternal vertx, boolean client) {
        if (this.sslContext == null) {
            this.sslContext = this.createContext(vertx, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword, this.trustAll);
        }
        SSLEngine engine = this.getSSLContext().createSSLEngine();
        engine.setUseClientMode(client);
        if (!client) {
            switch (this.getClientAuth()) {
                case REQUEST: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    engine.setNeedClientAuth(false);
                }
            }
        }
        return new SslHandler(engine);
    }

    public static enum ClientAuth {
        NONE,
        REQUEST,
        REQUIRED;

    }
}

