/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelStateHandlerAdapter;
import java.util.Map;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.FlowControlStateEvent;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.ConnectionBase;

public abstract class VertxStateHandler<C extends ConnectionBase>
extends ChannelStateHandlerAdapter {
    protected final VertxInternal vertx;
    protected final Map<Channel, C> connectionMap;

    protected VertxStateHandler(VertxInternal vertx, Map<Channel, C> connectionMap) {
        this.vertx = vertx;
        this.connectionMap = connectionMap;
    }

    protected DefaultContext getContext(C connection) {
        return ((ConnectionBase)connection).getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object obj) throws Exception {
        if (obj instanceof FlowControlStateEvent) {
            FlowControlStateEvent evt = (FlowControlStateEvent)obj;
            Channel ch = ctx.channel();
            final ConnectionBase conn = (ConnectionBase)this.connectionMap.get(ch);
            if (conn != null) {
                conn.setWritable(evt.isWritable());
                DefaultContext context = this.getContext(conn);
                if (context.isOnCorrectWorker(ch.eventLoop())) {
                    try {
                        this.vertx.setContext(context);
                        context.startExecute();
                        conn.handleInterestedOpsChanged();
                    }
                    catch (Throwable t) {
                        context.reportException(t);
                    }
                    finally {
                        context.endExecute();
                    }
                } else {
                    context.execute(new Runnable(){

                        @Override
                        public void run() {
                            conn.handleInterestedOpsChanged();
                        }
                    });
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext chctx, final Throwable t) throws Exception {
        final Channel ch = chctx.channel();
        final ConnectionBase sock = (ConnectionBase)this.connectionMap.remove(ch);
        if (sock != null) {
            DefaultContext context = this.getContext(sock);
            context.execute(ch.eventLoop(), new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ch.isOpen()) {
                            ch.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    sock.handleException(t);
                }
            });
        }
    }

    public void channelInactive(ChannelHandlerContext chctx) throws Exception {
        Channel ch = chctx.channel();
        final ConnectionBase sock = (ConnectionBase)this.connectionMap.remove(ch);
        if (sock != null) {
            DefaultContext context = this.getContext(sock);
            context.execute(ch.eventLoop(), new Runnable(){

                @Override
                public void run() {
                    sock.handleClosed();
                }
            });
        }
    }
}

