/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.BufUtil;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelStateHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.WebSocket;
import org.vertx.java.core.http.WebSocketVersion;
import org.vertx.java.core.http.impl.AbstractConnection;
import org.vertx.java.core.http.impl.DefaultHttpClient;
import org.vertx.java.core.http.impl.DefaultHttpClientRequest;
import org.vertx.java.core.http.impl.DefaultHttpClientResponse;
import org.vertx.java.core.http.impl.DefaultWebSocket;
import org.vertx.java.core.http.impl.ws.WebSocketConvertHandler;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.VertxNetHandler;

class ClientConnection
extends AbstractConnection {
    final DefaultHttpClient client;
    final String hostHeader;
    private final boolean ssl;
    private final String host;
    private final int port;
    boolean keepAlive;
    private boolean wsHandshakeConnection;
    private WebSocketClientHandshaker handshaker;
    private volatile DefaultHttpClientRequest currentRequest;
    private final Queue<DefaultHttpClientRequest> requests = new ConcurrentLinkedQueue<DefaultHttpClientRequest>();
    private volatile DefaultHttpClientResponse currentResponse;
    private DefaultWebSocket ws;

    ClientConnection(VertxInternal vertx, DefaultHttpClient client, Channel channel, boolean ssl, String host, int port, boolean keepAlive, DefaultContext context) {
        super(vertx, channel, context);
        this.client = client;
        this.ssl = ssl;
        this.host = host;
        this.port = port;
        this.hostHeader = host + ':' + port;
        this.keepAlive = keepAlive;
    }

    void toWebSocket(String uri, WebSocketVersion wsVersion, MultiMap headers, Handler<WebSocket> wsConnect) {
        if (this.ws != null) {
            throw new IllegalStateException("Already websocket");
        }
        try {
            DefaultHttpHeaders nettyHeaders;
            io.netty.handler.codec.http.websocketx.WebSocketVersion version;
            URI wsuri = new URI(uri);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.host + ":" + this.port + uri);
            }
            if (wsVersion == WebSocketVersion.HYBI_00) {
                version = io.netty.handler.codec.http.websocketx.WebSocketVersion.V00;
            } else if (wsVersion == WebSocketVersion.HYBI_08) {
                version = io.netty.handler.codec.http.websocketx.WebSocketVersion.V08;
            } else if (wsVersion == WebSocketVersion.RFC6455) {
                version = io.netty.handler.codec.http.websocketx.WebSocketVersion.V13;
            } else {
                throw new IllegalArgumentException("Invalid version");
            }
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    nettyHeaders.add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)wsuri, (io.netty.handler.codec.http.websocketx.WebSocketVersion)version, null, (boolean)false, (HttpHeaders)nettyHeaders);
            ChannelPipeline p = this.channel.pipeline();
            p.addBefore("handler", "handshakeCompleter", (ChannelHandler)new HandshakeInboundHandler(wsConnect));
            this.handshaker.handshake(this.channel).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ClientConnection.this.client.handleException((Exception)future.cause());
                    }
                }
            });
            this.wsHandshakeConnection = true;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
    }

    @Override
    public void close() {
        if (!this.wsHandshakeConnection) {
            if (!this.keepAlive) {
                this.internalClose();
            } else {
                this.client.returnConnection(this);
            }
        }
    }

    void internalClose() {
        this.channel.close();
    }

    boolean isClosed() {
        return !this.channel.isOpen();
    }

    int getOutstandingRequestCount() {
        return this.requests.size();
    }

    @Override
    public void handleInterestedOpsChanged() {
        try {
            if (!this.doWriteQueueFull()) {
                if (this.currentRequest != null) {
                    this.setContext();
                    this.currentRequest.handleDrained();
                } else if (this.ws != null) {
                    this.ws.writable();
                }
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleResponse(HttpResponse resp) {
        DefaultHttpClientResponse nResp;
        DefaultHttpClientRequest req = resp.getStatus().code() == 100 ? this.requests.peek() : this.requests.poll();
        if (req == null) {
            throw new IllegalStateException("No response handler");
        }
        this.setContext();
        this.currentResponse = nResp = new DefaultHttpClientResponse(this.vertx, req, this, resp);
        req.handleResponse(nResp);
    }

    void handleResponseChunk(Buffer buff) {
        this.setContext();
        try {
            this.currentResponse.handleChunk(buff);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleResponseEnd(LastHttpContent trailer) {
        this.setContext();
        try {
            this.currentResponse.handleEnd(trailer);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
        if (!this.keepAlive) {
            this.close();
        }
    }

    void handleWsFrame(WebSocketFrame frame) {
        if (this.ws != null) {
            this.setContext();
            this.ws.handleFrame(frame);
        }
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
    }

    @Override
    protected DefaultContext getContext() {
        return super.getContext();
    }

    protected void handleException(Exception e) {
        super.handleException(e);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        } else if (this.currentResponse != null) {
            this.currentResponse.handleException(e);
        }
    }

    @Override
    ChannelFuture write(Object obj) {
        return this.channel.write(obj);
    }

    void setCurrentRequest(DefaultHttpClientRequest req) {
        if (this.currentRequest != null) {
            throw new IllegalStateException("Connection is already writing a request");
        }
        this.currentRequest = req;
        this.requests.add(req);
    }

    void endRequest() {
        if (this.currentRequest == null) {
            throw new IllegalStateException("No write in progress");
        }
        this.currentRequest = null;
        if (this.keepAlive) {
            this.close();
        }
    }

    NetSocket createNetSocket() {
        DefaultNetSocket socket = new DefaultNetSocket(this.vertx, this.channel, this.context);
        HashMap<Channel, DefaultNetSocket> connectionMap = new HashMap<Channel, DefaultNetSocket>(1);
        connectionMap.put(this.channel, socket);
        this.channel.pipeline().remove("codec");
        this.channel.pipeline().replace("handler", "handler", (ChannelHandler)new VertxNetHandler(this.client.vertx, connectionMap){

            @Override
            public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
                ClientConnection.this.client.connectionMap.remove(ClientConnection.this.channel);
                super.exceptionCaught(chctx, t);
            }

            @Override
            public void channelInactive(ChannelHandlerContext chctx) throws Exception {
                ClientConnection.this.client.connectionMap.remove(ClientConnection.this.channel);
                super.channelInactive(chctx);
            }
        });
        return socket;
    }

    private final class HandshakeInboundHandler
    extends ChannelStateHandlerAdapter
    implements ChannelInboundMessageHandler<Object> {
        private final Handler<WebSocket> wsConnect;
        private final DefaultContext context;
        private FullHttpResponse response;
        private boolean handshaking;

        public HandshakeInboundHandler(Handler<WebSocket> wsConnect) {
            this.wsConnect = wsConnect;
            this.context = ClientConnection.this.vertx.getContext();
        }

        public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
            MessageBuf in = ctx.inboundMessageBuffer();
            while (true) {
                boolean handled = false;
                Object msg = in.poll();
                if (msg == null) break;
                if (ClientConnection.this.handshaker != null && !this.handshaking) {
                    if (msg instanceof HttpResponse) {
                        handled = true;
                        HttpResponse resp = (HttpResponse)msg;
                        if (resp.getStatus().code() != 101) {
                            ClientConnection.this.client.handleException((Exception)new WebSocketHandshakeException("Websocket connection attempt returned HTTP status code " + resp.getStatus().code()));
                            return;
                        }
                        if (msg instanceof FullHttpResponse) {
                            this.handshakeComplete(ctx, (FullHttpResponse)msg);
                            return;
                        }
                        this.response = new DefaultFullHttpResponse(resp.getProtocolVersion(), resp.getStatus());
                        this.response.headers().add(resp.headers());
                    }
                    if (msg instanceof HttpContent && this.response != null) {
                        handled = true;
                        this.response.content().writeBytes(((HttpContent)msg).content());
                        if (msg instanceof LastHttpContent) {
                            this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                            this.handshakeComplete(ctx, this.response);
                            return;
                        }
                    }
                }
                if (handled) continue;
                BufUtil.retain((Object)msg);
                ctx.nextInboundMessageBuffer().add(msg);
            }
        }

        public MessageBuf<Object> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
            return Unpooled.messageBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handshakeComplete(ChannelHandlerContext ctx, FullHttpResponse response) {
            this.handshaking = true;
            try {
                ctx.pipeline().addAfter(ctx.name(), "websocketConverter", (ChannelHandler)WebSocketConvertHandler.INSTANCE);
                ClientConnection.this.ws = new DefaultWebSocket(ClientConnection.this.vertx, ClientConnection.this);
                ClientConnection.this.handshaker.finishHandshake(ClientConnection.this.channel, response);
                this.context.execute(ctx.channel().eventLoop(), new Runnable(){

                    @Override
                    public void run() {
                        HandshakeInboundHandler.this.wsConnect.handle(ClientConnection.this.ws);
                    }
                });
            }
            catch (WebSocketHandshakeException e) {
                ClientConnection.this.client.handleException((Exception)((Object)e));
            }
            finally {
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireInboundBufferUpdated();
            }
        }
    }
}

