/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.logging;

import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerAdapter;
import io.vertx.core.logging.JULLogDelegateFactory;
import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.core.spi.logging.LogDelegateFactory;

public class LoggerFactory {
    private static volatile LogDelegateFactory delegateFactory;

    private static synchronized void initialise() {
        String className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            className = System.getProperty("vertx.logger-delegate-factory-class-name");
        }
        catch (Exception ignore) {
            className = null;
        }
        if (className != null && LoggerFactory.configureWith(className, false, loader)) {
            return;
        }
        if (loader.getResource("vertx-default-jul-logging.properties") == null && (LoggerFactory.configureWith("SLF4J", true, loader) || LoggerFactory.configureWith("Log4j2", true, loader))) {
            return;
        }
        delegateFactory = new JULLogDelegateFactory();
    }

    private static boolean configureWith(String name, boolean shortName, ClassLoader loader) {
        try {
            Class<?> clazz = Class.forName((String)(shortName ? "io.vertx.core.logging." + name + "LogDelegateFactory" : name), true, loader);
            LogDelegateFactory factory = (LogDelegateFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!factory.isAvailable()) {
                return false;
            }
            delegateFactory = factory;
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        String name = clazz.isAnonymousClass() ? clazz.getEnclosingClass().getCanonicalName() : clazz.getCanonicalName();
        return LoggerFactory.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new LoggerAdapter(delegateFactory.createDelegate(name));
    }

    static {
        LoggerFactory.initialise();
        LogDelegate log = delegateFactory.createDelegate(LoggerFactory.class.getName());
        log.debug("Using " + delegateFactory.getClass().getName());
    }
}

