/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.type.AnnotationValueInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;

public class ModuleModel
implements Model {
    private final PackageElement element;
    private final ModuleInfo info;
    private final List<AnnotationValueInfo> annotationValueInfos;

    public ModuleModel(PackageElement element, ModuleInfo info, List<AnnotationValueInfo> annotationValueInfos) {
        this.element = element;
        this.info = info;
        this.annotationValueInfos = annotationValueInfos != null ? annotationValueInfos : Collections.emptyList();
    }

    public String getName() {
        return this.info.getName();
    }

    public String translateFqn(String name) {
        return this.info.translatePackageName(name);
    }

    @Override
    public boolean process() {
        return false;
    }

    @Override
    public String getKind() {
        return "module";
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public String getFqn() {
        return this.info.getPackageName();
    }

    @Override
    public List<AnnotationValueInfo> getAnnotations() {
        return this.annotationValueInfos;
    }

    @Override
    public Map<String, Object> getVars() {
        Map<String, Object> vars = Model.super.getVars();
        vars.put("fqn", this.info.getPackageName());
        vars.put("name", this.info.getName());
        vars.put("module", this.getModule());
        vars.put("annotations", this.getAnnotations());
        return vars;
    }

    @Override
    public ModuleInfo getModule() {
        return this.info;
    }
}

