/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.Helper;
import io.vertx.codegen.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class TypeUse {
    static final String NULLABLE = Nullable.class.getName();
    private static final List<TypeInternalProvider> providers = new ArrayList<TypeInternalProvider>();
    private final TypeInternal[] types;

    public static TypeUse createParamTypeUse(ProcessingEnvironment env, ExecutableElement[] methods, int index) {
        TypeInternal[] internals = new TypeInternal[methods.length];
        block0: for (int i = 0; i < methods.length; ++i) {
            for (TypeInternalProvider provider : providers) {
                internals[i] = provider.forParam(env, methods[i], index);
                if (internals[i] == null) continue;
                continue block0;
            }
        }
        return new TypeUse(internals);
    }

    public static TypeUse createReturnTypeUse(ProcessingEnvironment env, ExecutableElement ... methods) {
        TypeInternal[] internals = new TypeInternal[methods.length];
        block0: for (int i = 0; i < methods.length; ++i) {
            for (TypeInternalProvider provider : providers) {
                internals[i] = provider.forReturn(env, methods[i]);
                if (internals[i] == null) continue;
                continue block0;
            }
        }
        return new TypeUse(internals);
    }

    private TypeUse(TypeInternal[] types) {
        this.types = types;
    }

    public TypeUse getArg(String rawName, int index) {
        ArrayList<TypeInternal> abc = new ArrayList<TypeInternal>();
        for (TypeInternal type : this.types) {
            if (!rawName.equals(type.rawName())) break;
            abc.add(type.getArgAt(index));
        }
        return new TypeUse(abc.toArray(new TypeInternal[abc.size()]));
    }

    public boolean isNullable() {
        boolean nullable = false;
        for (TypeInternal type : this.types) {
            if (type.isNullable()) {
                nullable = true;
                continue;
            }
            if (!nullable) continue;
            throw new RuntimeException("Nullable type cannot override non nullable");
        }
        return nullable;
    }

    static {
        try {
            TypeUse.class.getClassLoader().loadClass("java.lang.invoke.VarHandle");
        }
        catch (Throwable ignore1) {
            try {
                String fqn = TypeUse.class.getPackage().getName() + ".TreeTypeInternal";
                Class<?> clazz = TypeUse.class.getClassLoader().loadClass(fqn);
                Field getter = clazz.getField("PROVIDER");
                TypeInternalProvider provider = (TypeInternalProvider)getter.get(null);
                providers.add(provider);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        providers.add(new TypeInternalProvider(){

            @Override
            public TypeInternal forParam(ProcessingEnvironment env, ExecutableElement methodElt, int paramIndex) {
                Method methodRef = Helper.getReflectMethod(methodElt);
                if (methodRef == null) {
                    return null;
                }
                AnnotatedType annotated = methodRef.getAnnotatedParameterTypes()[paramIndex];
                return new ReflectType(annotated);
            }

            @Override
            public TypeInternal forReturn(ProcessingEnvironment env, ExecutableElement methodElt) {
                Method methodRef = Helper.getReflectMethod(methodElt);
                if (methodRef == null) {
                    return null;
                }
                AnnotatedType annotated = methodRef.getAnnotatedReturnType();
                return new ReflectType(annotated);
            }
        });
        providers.add(new TypeInternalProvider(){

            @Override
            public TypeInternal forParam(ProcessingEnvironment env, ExecutableElement methodElt, int index) {
                return new MirrorTypeInternal(methodElt.getParameters().get(index).asType());
            }

            @Override
            public TypeInternal forReturn(ProcessingEnvironment env, ExecutableElement methodElt) {
                return new MirrorTypeInternal(methodElt.getReturnType());
            }
        });
    }

    private static class MirrorTypeInternal
    implements TypeInternal {
        final TypeMirror mirror;

        private MirrorTypeInternal(TypeMirror mirror) {
            this.mirror = mirror;
        }

        @Override
        public String rawName() {
            if (this.mirror.getKind() == TypeKind.DECLARED) {
                return ((TypeElement)((DeclaredType)this.mirror).asElement()).getQualifiedName().toString();
            }
            return null;
        }

        @Override
        public boolean isNullable() {
            for (AnnotationMirror annotationMirror : this.mirror.getAnnotationMirrors()) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                TypeElement annotationTypeElt = (TypeElement)annotationType.asElement();
                if (!annotationTypeElt.getQualifiedName().toString().equals(NULLABLE)) continue;
                return true;
            }
            return false;
        }

        @Override
        public TypeInternal getArgAt(int index) {
            List<? extends TypeMirror> args = ((DeclaredType)this.mirror).getTypeArguments();
            return new MirrorTypeInternal(args.get(index));
        }
    }

    private static class ReflectType
    implements TypeInternal {
        private final AnnotatedType annotatedType;
        private final boolean nullable;

        private ReflectType(AnnotatedType annotated) {
            this.annotatedType = annotated;
            this.nullable = ReflectType.isNullable(annotated);
        }

        @Override
        public String rawName() {
            if (this.annotatedType instanceof AnnotatedParameterizedType) {
                return ((ParameterizedType)this.annotatedType.getType()).getRawType().getTypeName();
            }
            return null;
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public TypeInternal getArgAt(int index) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)this.annotatedType;
            return new ReflectType(annotatedParameterizedType.getAnnotatedActualTypeArguments()[index]);
        }

        private static boolean isNullable(AnnotatedType type) {
            for (Annotation annotation : type.getAnnotations()) {
                if (!annotation.annotationType().getName().equals(NULLABLE)) continue;
                return true;
            }
            return false;
        }
    }

    static interface TypeInternalProvider {
        public TypeInternal forParam(ProcessingEnvironment var1, ExecutableElement var2, int var3);

        public TypeInternal forReturn(ProcessingEnvironment var1, ExecutableElement var2);
    }

    static interface TypeInternal {
        public String rawName();

        public boolean isNullable();

        public TypeInternal getArgAt(int var1);
    }
}

