/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.PropertyKind;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.type.AnnotationValueInfo;
import io.vertx.codegen.type.AnnotationValueInfoFactory;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class DataObjectModel
implements Model {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final Doc.Factory docFactory;
    private final TypeMirrorFactory typeFactory;
    private final TypeElement modelElt;
    private final Map<String, PropertyInfo> propertyMap = new LinkedHashMap<String, PropertyInfo>();
    private final Set<ClassTypeInfo> superTypes = new LinkedHashSet<ClassTypeInfo>();
    private final Set<ClassTypeInfo> abstractSuperTypes = new LinkedHashSet<ClassTypeInfo>();
    private final Set<ClassTypeInfo> importedTypes = new LinkedHashSet<ClassTypeInfo>();
    private boolean processed;
    private boolean concrete;
    private boolean isClass;
    private boolean generateConverter;
    private boolean inheritConverter;
    private int constructors;
    private ClassTypeInfo superType;
    private ClassTypeInfo type;
    private Doc doc;
    private boolean jsonifiable;
    private AnnotationValueInfoFactory annotationValueInfoFactory;

    public DataObjectModel(Elements elementUtils, Types typeUtils, TypeElement modelElt, Messager messager) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.typeFactory = new TypeMirrorFactory(elementUtils, typeUtils);
        this.docFactory = new Doc.Factory(messager, elementUtils, typeUtils, this.typeFactory, modelElt);
        this.modelElt = modelElt;
        this.annotationValueInfoFactory = new AnnotationValueInfoFactory(elementUtils, typeUtils);
    }

    @Override
    public String getKind() {
        return "dataObject";
    }

    @Override
    public Element getElement() {
        return this.modelElt;
    }

    @Override
    public String getFqn() {
        return this.type.getName();
    }

    public ClassTypeInfo getType() {
        return this.type;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public boolean isAbstract() {
        return !this.concrete;
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public Set<ClassTypeInfo> getImportedTypes() {
        return this.importedTypes;
    }

    public Map<String, PropertyInfo> getPropertyMap() {
        return this.propertyMap;
    }

    public ClassTypeInfo getSuperType() {
        return this.superType;
    }

    public Set<ClassTypeInfo> getAbstractSuperTypes() {
        return this.abstractSuperTypes;
    }

    public Set<ClassTypeInfo> getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public ModuleInfo getModule() {
        return this.type.getRaw().getModule();
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean getGenerateConverter() {
        return this.generateConverter;
    }

    public boolean isJsonifiable() {
        return this.jsonifiable;
    }

    public boolean getInheritConverter() {
        return this.inheritConverter;
    }

    public boolean hasEmptyConstructor() {
        return (this.constructors & 1) == 1;
    }

    @Override
    public Map<String, Object> getVars() {
        Map<String, Object> vars = Model.super.getVars();
        vars.put("type", this.type);
        vars.put("doc", this.doc);
        vars.put("generateConverter", this.generateConverter);
        vars.put("inheritConverter", this.inheritConverter);
        vars.put("concrete", this.concrete);
        vars.put("isClass", this.isClass);
        vars.put("properties", this.propertyMap.values());
        vars.put("importedTypes", this.importedTypes);
        vars.put("superTypes", this.superTypes);
        vars.put("superType", this.superType);
        vars.put("abstractSuperTypes", this.abstractSuperTypes);
        vars.put("jsonifiable", this.jsonifiable);
        vars.put("hasEmptyConstructor", this.hasEmptyConstructor());
        return vars;
    }

    boolean process() {
        if (!this.processed) {
            if (this.modelElt.getKind() == ElementKind.INTERFACE || this.modelElt.getKind() == ElementKind.CLASS) {
                this.traverse();
                this.processImportedTypes();
                this.processed = true;
                return true;
            }
            throw new GenException(this.modelElt, "Data object " + this.modelElt + " must be an interface or a class");
        }
        return false;
    }

    private void traverse() {
        boolean hasJsonConstructor;
        DataObject ann = this.modelElt.getAnnotation(DataObject.class);
        this.generateConverter = ann.generateConverter();
        this.inheritConverter = ann.inheritConverter();
        this.isClass = this.modelElt.getKind() == ElementKind.CLASS;
        this.concrete = this.isClass && !this.modelElt.getModifiers().contains((Object)Modifier.ABSTRACT);
        try {
            this.type = (ClassTypeInfo)this.typeFactory.create(this.modelElt.asType());
        }
        catch (ClassCastException e2) {
            throw new GenException(this.modelElt, "Data object must be a plain java class with no type parameters");
        }
        Helper.checkUnderModule(this, "@VertxGen");
        this.doc = this.docFactory.createDoc(this.modelElt);
        if (this.getModule() == null) {
            throw new GenException(this.modelElt, "Data object must have an ancestor package annotated with @ModuleGen");
        }
        this.modelElt.getInterfaces().stream().filter(superTM -> superTM instanceof DeclaredType && ((DeclaredType)superTM).asElement().getAnnotation(DataObject.class) != null).map(e -> (ClassTypeInfo)this.typeFactory.create((TypeMirror)e)).forEach(this.abstractSuperTypes::add);
        this.superTypes.addAll(this.abstractSuperTypes);
        TypeMirror superClass = this.modelElt.getSuperclass();
        if (superClass instanceof DeclaredType && ((DeclaredType)superClass).asElement().getAnnotation(DataObject.class) != null) {
            this.superType = (ClassTypeInfo)this.typeFactory.create(superClass);
            this.superTypes.add(this.superType);
        }
        ArrayList<ExecutableElement> methodsElt = new ArrayList<ExecutableElement>();
        for (Element element : this.elementUtils.getAllMembers(this.modelElt)) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    ExecutableElement constrElt = (ExecutableElement)element;
                    this.processConstructor(constrElt);
                    break;
                }
                case METHOD: {
                    ExecutableElement methodElt = (ExecutableElement)element;
                    if (methodElt.getSimpleName().toString().equals("toJson") && methodElt.getParameters().isEmpty() && this.typeFactory.create(methodElt.getReturnType()).getKind() == ClassKind.JSON_OBJECT) {
                        this.jsonifiable = true;
                    }
                    if (methodElt.getAnnotation(GenIgnore.class) != null) break;
                    methodsElt.add(methodElt);
                    break;
                }
            }
        }
        this.processMethods(methodsElt);
        boolean bl = hasJsonConstructor = (this.constructors & 2) == 2;
        if (this.concrete && !hasJsonConstructor) {
            throw new GenException(this.modelElt, "Data object " + this.modelElt + " class does not have a constructor " + this.modelElt.getSimpleName() + "(" + JsonObject.class.getSimpleName() + ")");
        }
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>(this.propertyMap.values());
        Collections.sort(arrayList, (p1, p2) -> p1.name.compareTo(p2.name));
        this.propertyMap.clear();
        arrayList.forEach(prop -> this.propertyMap.put(prop.name, (PropertyInfo)prop));
    }

    private void processImportedTypes() {
        for (PropertyInfo property : this.propertyMap.values()) {
            property.type.collectImports(this.importedTypes);
        }
        this.importedTypes.addAll(this.superTypes.stream().collect(Collectors.toList()));
        Iterator<ClassTypeInfo> i = this.importedTypes.iterator();
        while (i.hasNext()) {
            ClassTypeInfo importedType = i.next();
            if (!importedType.getPackageName().equals(this.type.getPackageName())) continue;
            i.remove();
        }
    }

    private void processConstructor(ExecutableElement constrElt) {
        Element ownerElt;
        if (constrElt.getModifiers().contains((Object)Modifier.PUBLIC) && (ownerElt = constrElt.getEnclosingElement()).equals(this.modelElt)) {
            List<? extends VariableElement> parameters = constrElt.getParameters();
            int size = parameters.size();
            if (size == 1) {
                ClassTypeInfo cl;
                TypeInfo ti = this.typeFactory.create(parameters.get(0).asType());
                if (ti instanceof ClassTypeInfo && (cl = (ClassTypeInfo)ti).getKind() == ClassKind.JSON_OBJECT) {
                    this.constructors |= 2;
                }
            } else if (size == 0) {
                this.constructors |= 1;
            }
        }
    }

    private void processMethods(List<ExecutableElement> methodsElt) {
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> adders = new HashMap<String, ExecutableElement>();
        HashMap<String, List> annotations = new HashMap<String, List>();
        BiFunction<List, List, List> merger = (a, b) -> {
            if (b.size() > 0) {
                if (!(a instanceof ArrayList)) {
                    a = new ArrayList(a);
                }
                a.addAll(b);
            }
            return a;
        };
        while (methodsElt.size() > 0) {
            String name;
            ExecutableElement methodElt = methodsElt.remove(0);
            if (((TypeElement)methodElt.getEnclosingElement()).getQualifiedName().toString().equals("java.lang.Object")) continue;
            String methodName = methodElt.getSimpleName().toString();
            if (methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && methodElt.getParameters().isEmpty() && methodElt.getReturnType().getKind() != TypeKind.VOID) {
                name = Helper.normalizePropertyName(methodName.substring(3));
                getters.put(name, methodElt);
                annotations.merge(name, this.elementUtils.getAllAnnotationMirrors(methodElt), merger);
                continue;
            }
            if (methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) && methodElt.getParameters().isEmpty() && methodElt.getReturnType().getKind() != TypeKind.VOID) {
                name = Helper.normalizePropertyName(methodName.substring(2));
                getters.put(name, methodElt);
                annotations.merge(name, this.elementUtils.getAllAnnotationMirrors(methodElt), merger);
                continue;
            }
            if (!methodName.startsWith("set") && !methodName.startsWith("add") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3))) continue;
            String prefix = methodName.substring(0, 3);
            String name2 = Helper.normalizePropertyName(methodName.substring(3));
            int numParams = methodElt.getParameters().size();
            if ("add".equals(prefix)) {
                if (name2.endsWith("s")) {
                    throw new GenException(methodElt, "Option adder name must not terminate with 's' char");
                }
                name2 = name2 + "s";
                TypeMirror t = methodElt.getParameters().get(0).asType();
                if (numParams != 1 && (numParams != 2 || t.getKind() != TypeKind.DECLARED || !((TypeElement)((DeclaredType)t).asElement()).getQualifiedName().toString().equals("java.lang.String"))) continue;
                adders.put(name2, methodElt);
                annotations.merge(name2, this.elementUtils.getAllAnnotationMirrors(methodElt), merger);
                continue;
            }
            if (numParams != 1) continue;
            setters.put(name2, methodElt);
            annotations.merge(name2, this.elementUtils.getAllAnnotationMirrors(methodElt), merger);
        }
        HashSet names = new HashSet();
        names.addAll(getters.keySet());
        names.addAll(setters.keySet());
        names.addAll(adders.keySet());
        for (String name : names) {
            List list = this.getElement().getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.FIELD) && e.getSimpleName().toString().equals(name)).flatMap(e -> this.elementUtils.getAllAnnotationMirrors((Element)e).stream()).collect(Collectors.toList());
            if (list.size() <= 0) continue;
            annotations.merge(name, list, merger);
        }
        for (String name : names) {
            this.processMethod(name, (ExecutableElement)getters.get(name), (ExecutableElement)setters.get(name), (ExecutableElement)adders.get(name), (List)annotations.get(name));
        }
    }

    private void processMethod(String name, ExecutableElement getterElt, ExecutableElement setterElt, ExecutableElement adderElt, List<AnnotationMirror> annotationMirrors) {
        boolean jsonifiable;
        VariableElement paramElt;
        PropertyKind propKind = null;
        TypeInfo propType = null;
        TypeMirror propTypeMirror = null;
        if (setterElt != null) {
            paramElt = setterElt.getParameters().get(0);
            propTypeMirror = paramElt.asType();
            propType = this.typeFactory.create(propTypeMirror);
            propKind = PropertyKind.forType(propType.getKind());
            switch (propKind) {
                case LIST: 
                case SET: {
                    propType = ((ParameterizedTypeInfo)propType).getArgs().get(0);
                    propTypeMirror = ((DeclaredType)propTypeMirror).getTypeArguments().get(0);
                    break;
                }
                case MAP: {
                    propType = ((ParameterizedTypeInfo)propType).getArgs().get(1);
                    propTypeMirror = ((DeclaredType)propTypeMirror).getTypeArguments().get(1);
                }
            }
        }
        if (getterElt != null) {
            TypeMirror getterTypeMirror = getterElt.getReturnType();
            TypeInfo getterType = this.typeFactory.create(getterTypeMirror);
            PropertyKind getterKind = PropertyKind.forType(getterType.getKind());
            switch (getterKind) {
                case LIST: 
                case SET: {
                    getterType = ((ParameterizedTypeInfo)getterType).getArgs().get(0);
                    getterTypeMirror = ((DeclaredType)getterTypeMirror).getTypeArguments().get(0);
                    break;
                }
                case MAP: {
                    getterType = ((ParameterizedTypeInfo)getterType).getArgs().get(1);
                    getterTypeMirror = ((DeclaredType)getterTypeMirror).getTypeArguments().get(1);
                }
            }
            if (propType != null) {
                if (propKind != getterKind) {
                    throw new GenException(getterElt, name + " getter " + (Object)((Object)getterKind) + " does not match the setter " + (Object)((Object)propKind));
                }
                if (!getterType.equals(propType)) {
                    throw new GenException(getterElt, name + " getter type " + getterType + " does not match the setter type " + propType);
                }
            } else {
                propTypeMirror = getterTypeMirror;
                propType = getterType;
                propKind = getterKind;
            }
        }
        if (adderElt != null) {
            switch (adderElt.getParameters().size()) {
                case 1: {
                    paramElt = adderElt.getParameters().get(0);
                    TypeMirror adderTypeMirror = paramElt.asType();
                    TypeInfo adderType = this.typeFactory.create(adderTypeMirror);
                    if (propTypeMirror != null) {
                        if (propKind != PropertyKind.LIST && propKind != PropertyKind.SET) {
                            throw new GenException(adderElt, name + "adder does not correspond to non list/set");
                        }
                        if (adderType.equals(propType)) break;
                        throw new GenException(adderElt, name + " adder type " + adderType + "  does not match the property type " + propType);
                    }
                    propTypeMirror = adderTypeMirror;
                    propType = adderType;
                    propKind = PropertyKind.LIST;
                    break;
                }
                case 2: {
                    paramElt = adderElt.getParameters().get(1);
                    TypeMirror adderTypeMirror = paramElt.asType();
                    TypeInfo adderType = this.typeFactory.create(adderTypeMirror);
                    if (propTypeMirror != null) {
                        if (propKind != PropertyKind.MAP) {
                            throw new GenException(adderElt, name + "adder does not correspond to non map");
                        }
                        if (adderType.equals(propType)) break;
                        throw new GenException(adderElt, name + " adder type " + adderType + "  does not match the property type " + propType);
                    }
                    propTypeMirror = adderTypeMirror;
                    propType = adderType;
                    propKind = PropertyKind.MAP;
                    break;
                }
            }
        }
        switch (propType.getKind()) {
            case OBJECT: {
                if (propKind == PropertyKind.VALUE) {
                    return;
                }
            }
            case PRIMITIVE: 
            case BOXED_PRIMITIVE: 
            case STRING: 
            case API: 
            case JSON_OBJECT: 
            case JSON_ARRAY: 
            case ENUM: {
                jsonifiable = true;
                break;
            }
            case DATA_OBJECT: {
                Element propTypeElt = this.typeUtils.asElement(propTypeMirror);
                jsonifiable = propTypeElt.getAnnotation(DataObject.class) == null || Helper.isJsonifiable(this.elementUtils, this.typeUtils, (TypeElement)propTypeElt);
                break;
            }
            default: {
                return;
            }
        }
        boolean declared = false;
        Doc doc = null;
        for (ExecutableElement methodElt : Arrays.asList(setterElt, adderElt, getterElt)) {
            if (methodElt == null) continue;
            Function<Boolean, Stream> overridenMeths = annotated -> {
                Set<DeclaredType> ancestorTypes = Helper.resolveAncestorTypes(this.modelElt, true, true);
                return ancestorTypes.stream().map(DeclaredType::asElement).filter(elt -> annotated == false || elt.getAnnotation(DataObject.class) != null).flatMap(Helper.cast(TypeElement.class)).flatMap(elt -> this.elementUtils.getAllMembers((TypeElement)elt).stream()).flatMap(Helper.instanceOf(ExecutableElement.class)).filter(executableElt -> executableElt.getKind() == ElementKind.METHOD && this.elementUtils.overrides(methodElt, (ExecutableElement)executableElt, this.modelElt));
            };
            if (doc == null && (doc = this.docFactory.createDoc(methodElt)) == null) {
                Optional<Doc> first = overridenMeths.apply(false).map(this.docFactory::createDoc).filter(d -> d != null).findFirst();
                doc = first.orElse(null);
            }
            if (declared) continue;
            Element ownerElt = methodElt.getEnclosingElement();
            if (ownerElt.equals(this.modelElt)) {
                Object[] arr = overridenMeths.apply(true).limit(1L).filter(elt -> !elt.getModifiers().contains((Object)Modifier.ABSTRACT)).toArray();
                declared = arr.length == 0;
                continue;
            }
            declared = ownerElt.getAnnotation(DataObject.class) == null;
        }
        ArrayList<AnnotationValueInfo> annotationValueInfos = new ArrayList<AnnotationValueInfo>();
        if (annotationMirrors != null) {
            annotationMirrors.stream().map(this.annotationValueInfoFactory::processAnnotation).forEach(annotationValueInfos::add);
        }
        PropertyInfo property = new PropertyInfo(declared, name, doc, propType, setterElt != null ? setterElt.getSimpleName().toString() : null, adderElt != null ? adderElt.getSimpleName().toString() : null, getterElt != null ? getterElt.getSimpleName().toString() : null, annotationValueInfos, propKind, jsonifiable);
        this.propertyMap.put(property.name, property);
    }
}

