/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.EnumValueInfo;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeInfo;
import io.vertx.codegen.doc.Doc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class EnumModel
implements Model {
    private final Doc.Factory docFactory;
    protected final Elements elementUtils;
    protected final Types typeUtils;
    protected final TypeElement modelElt;
    protected TypeInfo.Class.Enum type;
    private Doc doc;
    private List<EnumValueInfo> values;
    private boolean processed;

    public EnumModel(Messager messager, Elements elementUtils, Types typeUtils, TypeElement modelElt) {
        this.docFactory = new Doc.Factory(messager, elementUtils, typeUtils, new TypeInfo.Factory(elementUtils, typeUtils), modelElt);
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.modelElt = modelElt;
    }

    boolean process() {
        if (!this.processed) {
            if (this.modelElt.getKind() != ElementKind.ENUM) {
                throw new GenException(this.modelElt, "@VertxGen can only be used with interfaces or enums" + this.modelElt.asType().toString());
            }
            this.doc = this.docFactory.createDoc(this.modelElt);
            this.type = (TypeInfo.Class.Enum)new TypeInfo.Factory(this.elementUtils, this.typeUtils).create(this.modelElt.asType());
            Helper.checkUnderModule(this, "@VertxGen");
            this.values = this.elementUtils.getAllMembers(this.modelElt).stream().filter(elt -> elt.getKind() == ElementKind.ENUM_CONSTANT).flatMap(Helper.cast(VariableElement.class)).map(elt -> new EnumValueInfo(elt.getSimpleName().toString(), this.docFactory.createDoc((Element)elt))).collect(Collectors.toList());
            if (this.values.isEmpty()) {
                throw new GenException(this.modelElt, "No empty enums");
            }
            this.processed = true;
            return true;
        }
        return false;
    }

    public TypeInfo.Class.Enum getType() {
        return this.type;
    }

    public List<EnumValueInfo> getValues() {
        return this.values;
    }

    public Doc getDoc() {
        return this.doc;
    }

    @Override
    public String getKind() {
        return "enum";
    }

    @Override
    public Element getElement() {
        return this.modelElt;
    }

    @Override
    public String getFqn() {
        return this.modelElt.getQualifiedName().toString();
    }

    @Override
    public Map<String, Object> getVars() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("type", this.getType());
        vars.put("doc", this.doc);
        vars.put("helper", new Helper());
        vars.put("values", this.values);
        return vars;
    }

    @Override
    public ModuleInfo getModule() {
        return this.type.getModule();
    }
}

