/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import java.util.HashMap;
import java.util.Map;

public enum ClassKind {
    STRING(true, false, false),
    BOXED_PRIMITIVE(true, false, false),
    PRIMITIVE(true, false, false),
    ENUM(false, false, false),
    JSON_OBJECT(false, true, false),
    JSON_ARRAY(false, true, false),
    THROWABLE(false, false, false),
    VOID(false, false, false),
    OBJECT(false, false, false),
    LIST(false, false, true),
    SET(false, false, true),
    MAP(false, false, true),
    API(false, false, false),
    DATA_OBJECT(false, false, false),
    HANDLER(false, false, false),
    ASYNC_RESULT(false, false, false),
    OTHER(false, false, false);

    public final boolean basic;
    public final boolean json;
    public final boolean collection;

    private ClassKind(boolean basic, boolean json, boolean collection) {
        this.basic = basic;
        this.json = json;
        this.collection = collection;
    }

    public static Map<String, ClassKind> vars() {
        HashMap<String, ClassKind> vars = new HashMap<String, ClassKind>();
        for (ClassKind classKind : ClassKind.values()) {
            vars.put("CLASS_" + classKind.name(), classKind);
        }
        return vars;
    }
}

