/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.AnnotationResolver;
import io.vertx.codegen.ClassKind;
import io.vertx.codegen.Variance;
import io.vertx.codegen.annotations.Options;
import io.vertx.codegen.annotations.VertxGen;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class Helper {
    static final Function<Element, Stream<ExecutableElement>> FILTER_METHOD = element -> {
        if (element.getKind() == ElementKind.METHOD) {
            return Stream.of((ExecutableElement)element);
        }
        return Stream.empty();
    };

    public static ClassKind getKind(AnnotationResolver annotations, String fqcn) {
        if (annotations.get(Options.class) != null) {
            return ClassKind.OPTIONS;
        }
        if (annotations.get(VertxGen.class) != null) {
            return ClassKind.API;
        }
        if (fqcn.equals("io.vertx.core.Handler")) {
            return ClassKind.HANDLER;
        }
        if (fqcn.equals("io.vertx.core.AsyncResult")) {
            return ClassKind.ASYNC_RESULT;
        }
        if (fqcn.equals("io.vertx.core.json.JsonArray")) {
            return ClassKind.JSON_ARRAY;
        }
        if (fqcn.equals("io.vertx.core.json.JsonObject")) {
            return ClassKind.JSON_OBJECT;
        }
        if (fqcn.equals(Object.class.getName())) {
            return ClassKind.OBJECT;
        }
        if (fqcn.equals(String.class.getName())) {
            return ClassKind.STRING;
        }
        if (fqcn.equals(List.class.getName())) {
            return ClassKind.LIST;
        }
        if (fqcn.equals(Set.class.getName())) {
            return ClassKind.SET;
        }
        if (fqcn.equals(Map.class.getName())) {
            return ClassKind.MAP;
        }
        if (fqcn.equals(Throwable.class.getName())) {
            return ClassKind.THROWABLE;
        }
        if (fqcn.equals(Void.class.getName())) {
            return ClassKind.VOID;
        }
        if (fqcn.equals(Integer.class.getName()) || fqcn.equals(Long.class.getName()) || fqcn.equals(Boolean.class.getName()) || fqcn.equals(Double.class.getName()) || fqcn.equals(Float.class.getName()) || fqcn.equals(Short.class.getName()) || fqcn.equals(Character.class.getName()) || fqcn.equals(Byte.class.getName())) {
            return ClassKind.BOXED_PRIMITIVE;
        }
        return ClassKind.OTHER;
    }

    public static String normalizePropertyName(String propertyName) {
        if (Character.isUpperCase(propertyName.charAt(0))) {
            StringBuilder buffer = new StringBuilder(propertyName);
            int index = 0;
            do {
                buffer.setCharAt(index, Character.toLowerCase(buffer.charAt(index++)));
            } while (index < buffer.length() && Character.isUpperCase(buffer.charAt(index)) && (index + 1 >= buffer.length() || !Character.isLowerCase(buffer.charAt(index + 1))));
            propertyName = buffer.toString();
        }
        return propertyName;
    }

    public static String decapitaliseFirstLetter(String str) {
        if (str.length() == 0) {
            return str;
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String convertCamelCaseToUnderscores(String str) {
        return str.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z\\d])([A-Z])", "$1_$2").toLowerCase();
    }

    public static String getSimpleName(String type) {
        return type.substring(type.lastIndexOf(46) + 1);
    }

    public static String getPackageName(String type) {
        int index = type.lastIndexOf(46);
        if (index >= 0) {
            return type.substring(0, index);
        }
        return "";
    }

    public static String getNonGenericType(String type) {
        int pos = type.indexOf("<");
        if (pos >= 0) {
            String nonGenericType = type.substring(0, pos);
            return nonGenericType;
        }
        return type;
    }

    public static String indentString(String str, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            sb.append(ch);
            if (ch != '\n' || i == str.length() - 1) continue;
            sb.append(indent);
        }
        return sb.toString();
    }

    public static String getJavadocTag(String comment, String tagName) {
        int pos = comment.indexOf(tagName);
        int endPos = comment.indexOf("\n", pos);
        String tag = comment.substring(pos + tagName.length() + 1, endPos);
        return tag;
    }

    public static String removeTags(String comment) {
        int pos = comment.indexOf(64);
        if (pos == -1) {
            return comment;
        }
        if (pos > 0) {
            String beforePos = comment.substring(0, pos);
            int prevReturn = beforePos.lastIndexOf(10);
            pos = prevReturn != -1 ? prevReturn : 0;
        }
        return comment.substring(0, pos);
    }

    public static boolean resolveSiteVariance(TypeParameterElement typeParam, Variance variance) {
        return Helper.resolveVariance(Collections.emptyMap(), typeParam, variance);
    }

    private static boolean resolveVariance(Map<TypeParameterElement, Variance> wantMap, TypeParameterElement typeParam, Variance variance) {
        if (wantMap.containsKey(typeParam)) {
            return wantMap.get(typeParam) == variance;
        }
        wantMap = new HashMap<TypeParameterElement, Variance>(wantMap);
        wantMap.put(typeParam, variance);
        TypeVariable typeVar = (TypeVariable)typeParam.asType();
        TypeElement genericElt = (TypeElement)typeParam.getGenericElement();
        for (TypeMirror typeMirror : genericElt.getInterfaces()) {
            Boolean checked;
            if (typeMirror.getKind() != TypeKind.DECLARED || (checked = Helper.resolveSiteVariance(wantMap, typeVar, Variance.COVARIANT, typeMirror, variance)) == null || checked.booleanValue()) continue;
            return checked;
        }
        block4: for (Element element : genericElt.getEnclosedElements()) {
            switch (element.getKind()) {
                case METHOD: {
                    ExecutableElement methodElt = (ExecutableElement)element;
                    if (methodElt.getModifiers().contains((Object)Modifier.STATIC)) break;
                    TypeMirror returnType = methodElt.getReturnType();
                    Boolean checked = Helper.resolveSiteVariance(wantMap, typeVar, Variance.COVARIANT, returnType, variance);
                    if (checked != null && !checked.booleanValue()) {
                        return checked;
                    }
                    for (VariableElement variableElement : methodElt.getParameters()) {
                        TypeMirror paramType = variableElement.asType();
                        checked = Helper.resolveSiteVariance(wantMap, typeVar, Variance.CONTRAVARIANT, paramType, variance);
                        if (checked == null || checked.booleanValue()) continue;
                        return checked;
                    }
                    continue block4;
                }
            }
        }
        return true;
    }

    private static Boolean resolveSiteVariance(Map<TypeParameterElement, Variance> wantMap, TypeVariable typeParam, Variance position, TypeMirror type, Variance variance) {
        if (type.getKind() == TypeKind.TYPEVAR) {
            if (typeParam.equals(type)) {
                switch (position) {
                    case COVARIANT: {
                        return variance == Variance.COVARIANT;
                    }
                    case CONTRAVARIANT: {
                        return variance == Variance.CONTRAVARIANT;
                    }
                }
                throw new AssertionError();
            }
        } else if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement typeElt = (TypeElement)declaredType.asElement();
            List<? extends TypeParameterElement> typeParams = typeElt.getTypeParameters();
            List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
            block8: for (int i = 0; i < typeArgs.size(); ++i) {
                TypeParameterElement abc = typeParams.get(i);
                switch (position) {
                    case COVARIANT: {
                        Boolean checked;
                        if (Helper.resolveVariance(wantMap, abc, Variance.COVARIANT) && (checked = Helper.resolveSiteVariance(wantMap, typeParam, Variance.COVARIANT, typeArgs.get(i), variance)) != null && !checked.booleanValue()) {
                            return false;
                        }
                        if (!Helper.resolveVariance(wantMap, abc, Variance.CONTRAVARIANT) || (checked = Helper.resolveSiteVariance(wantMap, typeParam, Variance.CONTRAVARIANT, typeArgs.get(i), variance)) == null || checked.booleanValue()) continue block8;
                        return false;
                    }
                    case CONTRAVARIANT: {
                        Boolean checked;
                        if (Helper.resolveVariance(wantMap, abc, Variance.COVARIANT) && (checked = Helper.resolveSiteVariance(wantMap, typeParam, Variance.CONTRAVARIANT, typeArgs.get(i), variance)) != null && !checked.booleanValue()) {
                            return false;
                        }
                        if (!Helper.resolveVariance(wantMap, abc, Variance.CONTRAVARIANT) || (checked = Helper.resolveSiteVariance(wantMap, typeParam, Variance.COVARIANT, typeArgs.get(i), variance)) == null || checked.booleanValue()) continue block8;
                        return false;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        return true;
    }

    public static AnnotationMirror resolveMethodAnnotation(Class<? extends Annotation> annotationType, Elements elementUtils, Types typeUtils, TypeElement declaring, ExecutableElement method) {
        return Helper.resolveMethodAnnotation((DeclaredType)elementUtils.getTypeElement(annotationType.getName()).asType(), elementUtils, typeUtils, declaring, method);
    }

    public static AnnotationMirror resolveMethodAnnotation(DeclaredType annotationType, Elements elementUtils, Types typeUtils, TypeElement declaring, ExecutableElement method) {
        Optional<AnnotationMirror> annotation = method.getAnnotationMirrors().stream().filter(mirror -> typeUtils.isSameType(mirror.getAnnotationType(), annotationType)).findFirst();
        if (annotation.isPresent()) {
            return annotation.get();
        }
        return Helper.isFluent(annotationType, elementUtils, typeUtils, declaring, method, method.getEnclosingElement().asType());
    }

    private static AnnotationMirror isFluent(DeclaredType annotationType, Elements elementUtils, Types typeUtils, TypeElement declaring, ExecutableElement method, TypeMirror type) {
        for (TypeMirror typeMirror : typeUtils.directSupertypes(type)) {
            Element directSuperTypeElt = typeUtils.asElement(typeMirror);
            if (!(directSuperTypeElt instanceof TypeElement)) continue;
            List methods = ((TypeElement)directSuperTypeElt).getEnclosedElements().stream().filter(member -> member.getKind() == ElementKind.METHOD).map(member -> (ExecutableElement)member).collect(Collectors.toList());
            for (ExecutableElement m : methods) {
                AnnotationMirror annotation;
                if (!elementUtils.overrides(method, m, declaring) || (annotation = Helper.resolveMethodAnnotation(annotationType, elementUtils, typeUtils, (TypeElement)directSuperTypeElt, m)) == null) continue;
                return annotation;
            }
            AnnotationMirror annotation = Helper.isFluent(annotationType, elementUtils, typeUtils, declaring, method, typeMirror);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static TypeMirror resolveTypeParameter(Types typeUtils, DeclaredType subType, TypeParameterElement typeParam) {
        TypeMirror erasedSubType;
        TypeMirror erased = typeUtils.erasure(typeParam.getGenericElement().asType());
        if (typeUtils.isSameType(erased, erasedSubType = typeUtils.erasure(subType))) {
            return typeParam.asType();
        }
        if (typeUtils.isSubtype(erasedSubType, erased)) {
            for (TypeMirror typeMirror : typeUtils.directSupertypes(subType)) {
                TypeMirror resolved = Helper.resolveTypeParameter(typeUtils, (DeclaredType)typeMirror, typeParam);
                if (resolved == null) continue;
                if (resolved.getKind() == TypeKind.TYPEVAR) {
                    return typeUtils.asMemberOf(subType, ((TypeVariable)resolved).asElement());
                }
                return resolved;
            }
        }
        return null;
    }
}

