/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.impl.http.SimpleHttpClient;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;

@VertxGen
public interface OpenIDConnectAuth {
    public static void discover(Vertx vertx, OAuth2Options config, Handler<AsyncResult<OAuth2Auth>> handler) {
        OpenIDConnectAuth.discover(vertx, config).onComplete(handler);
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2Options config) {
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        if (config.getSite() == null) {
            return ctx.failedFuture("issuer cannot be null");
        }
        config.replaceVariables(false);
        String oidc_discovery_path = "/.well-known/openid-configuration";
        String issuer = config.getSite();
        if (issuer.endsWith("/.well-known/openid-configuration")) {
            issuer = issuer.substring(0, issuer.length() - "/.well-known/openid-configuration".length());
        }
        SimpleHttpClient httpClient = new SimpleHttpClient(vertx, config.getUserAgent(), config.getHttpClientOptions());
        return httpClient.fetch(HttpMethod.GET, issuer + "/.well-known/openid-configuration", new JsonObject().put("Accept", (Object)"application/json"), null).compose(response -> {
            String issuerEndpoint;
            if (response.statusCode() != 200) {
                return ctx.failedFuture("Bad Response [" + response.statusCode() + "] " + response.body());
            }
            if (!response.is("application/json")) {
                return ctx.failedFuture("Cannot handle Content-Type: " + response.headers().get("Content-Type"));
            }
            JsonObject json = response.jsonObject();
            if (json == null) {
                return ctx.failedFuture("Cannot handle null JSON");
            }
            if (json.containsKey("error")) {
                return ctx.failedFuture(json.getString("error_description", json.getString("error")));
            }
            if (config.isValidateIssuer() && (issuerEndpoint = json.getString("issuer")) != null) {
                if (issuerEndpoint.endsWith("/")) {
                    issuerEndpoint = issuerEndpoint.substring(0, issuerEndpoint.length() - 1);
                }
                if (!config.getSite().equals(issuerEndpoint)) {
                    return ctx.failedFuture("issuer validation failed: received [" + issuerEndpoint + "]");
                }
            }
            config.setAuthorizationPath(json.getString("authorization_endpoint"));
            config.setTokenPath(json.getString("token_endpoint"));
            config.setLogoutPath(json.getString("end_session_endpoint"));
            config.setRevocationPath(json.getString("revocation_endpoint"));
            config.setUserInfoPath(json.getString("userinfo_endpoint"));
            config.setJwkPath(json.getString("jwks_uri"));
            config.setIntrospectionPath(json.getString("introspection_endpoint"));
            if (json.containsKey("issuer")) {
                JWTOptions jwtOptions = config.getJWTOptions();
                if (jwtOptions == null) {
                    jwtOptions = new JWTOptions();
                    config.setJWTOptions(jwtOptions);
                }
                jwtOptions.setIssuer(json.getString("issuer"));
            }
            config.setSupportedGrantTypes(null);
            if (json.containsKey("grant_types_supported") && config.getFlow() != null) {
                JsonArray flows = json.getJsonArray("grant_types_supported");
                flows.forEach(el -> config.addSupportedGrantType((String)el));
                if (!flows.contains((Object)config.getFlow().getGrantType())) {
                    return ctx.failedFuture("unsupported flow: " + config.getFlow().getGrantType() + ", allowed: " + flows);
                }
            }
            try {
                OAuth2Auth oidc = OAuth2Auth.create(vertx, config);
                if (config.getJwkPath() != null) {
                    return oidc.jWKSet().map((Object)oidc);
                }
                return ctx.succeededFuture((Object)oidc);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                return ctx.failedFuture((Throwable)e);
            }
        });
    }
}

