/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.impl.UserImpl;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Response;

public class AccessTokenImpl
extends UserImpl
implements AccessToken {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenImpl.class);
    private OAuth2Auth oAuth2Auth;

    public AccessTokenImpl() {
    }

    public AccessTokenImpl(JsonObject principal, OAuth2Auth oAuth2Auth) {
        super(principal);
        this.oAuth2Auth = oAuth2Auth;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.oAuth2Auth = (OAuth2Auth)authProvider;
    }

    @Override
    public boolean isScopeGranted() {
        return false;
    }

    @Override
    public JsonObject accessToken() {
        return this.attributes().getJsonObject("accessToken");
    }

    @Override
    public JsonObject idToken() {
        return this.attributes().getJsonObject("idToken");
    }

    @Override
    public String opaqueAccessToken() {
        return this.principal().getString("access_token");
    }

    @Override
    public String opaqueRefreshToken() {
        return this.principal().getString("refresh_token");
    }

    @Override
    public String opaqueIdToken() {
        return this.principal().getString("id_token");
    }

    @Override
    public String tokenType() {
        return this.principal().getString("token_type");
    }

    @Override
    public AccessToken setTrustJWT(boolean trust) {
        LOG.warn((Object)"This operation is not supported.");
        return this;
    }

    @Override
    public AccessToken refresh(Handler<AsyncResult<Void>> callback) {
        this.oAuth2Auth.refresh(this, (Handler<AsyncResult<User>>)((Handler)refresh -> {
            if (refresh.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)refresh.cause()));
            } else {
                User user = (User)refresh.result();
                this.attributes().mergeIn(user.attributes());
                this.principal().mergeIn(user.principal());
                callback.handle((Object)Future.succeededFuture());
            }
        }));
        return this;
    }

    @Override
    public AccessToken revoke(String token_type, Handler<AsyncResult<Void>> callback) {
        this.oAuth2Auth.revoke(this, token_type, (Handler<AsyncResult<Void>>)((Handler)revoke -> {
            if (revoke.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)revoke.cause()));
            } else {
                this.principal().remove(token_type);
                callback.handle((Object)Future.succeededFuture());
            }
        }));
        return this;
    }

    @Override
    public AccessToken logout(Handler<AsyncResult<Void>> callback) {
        LOG.warn((Object)"This operation is not supported, this was a Keycloak specific feature not a standard");
        callback.handle((Object)Future.failedFuture((Throwable)new UnsupportedOperationException()));
        return this;
    }

    @Override
    public AccessToken introspect(Handler<AsyncResult<Void>> callback) {
        LOG.warn((Object)"This operation is not supported, authenticate the user instead");
        callback.handle((Object)Future.failedFuture((Throwable)new UnsupportedOperationException()));
        return this;
    }

    @Override
    public AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> callback) {
        LOG.warn((Object)"This operation is not supported, authenticate the user instead");
        callback.handle((Object)Future.failedFuture((Throwable)new UnsupportedOperationException()));
        return this;
    }

    @Override
    public AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) {
        this.oAuth2Auth.userInfo(this, callback);
        return this;
    }

    @Override
    public AccessToken fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload, Handler<AsyncResult<OAuth2Response>> callback) {
        LOG.warn((Object)"This operation is not supported, use a WebClient instead");
        callback.handle((Object)Future.failedFuture((Throwable)new UnsupportedOperationException()));
        return this;
    }
}

