/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptionsConverter;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class OAuth2ClientOptions
extends HttpClientOptions {
    private static final OAuth2FlowType FLOW = OAuth2FlowType.AUTH_CODE;
    private static final String AUTHORIZATION_PATH = "/oauth/authorize";
    private static final String TOKEN_PATH = "/oauth/token";
    private static final String REVOKATION_PATH = "/oauth/revoke";
    private static final boolean USE_BASIC_AUTHORIZATION_HEADER = true;
    private static final String CLIENT_SECRET_PARAMETER_NAME = "client_secret";
    private static final JWTOptions JWT_OPTIONS = new JWTOptions();
    private static final String SCOPE_SEPARATOR = " ";
    private static final boolean VALIDATE_ISSUER = true;
    private OAuth2FlowType flow;
    private String authorizationPath;
    private String tokenPath;
    private String revocationPath;
    private String scopeSeparator;
    private boolean validateIssuer;
    private String logoutPath;
    private boolean useBasicAuthorizationHeader;
    private String clientSecretParameterName;
    private String userInfoPath;
    private JsonObject userInfoParams;
    private String introspectionPath;
    private String jwkPath;
    private String site;
    private String clientID;
    private String clientSecret;
    private String userAgent;
    private JsonObject headers;
    private List<PubSecKeyOptions> pubSecKeys;
    private JWTOptions jwtOptions;
    private JsonObject extraParams;

    public String getSite() {
        return this.site;
    }

    public OAuth2ClientOptions() {
        this.init();
    }

    public OAuth2ClientOptions(HttpClientOptions other) {
        super(other);
        this.init();
    }

    public OAuth2ClientOptions(OAuth2ClientOptions other) {
        super((HttpClientOptions)other);
        this.validateIssuer = other.isValidateIssuer();
        this.flow = other.getFlow();
        this.authorizationPath = other.getAuthorizationPath();
        this.tokenPath = other.getTokenPath();
        this.revocationPath = other.getRevocationPath();
        this.userInfoPath = other.getUserInfoPath();
        this.introspectionPath = other.getIntrospectionPath();
        this.scopeSeparator = other.getScopeSeparator();
        this.useBasicAuthorizationHeader = other.isUseBasicAuthorizationHeader();
        this.clientSecretParameterName = other.getClientSecretParameterName();
        this.site = other.getSite();
        this.clientID = other.getClientID();
        this.clientSecret = other.getClientSecret();
        this.pubSecKeys = other.getPubSecKeys();
        this.jwtOptions = other.getJWTOptions();
        this.logoutPath = other.getLogoutPath();
        JsonObject obj = other.getExtraParameters();
        this.extraParams = obj != null ? obj.copy() : null;
        JsonObject obj2 = other.getUserInfoParameters();
        this.userInfoParams = obj2 != null ? obj2.copy() : null;
        JsonObject obj3 = other.getHeaders();
        this.headers = obj3 != null ? obj3.copy() : null;
        this.jwkPath = other.getJwkPath();
    }

    private void init() {
        this.flow = FLOW;
        this.validateIssuer = true;
        this.authorizationPath = AUTHORIZATION_PATH;
        this.tokenPath = TOKEN_PATH;
        this.revocationPath = REVOKATION_PATH;
        this.scopeSeparator = SCOPE_SEPARATOR;
        this.useBasicAuthorizationHeader = true;
        this.clientSecretParameterName = CLIENT_SECRET_PARAMETER_NAME;
        this.jwtOptions = JWT_OPTIONS;
        this.userInfoParams = null;
        this.headers = null;
    }

    public OAuth2ClientOptions(JsonObject json) {
        super(json);
        this.init();
        OAuth2ClientOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getAuthorizationPath() {
        return this.authorizationPath;
    }

    public OAuth2ClientOptions setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = authorizationPath;
        return this;
    }

    public String getTokenPath() {
        return this.tokenPath;
    }

    public OAuth2ClientOptions setTokenPath(String tokenPath) {
        this.tokenPath = tokenPath;
        return this;
    }

    public String getRevocationPath() {
        return this.revocationPath;
    }

    public OAuth2ClientOptions setRevocationPath(String revocationPath) {
        this.revocationPath = revocationPath;
        return this;
    }

    @Deprecated
    public boolean isUseBasicAuthorizationHeader() {
        return this.useBasicAuthorizationHeader;
    }

    @Deprecated
    public OAuth2ClientOptions setUseBasicAuthorizationHeader(boolean useBasicAuthorizationHeader) {
        this.useBasicAuthorizationHeader = useBasicAuthorizationHeader;
        return this;
    }

    public String getClientSecretParameterName() {
        return this.clientSecretParameterName;
    }

    public OAuth2ClientOptions setClientSecretParameterName(String clientSecretParameterName) {
        this.clientSecretParameterName = clientSecretParameterName;
        return this;
    }

    public OAuth2ClientOptions setSite(String site) {
        this.site = site;
        return this;
    }

    public String getClientID() {
        return this.clientID;
    }

    public OAuth2ClientOptions setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OAuth2ClientOptions setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public OAuth2ClientOptions setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public OAuth2ClientOptions setHeaders(JsonObject headers) {
        this.headers = headers;
        return this;
    }

    public List<PubSecKeyOptions> getPubSecKeys() {
        return this.pubSecKeys;
    }

    public OAuth2ClientOptions setPubSecKeys(List<PubSecKeyOptions> pubSecKeys) {
        this.pubSecKeys = pubSecKeys;
        return this;
    }

    public OAuth2ClientOptions addPubSecKey(PubSecKeyOptions pubSecKey) {
        if (this.pubSecKeys == null) {
            this.pubSecKeys = new ArrayList<PubSecKeyOptions>();
        }
        this.pubSecKeys.add(pubSecKey);
        return this;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public OAuth2ClientOptions setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
        return this;
    }

    public String getUserInfoPath() {
        return this.userInfoPath;
    }

    public OAuth2ClientOptions setUserInfoPath(String userInfoPath) {
        this.userInfoPath = userInfoPath;
        return this;
    }

    @Deprecated
    public String getScopeSeparator() {
        return this.scopeSeparator;
    }

    @Deprecated
    public OAuth2ClientOptions setScopeSeparator(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
        return this;
    }

    public JsonObject getExtraParameters() {
        return this.extraParams;
    }

    public OAuth2ClientOptions setExtraParameters(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    public String getIntrospectionPath() {
        return this.introspectionPath;
    }

    public OAuth2ClientOptions setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = introspectionPath;
        return this;
    }

    public JsonObject getUserInfoParameters() {
        return this.userInfoParams;
    }

    public OAuth2ClientOptions setUserInfoParameters(JsonObject userInfoParams) {
        this.userInfoParams = userInfoParams;
        return this;
    }

    public String getJwkPath() {
        return this.jwkPath;
    }

    public OAuth2ClientOptions setJwkPath(String jwkPath) {
        this.jwkPath = jwkPath;
        return this;
    }

    public JWTOptions getJWTOptions() {
        return this.jwtOptions;
    }

    public OAuth2ClientOptions setJWTOptions(JWTOptions jwtOptions) {
        this.jwtOptions = jwtOptions;
        return this;
    }

    public OAuth2FlowType getFlow() {
        return this.flow;
    }

    public OAuth2ClientOptions setFlow(OAuth2FlowType flow) {
        this.flow = flow;
        return this;
    }

    public boolean isValidateIssuer() {
        return this.validateIssuer;
    }

    public OAuth2ClientOptions setValidateIssuer(boolean validateIssuer) {
        this.validateIssuer = validateIssuer;
        return this;
    }
}

