/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2RBAC;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.jwt.JWTOptions;
import java.util.Base64;
import java.util.regex.Pattern;

public abstract class OAuth2UserImpl
extends AbstractUser
implements AccessToken {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2UserImpl.class);
    private JsonObject principal;
    private transient OAuth2AuthProviderImpl provider;
    private transient OAuth2RBAC rbac;
    protected transient JsonObject accessToken;
    protected transient JsonObject refreshToken;
    protected transient JsonObject idToken;

    public OAuth2UserImpl() {
    }

    public OAuth2UserImpl(OAuth2Auth provider, JsonObject principal) {
        this.principal = principal;
        this.setAuthProvider(provider);
    }

    protected void init(JsonObject json) {
        this.clearCache();
        this.principal = json;
        if (this.principal != null) {
            if (!this.principal.containsKey("expires_at") && this.principal.containsKey("expires_in")) {
                Long expiresIn;
                try {
                    expiresIn = this.principal.getLong("expires_in");
                }
                catch (ClassCastException e) {
                    expiresIn = Long.valueOf(this.principal.getString("expires_in"));
                }
                this.principal.put("expires_at", Long.valueOf(System.currentTimeMillis() + 1000L * expiresIn));
            }
            if (this.provider != null) {
                Long exp;
                this.accessToken = this.decodeToken("access_token");
                if (!this.principal.containsKey("expires_at") && this.accessToken != null && (exp = this.accessToken.getLong("exp")) != null) {
                    this.principal.put("expires_at", Long.valueOf(exp * 1000L));
                }
                this.refreshToken = this.decodeToken("refresh_token", true);
                this.idToken = this.decodeToken("id_token");
                String scope = this.principal.getString("scope");
                if (scope != null) {
                    for (String authority : scope.split(Pattern.quote(this.provider.getConfig().getScopeSeparator()))) {
                        this.cachePermission(authority);
                    }
                }
            }
        }
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.provider = (OAuth2AuthProviderImpl)authProvider;
        this.rbac = this.provider.getRBACHandler();
        this.init(this.principal);
    }

    protected OAuth2AuthProviderImpl getProvider() {
        return this.provider;
    }

    public JsonObject principal() {
        return this.principal;
    }

    protected void doIsPermitted(String permission, Handler<AsyncResult<Boolean>> resultHandler) {
        if (this.expired()) {
            resultHandler.handle((Object)Future.failedFuture((String)"Expired Token"));
            return;
        }
        if (this.rbac == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"No RBAC Handler available"));
        } else {
            this.rbac.isAuthorized(this, permission, resultHandler);
        }
    }

    public void writeToBuffer(Buffer buff) {
        super.writeToBuffer(buff);
        if (this.principal != null) {
            Buffer buffer = this.principal.toBuffer();
            buff.appendInt(buffer.length());
            buff.appendBuffer(buffer);
        } else {
            buff.appendInt(0);
        }
    }

    public int readFromBuffer(int pos, Buffer buff) {
        pos = super.readFromBuffer(pos, buff);
        int len = buff.getInt(pos);
        pos += 4;
        if (len > 0) {
            Buffer buffer = buff.getBuffer(pos, pos + len);
            this.principal = new JsonObject(buffer);
            pos += len;
        } else {
            this.principal.clear();
        }
        this.init(this.principal);
        return pos;
    }

    protected JsonObject decodeToken(String tokenType) {
        return this.decodeToken(tokenType, false);
    }

    protected JsonObject decodeToken(String tokenType, boolean trust) {
        block6: {
            Object opaque = this.principal.getValue(tokenType);
            if (opaque == null) {
                return null;
            }
            if (opaque instanceof JsonObject) {
                return (JsonObject)opaque;
            }
            try {
                if (trust) {
                    String[] segments = ((String)opaque).split("\\.");
                    if (segments.length == 2 || segments.length == 3) {
                        String payloadSeg = segments[1];
                        return new JsonObject(Buffer.buffer((byte[])Base64.getUrlDecoder().decode(payloadSeg)));
                    }
                    break block6;
                }
                return this.provider.getJWT().decode((String)opaque);
            }
            catch (RuntimeException e) {
                LOG.debug((Object)"Cannot decode token:", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String opaqueAccessToken() {
        return this.principal.getString("access_token");
    }

    @Override
    public String opaqueRefreshToken() {
        return this.principal.getString("refresh_token");
    }

    @Override
    public String opaqueIdToken() {
        return this.principal.getString("id_token");
    }

    @Override
    public JsonObject accessToken() {
        if (this.accessToken != null) {
            return this.accessToken.copy();
        }
        return null;
    }

    @Override
    @Deprecated
    public JsonObject refreshToken() {
        if (this.refreshToken != null) {
            return this.refreshToken.copy();
        }
        return null;
    }

    @Override
    public JsonObject idToken() {
        if (this.idToken != null) {
            return this.idToken.copy();
        }
        return null;
    }

    @Override
    public boolean expired() {
        if (this.principal == null) {
            return true;
        }
        if (this.accessToken != null) {
            JWT jwt = this.provider.getJWT();
            JWTOptions options = this.provider.getConfig().getJWTOptions();
            try {
                jwt.isExpired(this.accessToken, options);
            }
            catch (RuntimeException e) {
                LOG.debug((Object)"Expired token:", (Throwable)e);
                return true;
            }
        }
        long now = System.currentTimeMillis();
        return this.principal.containsKey("expires_at") && this.principal.getLong("expires_at", Long.valueOf(0L)) < now;
    }
}

