require 'vertx/buffer'
require 'vertx/multi_map'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.OAuth2Response
module VertxAuthOauth2
  #  A response from a fetch request.
  # 
  #  This class represents a secure response from a Oauth2 fetch call.
  # 
  #  A fetch is a simplified HTTP response from a protected resource.
  class OAuth2Response
    # @private
    # @param j_del [::VertxAuthOauth2::OAuth2Response] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::OAuth2Response] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == OAuth2Response
    end
    def @@j_api_type.wrap(obj)
      OAuth2Response.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2::OAuth2Response.java_class
    end
    #  the returned status code from the HTTP layer.
    # @return [Fixnum] HTTP status code
    def status_code
      if !block_given?
        return @j_del.java_method(:statusCode, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling status_code()"
    end
    #  The HTTP response headers from the HTTP layer.
    # @return [::Vertx::MultiMap] the HTTP headers
    def headers
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headers, []).call(),::Vertx::MultiMap)
      end
      raise ArgumentError, "Invalid arguments when calling headers()"
    end
    #  Looks up a HTTP response header by name, in case where the response is a list of headers,
    #  the first one is returned.
    # @param [String] name of the header to look up
    # @return [String] the single value for the header.
    def get_header(name=nil)
      if name.class == String && !block_given?
        return @j_del.java_method(:getHeader, [Java::java.lang.String.java_class]).call(name)
      end
      raise ArgumentError, "Invalid arguments when calling get_header(#{name})"
    end
    #  The HTTP response body as a buffer
    # @return [::Vertx::Buffer] a buffer with the HTTP response body
    def body
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:body, []).call(),::Vertx::Buffer)
      end
      raise ArgumentError, "Invalid arguments when calling body()"
    end
    #  The HTTP response body as a JsonObject
    # @return [Hash{String => Object}] a JsonObject from the HTTP response body
    def json_object
      if !block_given?
        return @j_del.java_method(:jsonObject, []).call() != nil ? JSON.parse(@j_del.java_method(:jsonObject, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling json_object()"
    end
    #  The HTTP response body as a JsonArray
    # @return [Array<String,Object>] a JsonArray from the HTTP response body
    def json_array
      if !block_given?
        return @j_del.java_method(:jsonArray, []).call() != nil ? JSON.parse(@j_del.java_method(:jsonArray, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling json_array()"
    end
    #  Helper to analize the response body. The test is performed against the header Content-Type,
    #  the content of the body is not analyzed.
    # @param [String] contentType a content type to test, e.g.: application/json
    # @return [true,false] true if the header matches
    def is?(contentType=nil)
      if contentType.class == String && !block_given?
        return @j_del.java_method(:is, [Java::java.lang.String.java_class]).call(contentType)
      end
      raise ArgumentError, "Invalid arguments when calling is?(#{contentType})"
    end
  end
end
