/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;
import java.io.UnsupportedEncodingException;
import java.util.Base64;

abstract class AbstractOAuth2Flow
implements OAuth2Flow {
    protected final OAuth2AuthProviderImpl provider;
    protected final OAuth2ClientOptions config;

    AbstractOAuth2Flow(OAuth2AuthProviderImpl provider) {
        this.provider = provider;
        this.config = provider.getConfig();
    }

    void getToken(String grantType, JsonObject params, Handler<AsyncResult<JsonObject>> handler) {
        JsonObject tmp;
        JsonObject headers = new JsonObject();
        if (this.config.isUseBasicAuthorizationHeader()) {
            String basic = this.config.getClientID() + ":" + this.config.getClientSecret();
            headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString(basic.getBytes()));
        }
        if ((tmp = this.config.getHeaders()) != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = params.copy();
        if (this.config.getExtraParameters() != null) {
            form.mergeIn(this.config.getExtraParameters());
        }
        form.put("client_id", this.config.getClientID());
        form.put("grant_type", grantType);
        if (this.config.getClientSecretParameterName() != null) {
            form.put(this.config.getClientSecretParameterName(), this.config.getClientSecret());
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
        headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        OAuth2API.fetch(this.provider, HttpMethod.POST, this.config.getTokenPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            block17: {
                JsonObject json;
                if (res.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    return;
                }
                OAuth2Response reply = (OAuth2Response)res.result();
                if (reply.body() == null || reply.body().length() == 0) {
                    handler.handle((Object)Future.failedFuture((String)"No Body"));
                    return;
                }
                if (reply.is("application/json")) {
                    try {
                        json = reply.jsonObject();
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                    try {
                        json = OAuth2API.queryToJSON(reply.body().toString());
                    }
                    catch (UnsupportedEncodingException | RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((String)("Cannot handle content type: " + reply.headers().get("Content-Type"))));
                    return;
                }
                try {
                    if (json.containsKey("error")) {
                        String description;
                        Object error = json.getValue("error");
                        if (error instanceof JsonObject) {
                            description = ((JsonObject)error).getString("message");
                        } else {
                            try {
                                description = json.getString("error_description", json.getString("error"));
                            }
                            catch (RuntimeException e) {
                                description = error.toString();
                            }
                        }
                        handler.handle((Object)Future.failedFuture((String)description));
                        break block17;
                    }
                    handler.handle((Object)Future.succeededFuture((Object)json));
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
        }));
    }
}

