/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Map;

public class OAuth2API {
    public static void api(OAuth2AuthProviderImpl provider, HttpMethod method, String path, JsonObject params, Handler<AsyncResult<JsonObject>> callback) {
        String url = path.startsWith("http://") || path.startsWith("https://") ? path : provider.getConfig().getSite() + path;
        OAuth2API.call(provider, method, url, params, callback);
    }

    private static void call(OAuth2AuthProviderImpl provider, HttpMethod method, String uri, JsonObject params, Handler<AsyncResult<JsonObject>> callback) {
        HttpClient client;
        OAuth2ClientOptions config = provider.getConfig();
        if (config.getClientID() == null || config.getClientSecret() == null || config.getSite() == null) {
            callback.handle((Object)Future.failedFuture((String)"Configuration missing. You need to specify the client id, the client secret and the oauth2 server"));
            return;
        }
        JsonObject headers = new JsonObject();
        if (params.containsKey("access_token") && !params.containsKey("client_id")) {
            headers.put("Authorization", "Bearer " + params.getString("access_token"));
            params.remove("access_token");
        } else if (config.isUseBasicAuthorizationHeader() && config.getClientID() != null && !params.containsKey("client_id")) {
            String basic = config.getClientID() + ":" + config.getClientSecret();
            headers.put("Authorization", "Basic " + Base64.getUrlEncoder().encodeToString(basic.getBytes()));
        }
        JsonObject tmp = config.getHeaders();
        if (tmp != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = null;
        if (method != HttpMethod.GET) {
            form = params.copy();
        }
        if (method == HttpMethod.GET && uri.indexOf(63) != -1) {
            uri = uri + "&" + OAuth2API.stringify(params);
        }
        if (method != HttpMethod.GET && form != null) {
            form.put("client_id", config.getClientID());
            if (config.getClientSecretParameterName() != null) {
                form.put(config.getClientSecretParameterName(), config.getClientSecret());
            }
        }
        try {
            URL url = new URL(uri);
            boolean isSecure = "https".equalsIgnoreCase(url.getProtocol());
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = isSecure ? 443 : 80;
            }
            client = provider.getVertx().createHttpClient(new HttpClientOptions().setSsl(isSecure).setDefaultHost(host).setDefaultPort(port));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        HttpClientRequest request = client.request(method, uri, resp -> {
            if (resp.statusCode() >= 400) {
                callback.handle((Object)Future.failedFuture((String)resp.statusMessage()));
                client.close();
                return;
            }
            resp.exceptionHandler(t -> {
                callback.handle((Object)Future.failedFuture((Throwable)t));
                client.close();
            });
            resp.bodyHandler(body -> {
                if (body == null) {
                    callback.handle((Object)Future.failedFuture((String)"No Body"));
                    client.close();
                    return;
                }
                if (body.length() == 0) {
                    callback.handle((Object)Future.succeededFuture());
                    client.close();
                    return;
                }
                String contentType = resp.getHeader("Content-Type");
                int sep = contentType.indexOf(59);
                if (sep != -1) {
                    contentType = contentType.substring(0, sep);
                }
                switch (contentType) {
                    case "application/json": {
                        try {
                            callback.handle((Object)Future.succeededFuture((Object)new JsonObject(body.toString())));
                        }
                        catch (RuntimeException e) {
                            callback.handle((Object)Future.failedFuture((Throwable)e));
                        }
                        break;
                    }
                    case "application/x-www-form-urlencoded": {
                        try {
                            callback.handle((Object)Future.succeededFuture((Object)OAuth2API.queryToJSON(body.toString())));
                        }
                        catch (UnsupportedEncodingException | RuntimeException e) {
                            callback.handle((Object)Future.failedFuture((Throwable)e));
                        }
                        break;
                    }
                    case "text/plain": {
                        try {
                            callback.handle((Object)Future.succeededFuture((Object)OAuth2API.queryToJSON(body.toString())));
                        }
                        catch (UnsupportedEncodingException | RuntimeException e) {
                            callback.handle((Object)Future.failedFuture((Throwable)e));
                        }
                        break;
                    }
                    default: {
                        callback.handle((Object)Future.failedFuture((String)("Cannot handle content type: " + contentType)));
                    }
                }
                client.close();
            });
        });
        request.exceptionHandler(t -> {
            callback.handle((Object)Future.failedFuture((Throwable)t));
            client.close();
        });
        for (Map.Entry kv : headers) {
            request.putHeader((String)kv.getKey(), kv.getValue().toString());
        }
        if (config.getUserAgent() != null) {
            request.putHeader("User-Agent", config.getUserAgent());
        }
        request.putHeader("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        if (form != null) {
            request.putHeader("Content-Type", "application/x-www-form-urlencoded");
            String payload = OAuth2API.stringify(form);
            request.putHeader("Content-Length", Integer.toString(payload.length()));
            request.write(payload);
        }
        request.end();
    }

    public static String stringify(JsonObject json) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry kv : json) {
                sb.append(URLEncoder.encode((String)kv.getKey(), "UTF-8"));
                sb.append('=');
                Object v = kv.getValue();
                if (v != null) {
                    sb.append(URLEncoder.encode(v.toString(), "UTF-8"));
                }
                sb.append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static JsonObject queryToJSON(String query) throws UnsupportedEncodingException {
        String[] pairs;
        JsonObject json = new JsonObject();
        for (String pair : pairs = query.split("&")) {
            JsonArray array;
            String value;
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            if (!json.containsKey(key)) {
                json.put(key, value);
                continue;
            }
            Object oldValue = json.getValue(key);
            if (oldValue instanceof JsonArray) {
                array = (JsonArray)oldValue;
            } else {
                array = new JsonArray();
                array.add(oldValue);
                json.put(key, array);
            }
            if (value == null) {
                array.addNull();
                continue;
            }
            array.add(value);
        }
        return json;
    }
}

