/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.impl.AccessTokenImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;

public class AuthCodeImpl
implements OAuth2Flow {
    private final OAuth2AuthProviderImpl provider;

    public AuthCodeImpl(OAuth2AuthProviderImpl provider) {
        this.provider = provider;
    }

    @Override
    public String authorizeURL(JsonObject params) {
        JsonObject query = params.copy();
        OAuth2ClientOptions config = this.provider.getConfig();
        query.put("response_type", "code");
        query.put("client_id", config.getClientID());
        return config.getSite() + config.getAuthorizationPath() + '?' + OAuth2API.stringify(query);
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        JsonObject query = params.copy();
        query.put("grant_type", "authorization_code");
        OAuth2API.api(this.provider, HttpMethod.POST, this.provider.getConfig().getTokenPath(), query, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)new AccessTokenImpl(this.provider, (JsonObject)res.result())));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }
}

