/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.authorization.impl;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization;
import java.util.HashSet;

public class MicroProfileAuthorizationImpl
implements MicroProfileAuthorization {
    public String getId() {
        return "mp-jwt";
    }

    public Future<Void> getAuthorizations(User user) {
        JsonObject accessToken = user.attributes().getJsonObject("accessToken");
        if (accessToken == null) {
            return Future.failedFuture((String)"User doesn't contain a decoded Token");
        }
        HashSet<RoleBasedAuthorization> authorizations = new HashSet<RoleBasedAuthorization>();
        JsonArray groups = accessToken.getJsonArray("groups");
        if (groups != null && groups.size() >= 0) {
            for (Object el : groups) {
                if (el instanceof String) {
                    authorizations.add(RoleBasedAuthorization.create((String)((String)el)));
                    continue;
                }
                return Future.failedFuture((String)("Cannot parse role: " + String.valueOf(el)));
            }
        }
        user.authorizations().put(this.getId(), authorizations);
        return Future.succeededFuture();
    }
}

