/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;
import java.nio.charset.StandardCharsets;

public class JWTUser
extends AbstractUser {
    private static final Logger log = LoggerFactory.getLogger(JWTUser.class);
    private JsonObject jwtToken;
    private JsonArray permissions;

    public JWTUser() {
        log.info((Object)"You are probably serializing the JWT User, JWT are supposed to be used in stateless servers!");
    }

    public JWTUser(JsonObject jwtToken, String permissionsClaimKey) {
        this.jwtToken = jwtToken;
        if (permissionsClaimKey.contains("/")) {
            this.getNestedJsonValue(jwtToken, permissionsClaimKey);
        } else {
            this.permissions = jwtToken.getJsonArray(permissionsClaimKey, null);
        }
    }

    private void getNestedJsonValue(JsonObject jwtToken, String permissionsClaimKey) {
        String[] keys = permissionsClaimKey.split("/");
        JsonObject obj = null;
        for (int i = 0; i < keys.length; ++i) {
            if (i == 0) {
                obj = jwtToken.getJsonObject(keys[i]);
                continue;
            }
            if (i == keys.length - 1) {
                if (obj == null) continue;
                this.permissions = obj.getJsonArray(keys[i]);
                continue;
            }
            obj = obj.getJsonObject(keys[i]);
        }
    }

    public JsonObject principal() {
        return this.jwtToken;
    }

    public void setAuthProvider(AuthProvider authProvider) {
    }

    public void doIsPermitted(String permission, Handler<AsyncResult<Boolean>> handler) {
        if (this.permissions != null) {
            for (Object jwtPermission : this.permissions) {
                if (!permission.equals(jwtPermission)) continue;
                handler.handle((Object)Future.succeededFuture((Object)true));
                return;
            }
        }
        log.debug((Object)("User has no permission [" + permission + "]"));
        handler.handle((Object)Future.succeededFuture((Object)false));
    }

    public void writeToBuffer(Buffer buff) {
        super.writeToBuffer(buff);
        byte[] bytes = this.jwtToken.encode().getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
        bytes = this.permissions.encode().getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        pos = super.readFromBuffer(pos, buffer);
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.jwtToken = new JsonObject(new String(bytes, StandardCharsets.UTF_8));
        pos += len;
        len = buffer.getInt(pos);
        bytes = buffer.getBytes(pos += 4, pos + len);
        this.permissions = new JsonArray(new String(bytes, StandardCharsets.UTF_8));
        return pos += len;
    }
}

