/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.PRNG;
import java.util.Base64;

@VertxGen
public interface VertxContextPRNG {
    public static VertxContextPRNG current() {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null) {
            return VertxContextPRNG.current(currentContext);
        }
        throw new IllegalStateException("Not running in a Vert.x Context.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GenIgnore
    public static VertxContextPRNG current(Context context) {
        String contextKey = "__vertx.VertxContextPRNG";
        PRNG random = (PRNG)context.get("__vertx.VertxContextPRNG");
        if (random == null) {
            Context context2 = context;
            synchronized (context2) {
                random = (PRNG)context.get("__vertx.VertxContextPRNG");
                if (random == null) {
                    PRNG rand = random = new PRNG(context.owner());
                    context.put("__vertx.VertxContextPRNG", (Object)rand);
                }
            }
        }
        return random;
    }

    public static VertxContextPRNG current(Vertx vertx) {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null) {
            return VertxContextPRNG.current(currentContext);
        }
        return new PRNG(vertx);
    }

    @GenIgnore
    public void nextBytes(byte[] var1);

    default public String nextString(int length) {
        byte[] data = new byte[length];
        this.nextBytes(data);
        return Base64.getMimeEncoder().encodeToString(data);
    }

    public int nextInt();

    public int nextInt(int var1);
}

