/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.mysql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.ResultSet;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.DatabaseException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.mysql.MySQLConnection$;
import com.github.mauricio.async.db.mysql.MySQLQueryResult;
import com.github.mauricio.async.db.mysql.MySQLQueryResult$;
import com.github.mauricio.async.db.mysql.codec.MySQLConnectionHandler;
import com.github.mauricio.async.db.mysql.codec.MySQLHandlerDelegate;
import com.github.mauricio.async.db.mysql.exceptions.MySQLException;
import com.github.mauricio.async.db.mysql.message.client.HandshakeResponseMessage;
import com.github.mauricio.async.db.mysql.message.client.PreparedStatementMessage;
import com.github.mauricio.async.db.mysql.message.client.QueryMessage;
import com.github.mauricio.async.db.mysql.message.client.QuitMessage$;
import com.github.mauricio.async.db.mysql.message.server.EOFMessage;
import com.github.mauricio.async.db.mysql.message.server.ErrorMessage;
import com.github.mauricio.async.db.mysql.message.server.HandshakeMessage;
import com.github.mauricio.async.db.mysql.message.server.OkMessage;
import com.github.mauricio.async.db.mysql.util.CharsetMapper;
import com.github.mauricio.async.db.util.ChannelFutureTransformer$;
import com.github.mauricio.async.db.util.Log$;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t}w!B\u0001\u0003\u0011\u0003y\u0011aD'z'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!B7zgFd'BA\u0003\u0007\u0003\t!'M\u0003\u0002\b\u0011\u0005)\u0011m]=oG*\u0011\u0011BC\u0001\t[\u0006,(/[2j_*\u00111\u0002D\u0001\u0007O&$\b.\u001e2\u000b\u00035\t1aY8n\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011q\"T=T#2\u001buN\u001c8fGRLwN\\\n\u0003#Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\"B\u000e\u0012\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u001dq\u0012C1A\u0005\u0006}\tqaQ8v]R,'/F\u0001!!\t\t#&D\u0001#\u0015\t\u0019C%\u0001\u0004bi>l\u0017n\u0019\u0006\u0003K\u0019\n!bY8oGV\u0014(/\u001a8u\u0015\t9\u0003&\u0001\u0003vi&d'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\t\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019i\u0013\u0003)A\u0007A\u0005A1i\\;oi\u0016\u0014\b\u0005C\u00040#\t\u0007IQ\u0001\u0019\u0002'5K7M]8tK\u000e|g\u000eZ:WKJ\u001c\u0018n\u001c8\u0016\u0003E\u0002\"A\r\u001b\u000e\u0003MR!a\n\u0003\n\u0005U\u001a$a\u0002,feNLwN\u001c\u0005\u0007oE\u0001\u000bQB\u0019\u0002)5K7M]8tK\u000e|g\u000eZ:WKJ\u001c\u0018n\u001c8!\u0011\u001dI\u0014#%A\u0005\u0002i\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012T#A\u001e+\u0005q\n\u0005CA\u001f@\u001b\u0005q$BA\u0014\u0003\u0013\t\u0001eHA\u0007DQ\u0006\u00148/\u001a;NCB\u0004XM]\u0016\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u0012\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002J\t\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000f-\u000b\u0012\u0013!C\u0001\u0019\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\u0012!\u0014\u0016\u0003\u001d\u0006\u0003\"a\u0014,\u000e\u0003AS!!\u0015*\u0002\u000f\rD\u0017M\u001c8fY*\u00111\u000bV\u0001\u0006]\u0016$H/\u001f\u0006\u0002+\u0006\u0011\u0011n\\\u0005\u0003/B\u0013a\"\u0012<f]Rdun\u001c9He>,\b\u000fC\u0004Z#E\u0005I\u0011\u0001.\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0005Y&F\u0001/B!\tiv,D\u0001_\u0015\t)c#\u0003\u0002a=\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0004\u0005%\t\u0001!m\u0005\u0003b)\rL\u0007C\u00013h\u001b\u0005)'B\u00014\u0003\u0003\u0015\u0019w\u000eZ3d\u0013\tAWM\u0001\u000bNsN\u000bF\nS1oI2,'\u000fR3mK\u001e\fG/\u001a\t\u0003U.l\u0011\u0001B\u0005\u0003Y\u0012\u0011!bQ8o]\u0016\u001cG/[8o\u0011!q\u0017M!A!\u0002\u0013y\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002ka&\u0011\u0011\u000f\u0002\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011M\f'\u0011!Q\u0001\nq\nQb\u00195beN,G/T1qa\u0016\u0014\b\u0002C;b\u0005\u0003\u0005\u000b\u0011\u0002(\u0002\u000b\u001d\u0014x.\u001e9\t\u0011]\f'\u0011!Q\u0001\nq\u000b\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000bm\tG\u0011A=\u0015\u000bi\\H0 @\u0011\u0005A\t\u0007\"\u00028y\u0001\u0004y\u0007bB:y!\u0003\u0005\r\u0001\u0010\u0005\bkb\u0004\n\u00111\u0001O\u0011\u001d9\b\u0010%AA\u0002qC\u0011\"!\u0001b\u0005\u0004%i!a\u0001\u0002\u001f\r|gN\\3di&|gnQ8v]R,\"!!\u0002\u0011\u0007U\t9!C\u0002\u0002\nY\u0011A\u0001T8oO\"A\u0011QB1!\u0002\u001b\t)!\u0001\td_:tWm\u0019;j_:\u001cu.\u001e8uA!I\u0011\u0011C1C\u0002\u00135\u00111C\u0001\rG>tg.Z2uS>t\u0017\nZ\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e9\u0019Q#!\u0007\n\u0007\u0005ma#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u000371\u0002\u0002CA\u0013C\u0002\u0006i!!\u0006\u0002\u001b\r|gN\\3di&|g.\u00133!\u0011%\tI#\u0019b\u0001\n\u001b\tY#A\u0002m_\u001e,\"!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005)1\u000f\u001c45U*\u0011\u0011qG\u0001\u0004_J<\u0017\u0002BA\u001e\u0003c\u0011a\u0001T8hO\u0016\u0014\b\u0002CA C\u0002\u0006i!!\f\u0002\t1|w\r\t\u0005\n\u0003\u0007\n'\u0019!C\u0006\u0003\u000b\nA\"\u001b8uKJt\u0017\r\u001c)p_2,\u0012\u0001\u0018\u0005\b\u0003\u0013\n\u0007\u0015!\u0003]\u00035Ig\u000e^3s]\u0006d\u0007k\\8mA!I\u0011QJ1C\u0002\u00135\u0011qJ\u0001\u0012G>tg.Z2uS>t\u0007*\u00198eY\u0016\u0014XCAA)!\r!\u00171K\u0005\u0004\u0003+*'AF'z'Fc5i\u001c8oK\u000e$\u0018n\u001c8IC:$G.\u001a:\t\u0011\u0005e\u0013\r)A\u0007\u0003#\n!cY8o]\u0016\u001cG/[8o\u0011\u0006tG\r\\3sA!I\u0011QL1C\u0002\u00135\u0011qL\u0001\u0012G>tg.Z2uS>t\u0007K]8nSN,WCAA1!\u0011i\u00161M5\n\u0007\u0005\u0015dLA\u0004Qe>l\u0017n]3\t\u0011\u0005%\u0014\r)A\u0007\u0003C\n!cY8o]\u0016\u001cG/[8o!J|W.[:fA!I\u0011QN1C\u0002\u00135\u0011qL\u0001\u0015I&\u001c8m\u001c8oK\u000e$\u0018n\u001c8Qe>l\u0017n]3\t\u0011\u0005E\u0014\r)A\u0007\u0003C\nQ\u0003Z5tG>tg.Z2uS>t\u0007K]8nSN,\u0007\u0005C\u0005\u0002v\u0005\u0014\r\u0011\"\u0003\u0002x\u0005)\u0012/^3ssB\u0013x.\\5tKJ+g-\u001a:f]\u000e,WCAA=!\u0015\t\u00131PA@\u0013\r\tiH\t\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB)Q#!!\u0002\u0006&\u0019\u00111\u0011\f\u0003\r=\u0003H/[8o!\u0015i\u00161MAD!\rQ\u0017\u0011R\u0005\u0004\u0003\u0017#!aC)vKJL(+Z:vYRD\u0001\"a$bA\u0003%\u0011\u0011P\u0001\u0017cV,'/\u001f)s_6L7/\u001a*fM\u0016\u0014XM\\2fA!I\u00111S1A\u0002\u0013%\u0011QS\u0001\nG>tg.Z2uK\u0012,\"!a&\u0011\u0007U\tI*C\u0002\u0002\u001cZ\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002 \u0006\u0004\r\u0011\"\u0003\u0002\"\u0006i1m\u001c8oK\u000e$X\rZ0%KF$B!a)\u0002*B\u0019Q#!*\n\u0007\u0005\u001dfC\u0001\u0003V]&$\bBCAV\u0003;\u000b\t\u00111\u0001\u0002\u0018\u0006\u0019\u0001\u0010J\u0019\t\u0011\u0005=\u0016\r)Q\u0005\u0003/\u000b!bY8o]\u0016\u001cG/\u001a3!\u0011%\t\u0019,\u0019a\u0001\n\u0013\t),\u0001\b`Y\u0006\u001cH/\u0012=dKB$\u0018n\u001c8\u0016\u0005\u0005]\u0006\u0003BA]\u0003\u0013tA!a/\u0002F:!\u0011QXAb\u001b\t\tyLC\u0002\u0002B:\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0007\u0005\u001dg#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0017Q\u001a\u0002\n)\"\u0014xn^1cY\u0016T1!a2\u0017\u0011%\t\t.\u0019a\u0001\n\u0013\t\u0019.\u0001\n`Y\u0006\u001cH/\u0012=dKB$\u0018n\u001c8`I\u0015\fH\u0003BAR\u0003+D!\"a+\u0002P\u0006\u0005\t\u0019AA\\\u0011!\tI.\u0019Q!\n\u0005]\u0016aD0mCN$X\t_2faRLwN\u001c\u0011\t\u0011\u0005u\u0017\r1A\u0005\nA\nQb]3sm\u0016\u0014h+\u001a:tS>t\u0007\"CAqC\u0002\u0007I\u0011BAr\u0003E\u0019XM\u001d<feZ+'o]5p]~#S-\u001d\u000b\u0005\u0003G\u000b)\u000fC\u0005\u0002,\u0006}\u0017\u0011!a\u0001c!9\u0011\u0011^1!B\u0013\t\u0014AD:feZ,'OV3sg&|g\u000e\t\u0005\u0007\u0003[\fG\u0011\u0001\u0019\u0002\u000fY,'o]5p]\"9\u0011\u0011_1\u0005\u0002\u0005U\u0016!\u00047bgR,\u0005pY3qi&|g\u000eC\u0004\u0002v\u0006$\t!a\u0001\u0002\u000b\r|WO\u001c;\t\u000f\u0005e\u0018\r\"\u0001\u0002|\u000691m\u001c8oK\u000e$XCAA\u007f!\u0011i\u0016q`5\n\u0007\t\u0005aL\u0001\u0004GkR,(/\u001a\u0005\b\u0005\u000b\tG\u0011AA~\u0003\u0015\u0019Gn\\:f\u0011\u001d\t\u0019*\u0019C!\u0005\u0013!B!a)\u0003\f!A!Q\u0002B\u0004\u0001\u0004\u0011y!A\u0002dib\u00042a\u0014B\t\u0013\r\u0011\u0019\u0002\u0015\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u001d\u00119\"\u0019C!\u00053\tq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u0005\u0003G\u0013Y\u0002\u0003\u0005\u0003\u001e\tU\u0001\u0019AA\\\u0003%!\bN]8xC\ndW\rC\u0004\u0003\"\u0005$\tEa\t\u0002\u000f=tWI\u001d:peR!\u00111\u0015B\u0013\u0011!\u00119Ca\bA\u0002\t%\u0012aB7fgN\fw-\u001a\t\u0005\u0005W\u0011\u0019$\u0004\u0002\u0003.)!!q\u0006B\u0019\u0003\u0019\u0019XM\u001d<fe*\u0019!q\u0005\u0002\n\t\tU\"Q\u0006\u0002\r\u000bJ\u0014xN]'fgN\fw-\u001a\u0005\b\u0005s\tG\u0011\u0002B\u001e\u00031\u0019X\r^#yG\u0016\u0004H/[8o)\u0011\t\u0019K!\u0010\t\u0011\t}\"q\u0007a\u0001\u0003o\u000b\u0011\u0001\u001e\u0005\b\u0005\u0007\nG\u0011\tB#\u0003\u0011ygnT6\u0015\t\u0005\r&q\t\u0005\t\u0005O\u0011\t\u00051\u0001\u0003JA!!1\u0006B&\u0013\u0011\u0011iE!\f\u0003\u0013=[W*Z:tC\u001e,\u0007b\u0002B)C\u0012\u0005!1K\u0001\u0006_:,uJ\u0012\u000b\u0005\u0003G\u0013)\u0006\u0003\u0005\u0003(\t=\u0003\u0019\u0001B,!\u0011\u0011YC!\u0017\n\t\tm#Q\u0006\u0002\u000b\u000b>3U*Z:tC\u001e,\u0007b\u0002B0C\u0012\u0005#\u0011M\u0001\f_:D\u0015M\u001c3tQ\u0006\\W\r\u0006\u0003\u0002$\n\r\u0004\u0002\u0003B\u0014\u0005;\u0002\rA!\u001a\u0011\t\t-\"qM\u0005\u0005\u0005S\u0012iC\u0001\tIC:$7\u000f[1lK6+7o]1hK\"9!QN1\u0005\u0002\t=\u0014!C:f]\u0012\fV/\u001a:z)\u0011\u0011\tHa\u001d\u0011\u000bu\u000by0a\"\t\u0011\tU$1\u000ea\u0001\u0003+\tQ!];fefDqA!\u001fb\t\u0013\u0011Y(\u0001\tgC&d\u0017+^3ssB\u0013x.\\5tKR!\u00111\u0015B?\u0011!\u0011yDa\u001eA\u0002\u0005]\u0006b\u0002BAC\u0012%!1Q\u0001\u0014gV\u001c7-Z3e#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003G\u0013)\t\u0003\u0005\u0003\b\n}\u0004\u0019AAD\u0003-\tX/\u001a:z%\u0016\u001cX\u000f\u001c;\t\u000f\t-\u0015\r\"\u0001\u0002\u0016\u0006Q\u0011n])vKJL\u0018N\\4\t\u000f\t=\u0015\r\"\u0001\u0003\u0012\u0006YqN\u001c*fgVdGoU3u)\u0019\t\u0019Ka%\u0003\u001e\"A!Q\u0013BG\u0001\u0004\u00119*A\u0005sKN,H\u000e^*fiB\u0019!N!'\n\u0007\tmEAA\u0005SKN,H\u000e^*fi\"A!q\u0005BG\u0001\u0004\u00119\u0006C\u0004\u0003\"\u0006$\t!a?\u0002\u0015\u0011L7oY8o]\u0016\u001cG\u000fC\u0004\u0003&\u0006$\t!!&\u0002\u0017%\u001c8i\u001c8oK\u000e$X\r\u001a\u0005\b\u0005S\u000bG\u0011\u0001BV\u0003U\u0019XM\u001c3Qe\u0016\u0004\u0018M]3e'R\fG/Z7f]R$bA!\u001d\u0003.\n=\u0006\u0002\u0003B;\u0005O\u0003\r!!\u0006\t\u0015\tE&q\u0015I\u0001\u0002\u0004\u0011\u0019,\u0001\u0004wC2,Xm\u001d\t\u0007\u0003s\u0013)L!/\n\t\t]\u0016Q\u001a\u0002\u0004'\u0016\f\bcA\u000b\u0003<&\u0019!Q\u0018\f\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003B\u0006$\tEa1\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0006\t\u000f\t\u001d\u0017\r\"\u0003\u0003J\u00069b/\u00197jI\u0006$X-S:SK\u0006$\u0017PR8s#V,'/\u001f\u000b\u0003\u0003GCqA!4b\t\u0013\u0011y-\u0001\u0007rk\u0016\u0014\u0018\u0010\u0015:p[&\u001cX-\u0006\u0002\u0002\u0000!9!1[1\u0005\n\tU\u0017aD:fiF+XM]=Qe>l\u0017n]3\u0015\t\u0005\r&q\u001b\u0005\t\u00053\u0014\t\u000e1\u0001\u0002\u0006\u00069\u0001O]8nSN,\u0007b\u0002BoC\u0012%!qZ\u0001\u0012G2,\u0017M])vKJL\bK]8nSN,\u0007")
public class MySQLConnection
implements MySQLHandlerDelegate,
Connection {
    private final Configuration configuration;
    private final long connectionCount;
    private final String connectionId;
    private final Logger log;
    private final ExecutionContext com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool;
    private final MySQLConnectionHandler com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler;
    private final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise;
    private final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private boolean connected;
    private Throwable _lastException;
    private Version serverVersion;

    public static ExecutionContext $lessinit$greater$default$4() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static EventLoopGroup $lessinit$greater$default$3() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static CharsetMapper $lessinit$greater$default$2() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Version MicrosecondsVersion() {
        return MySQLConnection$.MODULE$.MicrosecondsVersion();
    }

    public static AtomicLong Counter() {
        return MySQLConnection$.MODULE$.Counter();
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.class.inTransaction((Connection)this, f, (ExecutionContext)executionContext);
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Connection.class.sendPreparedStatement$default$2((Connection)this);
    }

    private final long connectionCount() {
        return this.connectionCount;
    }

    private final String connectionId() {
        return this.connectionId;
    }

    private final Logger log() {
        return this.log;
    }

    public ExecutionContext com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool;
    }

    public final MySQLConnectionHandler com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler;
    }

    public final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise;
    }

    public final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private boolean connected() {
        return this.connected;
    }

    private void connected_$eq(boolean x$1) {
        this.connected = x$1;
    }

    private Throwable _lastException() {
        return this._lastException;
    }

    private void _lastException_$eq(Throwable x$1) {
        this._lastException = x$1;
    }

    private Version serverVersion() {
        return this.serverVersion;
    }

    private void serverVersion_$eq(Version x$1) {
        this.serverVersion = x$1;
    }

    public Version version() {
        return this.serverVersion();
    }

    public Throwable lastException() {
        return this._lastException();
    }

    public long count() {
        return this.connectionCount();
    }

    public Future<Connection> connect() {
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().connect().onFailure((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLConnection $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool());
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().future();
    }

    public Future<Connection> close() {
        this.log().debug("Closing connection");
        if (this.isConnected() && !this.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().isCompleted()) {
            DatabaseException exception = new DatabaseException("Connection is being closed");
            exception.fillInStackTrace();
            this.failQueryPromise((Throwable)exception);
            this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().clearQueryState();
            ChannelFutureTransformer$.MODULE$.toFuture(this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().write(QuitMessage$.MODULE$.Instance())).onComplete((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MySQLConnection $outer;

                public final Object apply(Try<ChannelFuture> x0$1) {
                    Try<ChannelFuture> try_;
                    block4: {
                        Object object;
                        block3: {
                            block2: {
                                try_ = x0$1;
                                if (!(try_ instanceof Success)) break block2;
                                ChannelFutureTransformer$.MODULE$.toFuture(this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().disconnect()).onComplete((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$close$1 $outer;

                                    public final boolean apply(Try<ChannelFuture> x0$2) {
                                        Try<ChannelFuture> try_;
                                        block4: {
                                            boolean bl;
                                            block3: {
                                                block2: {
                                                    try_ = x0$2;
                                                    if (!(try_ instanceof Success)) break block2;
                                                    bl = this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$anonfun$$$outer().com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().trySuccess((Object)this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$anonfun$$$outer());
                                                    break block3;
                                                }
                                                if (!(try_ instanceof Failure)) break block4;
                                                Failure failure = (Failure)try_;
                                                Throwable e = failure.exception();
                                                bl = this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$anonfun$$$outer().com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().tryFailure(e);
                                            }
                                            return bl;
                                        }
                                        throw new MatchError(try_);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool());
                                object = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(try_ instanceof Failure)) break block4;
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            object = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().tryFailure(exception));
                        }
                        return object;
                    }
                    throw new MatchError(try_);
                }

                public /* synthetic */ MySQLConnection com$github$mauricio$async$db$mysql$MySQLConnection$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, this.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool());
        }
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().future();
    }

    @Override
    public void connected(ChannelHandlerContext ctx) {
        this.log().debug("Connected to {}", new Object[]{ctx.channel().remoteAddress()});
        this.connected_$eq(true);
    }

    @Override
    public void exceptionCaught(Throwable throwable) {
        this.log().error("Transport failure", throwable);
        this.setException(throwable);
    }

    @Override
    public void onError(ErrorMessage message) {
        this.log().error("Received an error message -> {}", new Object[]{message});
        MySQLException exception = new MySQLException(message);
        exception.fillInStackTrace();
        this.setException((Throwable)((Object)exception));
    }

    private void setException(Throwable t) {
        this._lastException_$eq(t);
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().tryFailure(t);
        this.failQueryPromise(t);
    }

    @Override
    public void onOk(OkMessage message) {
        if (this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().isCompleted()) {
            if (this.isQuerying()) {
                this.succeedQueryPromise(new MySQLQueryResult(message.affectedRows(), message.message(), message.lastInsertId(), message.statusFlags(), message.warnings(), MySQLQueryResult$.MODULE$.$lessinit$greater$default$6()));
            } else {
                this.log().warn("Received OK when not querying or connecting, not sure what this is");
            }
        } else {
            this.log().debug("Connected to database");
            this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().success((Object)this);
        }
    }

    @Override
    public void onEOF(EOFMessage message) {
        if (this.isQuerying()) {
            this.succeedQueryPromise(new MySQLQueryResult(0L, null, -1L, message.flags(), message.warningCount(), MySQLQueryResult$.MODULE$.$lessinit$greater$default$6()));
        }
    }

    @Override
    public void onHandshake(HandshakeMessage message) {
        this.serverVersion_$eq(Version$.MODULE$.apply(message.serverVersion()));
        String x$4 = this.configuration.username();
        Charset x$5 = this.configuration.charset();
        byte[] x$6 = message.seed();
        Option<String> x$7 = message.authenticationMethod();
        Option x$8 = this.configuration.database();
        Option x$9 = this.configuration.password();
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().write(new HandshakeResponseMessage(x$4, x$5, x$6, x$7, (Option<String>)x$9, (Option<String>)x$8));
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateIsReadyForQuery();
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().write(new QueryMessage(query));
        return promise.future();
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final boolean apply(Promise<QueryResult> x$1) {
                return x$1.tryFailure(this.t$1);
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    private void succeedQueryPromise(QueryResult queryResult) {
        this.clearQueryPromise().foreach((Function1)new Serializable(this, queryResult){
            public static final long serialVersionUID = 0L;
            private final QueryResult queryResult$1;

            public final Promise<QueryResult> apply(Promise<QueryResult> x$2) {
                return x$2.success((Object)this.queryResult$1);
            }
            {
                this.queryResult$1 = queryResult$1;
            }
        });
    }

    public boolean isQuerying() {
        return this.queryPromise().isDefined();
    }

    @Override
    public void onResultSet(ResultSet resultSet, EOFMessage message) {
        if (this.isQuerying()) {
            this.succeedQueryPromise(new MySQLQueryResult(resultSet.size(), null, -1L, message.flags(), message.warningCount(), (Option<ResultSet>)new Some((Object)resultSet)));
        }
    }

    public Future<Connection> disconnect() {
        return this.close();
    }

    public boolean isConnected() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().isConnected();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        this.validateIsReadyForQuery();
        int totalParameters = new StringOps(Predef$.MODULE$.augmentString(query)).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$3) {
                return x$3 == '?';
            }
        });
        if (values.length() != totalParameters) {
            throw new InsufficientParametersException(totalParameters, values);
        }
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().write(new PreparedStatementMessage(query, values));
        return promise.future();
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("%s(%s,%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), this.connectionId(), BoxesRunTime.boxToLong((long)this.connectionCount())}));
    }

    private void validateIsReadyForQuery() {
        if (this.isQuerying()) {
            throw new ConnectionStillRunningQueryException(this.connectionCount(), false);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            return;
        }
        throw new ConnectionStillRunningQueryException(this.connectionCount(), true);
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    public MySQLConnection(Configuration configuration, CharsetMapper charsetMapper, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        Connection.class.$init$((Connection)this);
        charsetMapper.toInt(configuration.charset());
        this.connectionCount = MySQLConnection$.MODULE$.Counter().incrementAndGet();
        this.connectionId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[mysql-connection-", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.connectionCount())}));
        this.log = Log$.MODULE$.getByName(this.connectionId());
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool = executionContext;
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler = new MySQLConnectionHandler(configuration, charsetMapper, this, group, executionContext, this.connectionId());
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise = Promise$.MODULE$.apply();
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise = Promise$.MODULE$.apply();
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.connected = false;
        this._lastException = null;
        this.serverVersion = null;
    }
}

