/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class ParserURL$ {
    public static final ParserURL$ MODULE$;
    private final Logger logger;
    private final String PGPORT;
    private final String PGDBNAME;
    private final String PGHOST;
    private final String PGUSERNAME;
    private final String PGPASSWORD;
    private final String DEFAULT_PORT;
    private final Regex pgurl1;
    private final Regex pgurl2;

    static {
        new ParserURL$();
    }

    private Logger logger() {
        return this.logger;
    }

    public String PGPORT() {
        return this.PGPORT;
    }

    public String PGDBNAME() {
        return this.PGDBNAME;
    }

    public String PGHOST() {
        return this.PGHOST;
    }

    public String PGUSERNAME() {
        return this.PGUSERNAME;
    }

    public String PGPASSWORD() {
        return this.PGPASSWORD;
    }

    public String DEFAULT_PORT() {
        return this.DEFAULT_PORT;
    }

    private Regex pgurl1() {
        return this.pgurl1;
    }

    private Regex pgurl2() {
        return this.pgurl2;
    }

    public Map<String, String> parse(String connectionURL) {
        Map map;
        Map properties = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        String string = connectionURL;
        Option option = this.pgurl1().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(6) == 0) {
            String server = (String)((LinearSeqOptimized)option.get()).apply(1);
            String port = (String)((LinearSeqOptimized)option.get()).apply(2);
            String dbname = (String)((LinearSeqOptimized)option.get()).apply(3);
            String username = (String)((LinearSeqOptimized)option.get()).apply(4);
            String password = (String)((LinearSeqOptimized)option.get()).apply(5);
            Map result = properties;
            if (server != null) {
                result = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGHOST()), (Object)this.unwrapIpv6address(server)));
            }
            if (dbname != null && new StringOps(Predef$.MODULE$.augmentString(dbname)).nonEmpty()) {
                result = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGDBNAME()), (Object)dbname));
            }
            if (port != null) {
                result = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGPORT()), (Object)port));
            }
            if (username != null) {
                result = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGUSERNAME()), (Object)username)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGPASSWORD()), (Object)password));
            }
            map = result;
        } else {
            Option option2 = this.pgurl2().unapplySeq((Object)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(6) == 0) {
                String username = (String)((LinearSeqOptimized)option2.get()).apply(1);
                String password = (String)((LinearSeqOptimized)option2.get()).apply(2);
                String server = (String)((LinearSeqOptimized)option2.get()).apply(3);
                String port = (String)((LinearSeqOptimized)option2.get()).apply(4);
                String dbname = (String)((LinearSeqOptimized)option2.get()).apply(5);
                map = properties.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGHOST()), (Object)this.unwrapIpv6address(server))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGPORT()), (Object)port)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGDBNAME()), (Object)dbname)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGUSERNAME()), (Object)username)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.PGPASSWORD()), (Object)password));
            } else {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection url '", "' could not be parsed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionURL})));
                map = properties;
            }
        }
        return map;
    }

    private String unwrapIpv6address(String server) {
        return server.startsWith("[") ? server.substring(1, server.length() - 1) : server;
    }

    private ParserURL$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.PGPORT = "port";
        this.PGDBNAME = "database";
        this.PGHOST = "host";
        this.PGUSERNAME = "username";
        this.PGPASSWORD = "password";
        this.DEFAULT_PORT = "5432";
        this.pgurl1 = new StringOps(Predef$.MODULE$.augmentString("(jdbc:postgresql):(?://([^/:]*|\\[.+\\])(?::(\\d+))?)?(?:/([^/?]*))?(?:\\?user=(.*)&password=(.*))?")).r();
        this.pgurl2 = new StringOps(Predef$.MODULE$.augmentString("(postgres|postgresql)://(.*):(.*)@(.*):(\\d+)/(.*)")).r();
    }
}

