/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.MutableResultSet;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.PreparedStatementHolder;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.mauricio.async.db.postgresql.exceptions.GenericDatabaseException;
import com.github.mauricio.async.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.mauricio.async.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.DataRowMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ErrorMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.CredentialMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.QueryMessage;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\r-x!B\u0001\u0003\u0011\u0003y\u0011\u0001\u0006)pgR<'/Z*R\u0019\u000e{gN\\3di&|gN\u0003\u0002\u0004\t\u0005Q\u0001o\\:uOJ,7/\u001d7\u000b\u0005\u00151\u0011A\u00013c\u0015\t9\u0001\"A\u0003bgft7M\u0003\u0002\n\u0015\u0005AQ.Y;sS\u000eLwN\u0003\u0002\f\u0019\u00051q-\u001b;ik\nT\u0011!D\u0001\u0004G>l7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005b\u0001\n\u0003y\u0012a\u00017pOV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005)1\u000f\u001c45U*\tQ%A\u0002pe\u001eL!a\n\u0012\u0003\r1{wmZ3s\u0011\u0019I\u0013\u0003)A\u0005A\u0005!An\\4!\u0011\u001dY\u0013C1A\u0005\u00021\nqaQ8v]R,'/F\u0001.!\tqs'D\u00010\u0015\t\u0001\u0014'\u0001\u0004bi>l\u0017n\u0019\u0006\u0003eM\n!bY8oGV\u0014(/\u001a8u\u0015\t!T'\u0001\u0003vi&d'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003q=\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019Q\u0014\u0003)A\u0005[\u0005A1i\\;oi\u0016\u0014\b\u0005C\u0004=#\t\u0007I\u0011A\u001f\u0002!M+'O^3s-\u0016\u00148/[8o\u0017\u0016LX#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005+\u0014\u0001\u00027b]\u001eL!a\u0011!\u0003\rM#(/\u001b8h\u0011\u0019)\u0015\u0003)A\u0005}\u0005\t2+\u001a:wKJ4VM]:j_:\\U-\u001f\u0011\t\u000f\u001d\u000b\u0012\u0013!C\u0001\u0011\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012!\u0013\u0016\u0003\u0015:\u0003\"a\u0013'\u000e\u0003\u0011I!!\u0014\u0003\u0003\u001b\r{gNZ5hkJ\fG/[8oW\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003%)hn\u00195fG.,GM\u0003\u0002U-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u000b&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9\u0001,EI\u0001\n\u0003I\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001[U\tYf\n\u0005\u0002]?6\tQL\u0003\u0002_\t\u000511m\u001c7v[:L!\u0001Y/\u0003+\r{G.^7o\u000b:\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"9!-EI\u0001\n\u0003\u0019\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001eU\t)g\n\u0005\u0002]M&\u0011q-\u0018\u0002\u0016\u0007>dW/\u001c8EK\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0011\u001dI\u0017#%A\u0005\u0002)\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#A6+\u00051t\u0005CA7u\u001b\u0005q'BA8q\u0003\u001d\u0019\u0007.\u00198oK2T!!\u001d:\u0002\u000b9,G\u000f^=\u000b\u0003M\f!![8\n\u0005Ut'AD#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0005\boF\t\n\u0011\"\u0001y\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\t\u0011P\u000b\u0002{\u001dB\u001110`\u0007\u0002y*\u0011!GF\u0005\u0003}r\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0007\u000bI\u0011\u0001!!\u0001\u0014\r}$\u00121AA\b!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\u0005\u0005)1m\u001c3fG&!\u0011QBA\u0004\u0005q\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]\u0012+G.Z4bi\u0016\u00042aSA\t\u0013\r\t\u0019\u0002\u0002\u0002\u000b\u0007>tg.Z2uS>t\u0007\"CA\f\u007f\n\u0005\t\u0015!\u0003K\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\"I\u00111D@\u0003\u0002\u0003\u0006IaW\u0001\u0010K:\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"I\u0011qD@\u0003\u0002\u0003\u0006I!Z\u0001\u0010I\u0016\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"I\u00111E@\u0003\u0002\u0003\u0006I\u0001\\\u0001\u0006OJ|W\u000f\u001d\u0005\n\u0003Oy(\u0011!Q\u0001\ni\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\rmyH\u0011AA\u0016)1\ti#a\f\u00022\u0005M\u0012QGA\u001c!\t\u0001r\u0010C\u0005\u0002\u0018\u0005%\u0002\u0013!a\u0001\u0015\"I\u00111DA\u0015!\u0003\u0005\ra\u0017\u0005\n\u0003?\tI\u0003%AA\u0002\u0015D\u0011\"a\t\u0002*A\u0005\t\u0019\u00017\t\u0013\u0005\u001d\u0012\u0011\u0006I\u0001\u0002\u0004Q\b\"CA\u001e\u007f\n\u0007IQBA\u001f\u0003E\u0019wN\u001c8fGRLwN\u001c%b]\u0012dWM]\u000b\u0003\u0003\u007f\u0001B!!\u0002\u0002B%!\u00111IA\u0004\u0005m\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]\"\u000bg\u000e\u001a7fe\"A\u0011qI@!\u0002\u001b\ty$\u0001\nd_:tWm\u0019;j_:D\u0015M\u001c3mKJ\u0004\u0003\"CA&\u007f\n\u0007IQBA'\u00031\u0019WO\u001d:f]R\u001cu.\u001e8u+\t\ty\u0005E\u0002\u0016\u0003#J1!a\u0015\u0017\u0005\u0011auN\\4\t\u0011\u0005]s\u0010)A\u0007\u0003\u001f\nQbY;se\u0016tGoQ8v]R\u0004\u0003\"CA.\u007f\n\u0007IQBA/\u0003e\u0001(/\u001a9be\u0016$7\u000b^1uK6,g\u000e^:D_VtG/\u001a:\u0016\u0005\u0005}\u0003c\u0001\u0018\u0002b%\u0019\u00111M\u0018\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!\t9g Q\u0001\u000e\u0005}\u0013A\u00079sKB\f'/\u001a3Ti\u0006$X-\\3oiN\u001cu.\u001e8uKJ\u0004\u0003\"CA6\u007f\n\u0007IqBA7\u0003aIg\u000e^3s]\u0006dW\t_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002u\"9\u0011\u0011O@!\u0002\u001bQ\u0018!G5oi\u0016\u0014h.\u00197Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002B\u0011\"!\u001e\u0000\u0005\u0004%I!a\u001e\u0002\u001fA\f'/Y7fi\u0016\u00148\u000b^1ukN,\"!!\u001f\u0011\u0011\u0005m\u0014QQAE\u0003\u0013k!!! \u000b\t\u0005}\u0014\u0011Q\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019IF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAD\u0003{\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\f\u0006EebA\u000b\u0002\u000e&\u0019\u0011q\u0012\f\u0002\rA\u0013X\rZ3g\u0013\r\u0019\u00151\u0013\u0006\u0004\u0003\u001f3\u0002\u0002CAL\u007f\u0002\u0006I!!\u001f\u0002!A\f'/Y7fi\u0016\u00148\u000b^1ukN\u0004\u0003\"CAN\u007f\n\u0007I\u0011BAO\u0003A\u0001\u0018M]:fIN#\u0018\r^3nK:$8/\u0006\u0002\u0002 BA\u00111PAC\u0003\u0013\u000b\t\u000bE\u0002\u0011\u0003GK1!!*\u0003\u0005]\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e%pY\u0012,'\u000f\u0003\u0005\u0002*~\u0004\u000b\u0011BAP\u0003E\u0001\u0018M]:fIN#\u0018\r^3nK:$8\u000f\t\u0005\n\u0003[{\b\u0019!C\u0005\u0003_\u000bQ\"Y;uQ\u0016tG/[2bi\u0016$WCAAY!\r)\u00121W\u0005\u0004\u0003k3\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003s{\b\u0019!C\u0005\u0003w\u000b\u0011#Y;uQ\u0016tG/[2bi\u0016$w\fJ3r)\u0011\ti,a1\u0011\u0007U\ty,C\u0002\u0002BZ\u0011A!\u00168ji\"Q\u0011QYA\\\u0003\u0003\u0005\r!!-\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002J~\u0004\u000b\u0015BAY\u00039\tW\u000f\u001e5f]RL7-\u0019;fI\u0002B\u0011\"!4\u0000\u0005\u0004%I!a4\u0002!\r|gN\\3di&|gNR;ukJ,WCAAi!\u0015Y\u00181[A\b\u0013\r\t)\u000e \u0002\b!J|W.[:f\u0011!\tIn Q\u0001\n\u0005E\u0017!E2p]:,7\r^5p]\u001a+H/\u001e:fA!I\u0011Q\\@A\u0002\u0013%\u0011qV\u0001\fe\u0016\u001cWM\u001c;FeJ|'\u000fC\u0005\u0002b~\u0004\r\u0011\"\u0003\u0002d\u0006y!/Z2f]R,%O]8s?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0006\u0015\bBCAc\u0003?\f\t\u00111\u0001\u00022\"A\u0011\u0011^@!B\u0013\t\t,\u0001\u0007sK\u000e,g\u000e^#se>\u0014\b\u0005C\u0005\u0002n~\u0014\r\u0011\"\u0003\u0002p\u0006)\u0012/^3ssB\u0013x.\\5tKJ+g-\u001a:f]\u000e,WCAAy!\u0015q\u00131_A|\u0013\r\t)p\f\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB)Q#!?\u0002~&\u0019\u00111 \f\u0003\r=\u0003H/[8o!\u0015Y\u00181[A\u0000!\rY%\u0011A\u0005\u0004\u0005\u0007!!aC)vKJL(+Z:vYRD\u0001Ba\u0002\u0000A\u0003%\u0011\u0011_\u0001\u0017cV,'/\u001f)s_6L7/\u001a*fM\u0016\u0014XM\\2fA!I!1B@A\u0002\u0013%!QB\u0001\rGV\u0014(/\u001a8u#V,'/_\u000b\u0003\u0005\u001f\u0001R!FA}\u0005#\u0001bAa\u0005\u0003\u001a\tuQB\u0001B\u000b\u0015\r\u00119\u0002B\u0001\bO\u0016tWM]1m\u0013\u0011\u0011YB!\u0006\u0003!5+H/\u00192mKJ+7/\u001e7u'\u0016$\b\u0003\u0002B\u0010\u0005Si!A!\t\u000b\t\t\r\"QE\u0001\bE\u0006\u001c7.\u001a8e\u0015\r\u00119CA\u0001\t[\u0016\u001c8/Y4fg&!!1\u0006B\u0011\u0005Q\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"pYVlg\u000eR1uC\"I!qF@A\u0002\u0013%!\u0011G\u0001\u0011GV\u0014(/\u001a8u#V,'/_0%KF$B!!0\u00034!Q\u0011Q\u0019B\u0017\u0003\u0003\u0005\rAa\u0004\t\u0011\t]r\u0010)Q\u0005\u0005\u001f\tQbY;se\u0016tG/U;fef\u0004\u0003\"\u0003B\u001e\u007f\u0002\u0007I\u0011\u0002B\u001f\u0003a\u0019WO\u001d:f]R\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e^\u000b\u0003\u0005\u007f\u0001R!FA}\u0003CC\u0011Ba\u0011\u0000\u0001\u0004%IA!\u0012\u00029\r,(O]3oiB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tGo\u0018\u0013fcR!\u0011Q\u0018B$\u0011)\t)M!\u0011\u0002\u0002\u0003\u0007!q\b\u0005\t\u0005\u0017z\b\u0015)\u0003\u0003@\u0005I2-\u001e:sK:$\bK]3qCJ,Gm\u0015;bi\u0016lWM\u001c;!\u0011%\u0011ye a\u0001\n\u0013\u0011\t&A\u0004wKJ\u001c\u0018n\u001c8\u0016\u0005\tM\u0003\u0003\u0002B+\u00053j!Aa\u0016\u000b\u0005Q\"\u0011\u0002\u0002B.\u0005/\u0012qAV3sg&|g\u000eC\u0005\u0003`}\u0004\r\u0011\"\u0003\u0003b\u0005Ya/\u001a:tS>tw\fJ3r)\u0011\tiLa\u0019\t\u0015\u0005\u0015'QLA\u0001\u0002\u0004\u0011\u0019\u0006\u0003\u0005\u0003h}\u0004\u000b\u0015\u0002B*\u0003!1XM]:j_:\u0004\u0003\"\u0003B6\u007f\u0002\u0007I\u0011\u0002B7\u0003-\tX/\u001a:z%\u0016\u001cX\u000f\u001c;\u0016\u0005\t=\u0004#B\u000b\u0002z\u0006}\b\"\u0003B:\u007f\u0002\u0007I\u0011\u0002B;\u0003=\tX/\u001a:z%\u0016\u001cX\u000f\u001c;`I\u0015\fH\u0003BA_\u0005oB!\"!2\u0003r\u0005\u0005\t\u0019\u0001B8\u0011!\u0011Yh Q!\n\t=\u0014\u0001D9vKJL(+Z:vYR\u0004\u0003b\u0002B@\u007f\u0012\u0005\u0011qV\u0001\u0010SN\u0014V-\u00193z\r>\u0014\u0018+^3ss\"9!1Q@\u0005\u0002\t\u0015\u0015aB2p]:,7\r^\u000b\u0003\u0005\u000f\u0003Ra\u001fBE\u0003\u001fI1Aa#}\u0005\u00191U\u000f^;sK\"9!qR@\u0005B\t\u0015\u0015A\u00033jg\u000e|gN\\3di\"9!1S@\u0005B\u0005=\u0016aC5t\u0007>tg.Z2uK\u0012DqAa&\u0000\t\u0003\u0011I*A\tqCJ\fW.\u001a;feN#\u0018\r^;tKN,\"Aa'\u0011\u0011\tu%1UAE\u0003\u0013k!Aa(\u000b\t\t\u0005\u0016\u0011Q\u0001\nS6lW\u000f^1cY\u0016LAA!*\u0003 \n\u0019Q*\u00199\t\u000f\t%v\u0010\"\u0011\u0003,\u0006I1/\u001a8e#V,'/\u001f\u000b\u0005\u0005[\u0013y\u000bE\u0003|\u0005\u0013\u000by\u0010\u0003\u0005\u00032\n\u001d\u0006\u0019AAE\u0003\u0015\tX/\u001a:z\u0011\u001d\u0011)l C!\u0005o\u000bQc]3oIB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0004\u0003.\ne&1\u0018\u0005\t\u0005c\u0013\u0019\f1\u0001\u0002\n\"Q!Q\u0018BZ!\u0003\u0005\rAa0\u0002\rY\fG.^3t!\u0019\u0011\tM!5\u0003X:!!1\u0019Bg\u001d\u0011\u0011)Ma3\u000e\u0005\t\u001d'b\u0001Be\u001d\u00051AH]8pizJ\u0011aF\u0005\u0004\u0005\u001f4\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005'\u0014)NA\u0002TKFT1Aa4\u0017!\r)\"\u0011\\\u0005\u0004\u000574\"aA!os\"9!q\\@\u0005B\t\u0005\u0018aB8o\u000bJ\u0014xN\u001d\u000b\u0005\u0003{\u0013\u0019\u000f\u0003\u0005\u0003f\nu\u0007\u0019\u0001Bt\u0003%)\u0007pY3qi&|g\u000e\u0005\u0003\u0003B\n%\u0018\u0002\u0002Bv\u0005+\u0014\u0011\u0002\u00165s_^\f'\r\\3\t\u000f\t=x\u0010\"\u0001\u00020\u0006q\u0001.Y:SK\u000e,g\u000e^#se>\u0014\bb\u0002Bz\u007f\u0012%!Q_\u0001\u0012g\u0016$XI\u001d:pe>sg)\u001e;ve\u0016\u001cH\u0003BA_\u0005oD\u0001B!?\u0003r\u0002\u0007!q]\u0001\u0002K\"9!Q`@\u0005B\t}\u0018aD8o%\u0016\fG-\u001f$peF+XM]=\u0015\u0005\u0005u\u0006b\u0002Bp\u007f\u0012\u000531\u0001\u000b\u0005\u0003{\u001b)\u0001\u0003\u0005\u0004\b\r\u0005\u0001\u0019AB\u0005\u0003\u0005i\u0007\u0003\u0002B\u0010\u0007\u0017IAa!\u0004\u0003\"\taQI\u001d:pe6+7o]1hK\"91\u0011C@\u0005B\rM\u0011!E8o\u0007>lW.\u00198e\u0007>l\u0007\u000f\\3uKR!\u0011QXB\u000b\u0011!\u00199aa\u0004A\u0002\r]\u0001\u0003\u0002B\u0010\u00073IAaa\u0007\u0003\"\t12i\\7nC:$7i\\7qY\u0016$X-T3tg\u0006<W\rC\u0004\u0004 }$\te!\t\u0002#=t\u0007+\u0019:b[\u0016$XM]*uCR,8\u000f\u0006\u0003\u0002>\u000e\r\u0002\u0002CB\u0004\u0007;\u0001\ra!\n\u0011\t\t}1qE\u0005\u0005\u0007S\u0011\tC\u0001\fQCJ\fW.\u001a;feN#\u0018\r^;t\u001b\u0016\u001c8/Y4f\u0011\u001d\u0019ic C!\u0007_\t\u0011b\u001c8ECR\f'k\\<\u0015\t\u0005u6\u0011\u0007\u0005\t\u0007\u000f\u0019Y\u00031\u0001\u00044A!!qDB\u001b\u0013\u0011\u00199D!\t\u0003\u001d\u0011\u000bG/\u0019*po6+7o]1hK\"911H@\u0005B\ru\u0012\u0001E8o%><H)Z:de&\u0004H/[8o)\u0011\tila\u0010\t\u0011\r\u001d1\u0011\ba\u0001\u0007\u0003\u0002BAa\b\u0004D%!1Q\tB\u0011\u0005U\u0011vn\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:lUm]:bO\u0016Dqa!\u0013\u0000\t\u0013\u0019Y%\u0001\btKR\u001cu\u000e\\;n]\u0012\u000bG/Y:\u0015\t\u0005u6Q\n\u0005\t\u0007\u001f\u001a9\u00051\u0001\u0004R\u0005Y1m\u001c7v[:$\u0015\r^1t!\u0015)21\u000bB\u000f\u0013\r\u0019)F\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u00073zH\u0011IB.\u0003ayg.Q;uQ\u0016tG/[2bi&|gNU3ta>t7/\u001a\u000b\u0005\u0003{\u001bi\u0006\u0003\u0005\u0004`\r]\u0003\u0019AB1\u0003\u001diWm]:bO\u0016\u0004BAa\b\u0004d%!1Q\rB\u0011\u0005U\tU\u000f\u001e5f]RL7-\u0019;j_:lUm]:bO\u0016Dqa!\u001b\u0000\t\u0013\u0019Y'\u0001\u0006de\u0016$WM\u001c;jC2$Ba!\u001c\u0004zA!1qNB;\u001b\t\u0019\tH\u0003\u0003\u0004t\t\u0015\u0012\u0001\u00034s_:$XM\u001c3\n\t\r]4\u0011\u000f\u0002\u0012\u0007J,G-\u001a8uS\u0006dW*Z:tC\u001e,\u0007\u0002CB>\u0007O\u0002\ra! \u0002+\u0005,H\u000f[3oi&\u001c\u0017\r^5p]6+7o]1hKB!!qDB@\u0013\u0011\u0019\tI!\t\u0003=\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u000eC\u0017\r\u001c7f]\u001e,W*Z:tC\u001e,\u0007\u0002CBC\u007f\u0002&Iaa\"\u0002+9|GOU3bIf4uN])vKJLXI\u001d:peR11\u0011RBH\u0007'\u00032!FBF\u0013\r\u0019iI\u0006\u0002\b\u001d>$\b.\u001b8h\u0011!\u0019\tja!A\u0002\u0005%\u0015\u0001D3se>\u0014X*Z:tC\u001e,\u0007\u0002CBK\u0007\u0007\u0003\r!!-\u0002\tI\f7-\u001a\u0005\b\u00073{H\u0011ABN\u0003m1\u0018\r\\5eCR,\u0017JZ%u\u0013N\u0014V-\u00193z\r>\u0014\u0018+^3ssR!\u0011QXBO\u0011!\u0019\tja&A\u0002\u0005%\u0005bBBQ\u007f\u0012%11U\u0001\u000em\u0006d\u0017\u000eZ1uKF+XM]=\u0015\t\u0005u6Q\u0015\u0005\t\u0005c\u001by\n1\u0001\u0002\n\"91\u0011V@\u0005\n\r-\u0016\u0001D9vKJL\bK]8nSN,WCAA|\u0011\u001d\u0019yk C\u0005\u0007c\u000bqb]3u#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003{\u001b\u0019\f\u0003\u0005\u00046\u000e5\u0006\u0019AA\u007f\u0003\u001d\u0001(o\\7jg\u0016Dqa!/\u0000\t\u0013\u0019Y+A\tdY\u0016\f'/U;fef\u0004&o\\7jg\u0016Dqa!0\u0000\t\u0013\u0019y,\u0001\tgC&d\u0017+^3ssB\u0013x.\\5tKR!\u0011QXBa\u0011!\u0019\u0019ma/A\u0002\t\u001d\u0018!\u0001;\t\u000f\r\u001dw\u0010\"\u0003\u0004J\u0006\u00192/^2dK\u0016$\u0017+^3ssB\u0013x.\\5tKR!\u0011QXBf\u0011!\u0019im!2A\u0002\u0005}\u0018A\u0002:fgVdG\u000fC\u0004\u0004R~$\taa5\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\u0005u6Q\u001b\u0005\t\u0007?\u001ay\r1\u0001\u0004XB!1qNBm\u0013\u0011\u0019Yn!\u001d\u0003\u001b\rc\u0017.\u001a8u\u001b\u0016\u001c8/Y4f\u0011\u001d\u0019yn C!\u0007C\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0013C\u0011b!:\u0000#\u0003%\tea:\u0002?M,g\u000e\u001a)sKB\f'/\u001a3Ti\u0006$X-\\3oi\u0012\"WMZ1vYR$#'\u0006\u0002\u0004j*\u001a!q\u0018(")
public class PostgreSQLConnection
implements PostgreSQLConnectionDelegate,
Connection {
    private final Configuration configuration;
    private final ColumnEncoderRegistry encoderRegistry;
    private final ColumnDecoderRegistry decoderRegistry;
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final AtomicInteger com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter;
    private final ExecutionContext internalExecutionContext;
    private final HashMap<String, String> parameterStatus;
    private final HashMap<String, PreparedStatementHolder> parsedStatements;
    private boolean authenticated;
    private final Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    private boolean recentError;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    private Option<PreparedStatementHolder> currentPreparedStatement;
    private Version version;
    private Option<QueryResult> queryResult;

    public static ExecutionContext $lessinit$greater$default$5() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static EventLoopGroup $lessinit$greater$default$4() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static ColumnDecoderRegistry $lessinit$greater$default$3() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static ColumnEncoderRegistry $lessinit$greater$default$2() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Configuration $lessinit$greater$default$1() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$1();
    }

    public static String ServerVersionKey() {
        return PostgreSQLConnection$.MODULE$.ServerVersionKey();
    }

    public static AtomicLong Counter() {
        return PostgreSQLConnection$.MODULE$.Counter();
    }

    public static Logger log() {
        return PostgreSQLConnection$.MODULE$.log();
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.class.inTransaction((Connection)this, f, (ExecutionContext)executionContext);
    }

    private final PostgreSQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    private final long currentCount() {
        return this.currentCount;
    }

    public final AtomicInteger com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter;
    }

    private final ExecutionContext internalExecutionContext() {
        return this.internalExecutionContext;
    }

    private HashMap<String, String> parameterStatus() {
        return this.parameterStatus;
    }

    private HashMap<String, PreparedStatementHolder> parsedStatements() {
        return this.parsedStatements;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    public Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    }

    private boolean recentError() {
        return this.recentError;
    }

    private void recentError_$eq(boolean x$1) {
        this.recentError = x$1;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(Option<MutableResultSet<PostgreSQLColumnData>> x$1) {
        this.currentQuery = x$1;
    }

    private Option<PreparedStatementHolder> currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(Option<PreparedStatementHolder> x$1) {
        this.currentPreparedStatement = x$1;
    }

    private Version version() {
        return this.version;
    }

    private void version_$eq(Version x$1) {
        this.version = x$1;
    }

    private Option<QueryResult> queryResult() {
        return this.queryResult;
    }

    private void queryResult_$eq(Option<QueryResult> x$1) {
        this.queryResult = x$1;
    }

    public boolean isReadyForQuery() {
        return this.queryPromise().isEmpty();
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().onFailure((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.internalExecutionContext());
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().future();
    }

    public Future<Connection> disconnect() {
        return this.connectionHandler().disconnect().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final PostgreSQLConnection apply(PostgreSQLConnectionHandler c) {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.internalExecutionContext());
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Map<String, String> parameterStatuses() {
        return this.parameterStatus().toMap(Predef$.MODULE$.conforms());
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.write(new QueryMessage(query));
        return promise.future();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        PreparedStatementMessage preparedStatementMessage;
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        PreparedStatementHolder holder = (PreparedStatementHolder)this.parsedStatements().getOrElseUpdate((Object)query, (Function0)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;
            private final String query$1;

            public final PreparedStatementHolder apply() {
                return new PreparedStatementHolder(this.query$1, this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter().incrementAndGet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
        if (holder.paramsCount() != values.length()) {
            this.clearQueryPromise();
            throw new InsufficientParametersException(holder.paramsCount(), values);
        }
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)new Some((Object)holder));
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)new Some((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])holder.columnDatas()))));
        if (holder.prepared()) {
            preparedStatementMessage = new PreparedStatementExecuteMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        } else {
            holder.prepared_$eq(true);
            preparedStatementMessage = new PreparedStatementOpeningMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        }
        this.write(preparedStatementMessage);
        return promise.future();
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public void onError(Throwable exception) {
        this.setErrorOnFutures(exception);
    }

    public boolean hasRecentError() {
        return this.recentError();
    }

    private void setErrorOnFutures(Throwable e) {
        Future<Connection> future;
        this.recentError_$eq(true);
        PostgreSQLConnection$.MODULE$.log().error("Error on connection", e);
        if (this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().isCompleted()) {
            future = BoxedUnit.UNIT;
        } else {
            this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().failure(e);
            future = this.disconnect();
        }
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().trySuccess((Object)this);
        this.recentError_$eq(false);
        this.queryResult().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final void apply(QueryResult result) {
                this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$succeedQueryPromise(result);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void onError(ErrorMessage m) {
        PostgreSQLConnection$.MODULE$.log().error("Error with message -> {}", new Object[]{m});
        GenericDatabaseException error = new GenericDatabaseException(m);
        error.fillInStackTrace();
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(CommandCompleteMessage m) {
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.queryResult_$eq((Option<QueryResult>)new Some((Object)new QueryResult((long)m.rowsAffected(), m.statusMessage(), this.currentQuery())));
    }

    @Override
    public void onParameterStatus(ParameterStatusMessage m) {
        this.parameterStatus().put((Object)m.key(), (Object)m.value());
        String string = PostgreSQLConnection$.MODULE$.ServerVersionKey();
        String string2 = m.key();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.version_$eq(Version$.MODULE$.apply(m.value()));
        }
    }

    @Override
    public void onDataRow(DataRowMessage m) {
        Object[] items = new Object[Predef$.MODULE$.refArrayOps((Object[])m.values()).size()];
        for (int x = 0; x < Predef$.MODULE$.refArrayOps((Object[])m.values()).size(); ++x) {
            Object object;
            if (m.values()[x] == null) {
                object = null;
            } else {
                PostgreSQLColumnData columnType = (PostgreSQLColumnData)((MutableResultSet)this.currentQuery().get()).columnTypes().apply(x);
                object = this.decoderRegistry.decode((ColumnData)columnType, m.values()[x], this.configuration.charset());
            }
            items[x] = object;
        }
        ((MutableResultSet)this.currentQuery().get()).addRow((Seq)Predef$.MODULE$.genericWrapArray((Object)items));
    }

    @Override
    public void onRowDescription(RowDescriptionMessage m) {
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)Option$.MODULE$.apply((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])m.columnDatas()))));
        this.setColumnDatas(m.columnDatas());
    }

    private void setColumnDatas(PostgreSQLColumnData[] columnDatas) {
        this.currentPreparedStatement().foreach((Function1)new Serializable(this, columnDatas){
            public static final long serialVersionUID = 0L;
            private final PostgreSQLColumnData[] columnDatas$1;

            public final void apply(PreparedStatementHolder holder) {
                holder.columnDatas_$eq(this.columnDatas$1);
            }
            {
                this.columnDatas$1 = columnDatas$1;
            }
        });
    }

    @Override
    public void onAuthenticationResponse(AuthenticationMessage message) {
        AuthenticationMessage authenticationMessage;
        block5: {
            block3: {
                block4: {
                    block2: {
                        authenticationMessage = message;
                        if (!(authenticationMessage instanceof AuthenticationOkMessage)) break block2;
                        PostgreSQLConnection$.MODULE$.log().debug("Successfully logged in to database");
                        this.authenticated_$eq(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(authenticationMessage instanceof AuthenticationChallengeCleartextMessage)) break block4;
                    AuthenticationChallengeCleartextMessage authenticationChallengeCleartextMessage = (AuthenticationChallengeCleartextMessage)authenticationMessage;
                    this.write(this.credential(authenticationChallengeCleartextMessage));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(authenticationMessage instanceof AuthenticationChallengeMD5)) break block5;
                AuthenticationChallengeMD5 authenticationChallengeMD5 = (AuthenticationChallengeMD5)authenticationMessage;
                this.write(this.credential(authenticationChallengeMD5));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)authenticationMessage);
    }

    private CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        if (this.configuration.username() != null && this.configuration.password().isDefined()) {
            return new CredentialMessage(this.configuration.username(), (String)this.configuration.password().get(), authenticationMessage.challengeType(), authenticationMessage.salt());
        }
        throw new MissingCredentialInformationException(this.configuration.username(), (Option<String>)this.configuration.password(), authenticationMessage.challengeType());
    }

    private Nothing$ notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnection$.MODULE$.log().error(errorMessage);
        throw new ConnectionStillRunningQueryException(this.currentCount(), race);
    }

    public void validateIfItIsReadyForQuery(String errorMessage) {
        if (this.queryPromise().isDefined()) {
            throw this.notReadyForQueryError(errorMessage, false);
        }
    }

    private void validateQuery(String query) {
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (query == null || query.isEmpty()) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            return;
        }
        throw this.notReadyForQueryError("Can't run query due to a race with another started query", true);
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Promise<QueryResult> apply(Promise<QueryResult> promise) {
                PostgreSQLConnection$.MODULE$.log().error("Setting error on future {}", new Object[]{promise});
                return promise.failure(this.t$1);
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public void com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$succeedQueryPromise(QueryResult result) {
        this.queryResult_$eq((Option<QueryResult>)None$.MODULE$);
        this.clearQueryPromise().foreach((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final QueryResult result$1;

            public final Promise<QueryResult> apply(Promise<QueryResult> x$1) {
                return x$1.success((Object)this.result$1);
            }
            {
                this.result$1 = result$1;
            }
        });
    }

    public void write(ClientMessage message) {
        this.connectionHandler().write(message);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "{counter=", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), BoxesRunTime.boxToLong((long)this.currentCount())}));
    }

    public PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry encoderRegistry, ColumnDecoderRegistry decoderRegistry, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        Connection.class.$init$((Connection)this);
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, encoderRegistry, decoderRegistry, this, group, executionContext);
        this.currentCount = PostgreSQLConnection$.MODULE$.Counter().incrementAndGet();
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter = new AtomicInteger();
        this.internalExecutionContext = executionContext;
        this.parameterStatus = new HashMap();
        this.parsedStatements = new HashMap();
        this.authenticated = false;
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture = Promise$.MODULE$.apply();
        this.recentError = false;
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.currentQuery = None$.MODULE$;
        this.currentPreparedStatement = None$.MODULE$;
        this.version = new Version(0, 0, 0);
        this.queryResult = None$.MODULE$;
    }
}

