/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.codec;

import com.github.mauricio.async.db.exceptions.NegativeMessageSizeException;
import com.github.mauricio.async.db.postgresql.codec.MessageDecoder$;
import com.github.mauricio.async.db.postgresql.exceptions.MessageTooLongException;
import com.github.mauricio.async.db.postgresql.messages.backend.ServerMessage;
import com.github.mauricio.async.db.postgresql.parsers.AuthenticationStartupParser$;
import com.github.mauricio.async.db.postgresql.parsers.MessageParsersRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}q!B\u0001\u0003\u0011\u0003\t\u0012AD'fgN\fw-\u001a#fG>$WM\u001d\u0006\u0003\u0007\u0011\tQaY8eK\u000eT!!\u0002\u0004\u0002\u0015A|7\u000f^4sKN\fHN\u0003\u0002\b\u0011\u0005\u0011AM\u0019\u0006\u0003\u0013)\tQ!Y:z]\u000eT!a\u0003\u0007\u0002\u00115\fWO]5dS>T!!\u0004\b\u0002\r\u001dLG\u000f[;c\u0015\u0005y\u0011aA2p[\u000e\u0001\u0001C\u0001\n\u0014\u001b\u0005\u0011a!\u0002\u000b\u0003\u0011\u0003)\"AD'fgN\fw-\u001a#fG>$WM]\n\u0003'Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007\"B\u000f\u0014\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001\u0012\u0011\u001d\u00013C1A\u0005\u0002\u0005\n1\u0001\\8h+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\n\u0002\u0007\u0019><w-\u001a:\t\r-\u001a\u0002\u0015!\u0003#\u0003\u0011awn\u001a\u0011\t\u000f5\u001a\"\u0019!C\u0001]\u0005\u0011B)\u001a4bk2$X*\u0019=j[Vl7+\u001b>f+\u0005y\u0003CA\f1\u0013\t\t\u0004DA\u0002J]RDaaM\n!\u0002\u0013y\u0013a\u0005#fM\u0006,H\u000e^'bq&lW/\\*ju\u0016\u0004\u0003bB\u001b\u0014#\u0003%\tAN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003]R#a\f\u001d,\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0013Ut7\r[3dW\u0016$'B\u0001 \u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0001n\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\r\u0011!\"\u0001\u0001\"\u0014\u0005\u0005\u001b\u0005C\u0001#M\u001b\u0005)%BA\u0002G\u0015\t9\u0005*A\u0004iC:$G.\u001a:\u000b\u0005%S\u0015!\u00028fiRL(\"A&\u0002\u0005%|\u0017BA'F\u0005Q\u0011\u0015\u0010^3U_6+7o]1hK\u0012+7m\u001c3fe\"Aq*\u0011B\u0001B\u0003%\u0001+A\u0004dQ\u0006\u00148/\u001a;\u0011\u0005E;V\"\u0001*\u000b\u0005=\u001b&B\u0001+V\u0003\rq\u0017n\u001c\u0006\u0002-\u0006!!.\u0019<b\u0013\tA&KA\u0004DQ\u0006\u00148/\u001a;\t\u0011i\u000b%\u0011!Q\u0001\n=\n!#\\1yS6,X.T3tg\u0006<WmU5{K\")Q$\u0011C\u00019R\u0019QLX0\u0011\u0005I\t\u0005\"B(\\\u0001\u0004\u0001\u0006b\u0002.\\!\u0003\u0005\ra\f\u0005\bC\u0006\u0013\r\u0011\"\u0003c\u0003\u0019\u0001\u0018M]:feV\t1\r\u0005\u0002eO6\tQM\u0003\u0002g\t\u00059\u0001/\u0019:tKJ\u001c\u0018B\u00015f\u0005YiUm]:bO\u0016\u0004\u0016M]:feN\u0014VmZ5tiJL\bB\u00026BA\u0003%1-A\u0004qCJ\u001cXM\u001d\u0011\t\u000b1\fE\u0011I7\u0002\r\u0011,7m\u001c3f)\u0015q\u0017/_A\u0002!\t9r.\u0003\u0002q1\t!QK\\5u\u0011\u0015\u00118\u000e1\u0001t\u0003\r\u0019G\u000f\u001f\t\u0003i^l\u0011!\u001e\u0006\u0003m\"\u000bqa\u00195b]:,G.\u0003\u0002yk\n)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"\u0002>l\u0001\u0004Y\u0018!\u00012\u0011\u0005q|X\"A?\u000b\u0005yD\u0015A\u00022vM\u001a,'/C\u0002\u0002\u0002u\u0014qAQ=uK\n+h\rC\u0004\u0002\u0006-\u0004\r!a\u0002\u0002\u0007=,H\u000f\u0005\u0004\u0002\n\u0005=\u00111C\u0007\u0003\u0003\u0017Q1!!\u0004V\u0003\u0011)H/\u001b7\n\t\u0005E\u00111\u0002\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"V\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001e\u0005]!AB(cU\u0016\u001cG\u000f")
public class MessageDecoder
extends ByteToMessageDecoder {
    private final int maximumMessageSize;
    private final MessageParsersRegistry parser;

    public static int $lessinit$greater$default$2() {
        return MessageDecoder$.MODULE$.$lessinit$greater$default$2();
    }

    public static int DefaultMaximumSize() {
        return MessageDecoder$.MODULE$.DefaultMaximumSize();
    }

    public static Logger log() {
        return MessageDecoder$.MODULE$.log();
    }

    private MessageParsersRegistry parser() {
        return this.parser;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf b, List<Object> out) {
        if (b.readableBytes() >= 5) {
            b.markReaderIndex();
            byte code = b.readByte();
            int lengthWithSelf = b.readInt();
            int length = lengthWithSelf - 4;
            if (length < 0) {
                throw new NegativeMessageSizeException(code, length);
            }
            if (length > this.maximumMessageSize) {
                throw new MessageTooLongException(code, length, this.maximumMessageSize);
            }
            if (b.readableBytes() >= length) {
                byte by = code;
                switch (by) {
                    default: {
                        ServerMessage msg = this.parser().parse(code, b.readSlice(length));
                        out.add(msg);
                        break;
                    }
                    case 82: {
                        ServerMessage msg = AuthenticationStartupParser$.MODULE$.parseMessage(b);
                        out.add(msg);
                        break;
                    }
                }
            } else {
                b.resetReaderIndex();
                return;
            }
        }
    }

    public MessageDecoder(Charset charset, int maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
        this.parser = new MessageParsersRegistry(charset);
    }
}

