/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.mysql.encoder;

import com.github.mauricio.async.db.exceptions.UnsupportedAuthenticationMethodException;
import com.github.mauricio.async.db.mysql.encoder.HandshakeResponseEncoder$;
import com.github.mauricio.async.db.mysql.encoder.MessageEncoder;
import com.github.mauricio.async.db.mysql.encoder.auth.MySQLNativePasswordAuthentication;
import com.github.mauricio.async.db.mysql.message.client.ClientMessage;
import com.github.mauricio.async.db.mysql.message.client.HandshakeResponseMessage;
import com.github.mauricio.async.db.mysql.util.CharsetMapper;
import com.github.mauricio.async.db.util.ChannelUtils$;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]t!B\u0001\u0003\u0011\u0003\t\u0012\u0001\u0007%b]\u0012\u001c\b.Y6f%\u0016\u001c\bo\u001c8tK\u0016s7m\u001c3fe*\u00111\u0001B\u0001\bK:\u001cw\u000eZ3s\u0015\t)a!A\u0003nsN\fHN\u0003\u0002\b\u0011\u0005\u0011AM\u0019\u0006\u0003\u0013)\tQ!Y:z]\u000eT!a\u0003\u0007\u0002\u00115\fWO]5dS>T!!\u0004\b\u0002\r\u001dLG\u000f[;c\u0015\u0005y\u0011aA2p[\u000e\u0001\u0001C\u0001\n\u0014\u001b\u0005\u0011a!\u0002\u000b\u0003\u0011\u0003)\"\u0001\u0007%b]\u0012\u001c\b.Y6f%\u0016\u001c\bo\u001c8tK\u0016s7m\u001c3feN\u00111C\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000bu\u0019B\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005\t\u0002b\u0002\u0011\u0014\u0005\u0004%)!I\u0001\u0013\u00072KUI\u0014+`!J{EkT\"P\u0019~#\u0014'F\u0001#\u001f\u0005\u0019SD\u0001\u0002\u0001\u0011\u0019)3\u0003)A\u0007E\u0005\u00192\tT%F\u001dR{\u0006KU(U\u001f\u000e{Ej\u0018\u001b2A!9qe\u0005b\u0001\n\u000bA\u0013\u0001G\"M\u0013\u0016sEkX*F\u0007V\u0013ViX\"P\u001d:+5\tV%P\u001dV\t\u0011fD\u0001+;\r\u0001\u0001\u0011\u0001\u0005\u0007YM\u0001\u000bQB\u0015\u00023\rc\u0015*\u0012(U?N+5)\u0016*F?\u000e{eJT#D)&{e\n\t\u0005\b]M\u0011\r\u0011\"\u00020\u0003Y\u0019E*S#O)~\u001buJ\u0014(F\u0007R{v+\u0013+I?\u0012\u0013U#\u0001\u0019\u0010\u0003Ej\u0012\u0001\u0003\u0005\u0007gM\u0001\u000bQ\u0002\u0019\u0002/\rc\u0015*\u0012(U?\u000e{eJT#D)~;\u0016\n\u0016%`\t\n\u0003\u0003bB\u001b\u0014\u0005\u0004%)AN\u0001\u0014\u00072KUI\u0014+`)J\u000bejU!D)&{ejU\u000b\u0002o=\t\u0001(\b\u0002!\u0001!1!h\u0005Q\u0001\u000e]\nAc\u0011'J\u000b:#v\f\u0016*B\u001dN\u000b5\tV%P\u001dN\u0003\u0003b\u0002\u001f\u0014\u0005\u0004%)!P\u0001\u0015\u00072KUI\u0014+`\u001bVcE+S0S\u000bN+F\nV*\u0016\u0003yz\u0011aP\u000f\u0004A\u0001\u0001\u0001BB!\u0014A\u00035a(A\u000bD\u0019&+e\nV0N+2#\u0016j\u0018*F'VcEk\u0015\u0011\t\u000f\r\u001b\"\u0019!C\u0003\t\u0006\u00012\tT%F\u001dR{Fj\u0014(H?\u001ac\u0015iR\u000b\u0002\u000b>\ta)H\u0001\u0002\u0011\u0019A5\u0003)A\u0007\u000b\u0006\t2\tT%F\u001dR{Fj\u0014(H?\u001ac\u0015i\u0012\u0011\t\u000f)\u001b\"\u0019!C\u0003\u0017\u0006\u00112\tT%F\u001dR{\u0006\u000bT+H\u0013:{\u0016)\u0016+I+\u0005au\"A'\u001e\u0007!\u0001\u0001\u0001\u0003\u0004P'\u0001\u0006i\u0001T\u0001\u0014\u00072KUI\u0014+`!2+v)\u0013(`\u0003V#\u0006\n\t\u0005\b#N\u0011\r\u0011\"\u0002S\u0003-i\u0015\tW04?\nKF+R*\u0016\u0003M{\u0011\u0001V\u000f\u0005\u0001}\u0000\u0000 \u0003\u0004W'\u0001\u0006iaU\u0001\r\u001b\u0006CvlM0C3R+5\u000b\t\u0005\b1N\u0011\r\u0011\"\u0002Z\u0003\u001d\u0001\u0016\t\u0012#J\u001d\u001e+\u0012A\u0017\t\u0004/mk\u0016B\u0001/\u0019\u0005\u0015\t%O]1z!\t9b,\u0003\u0002`1\t!!)\u001f;f\u0011\u0019\t7\u0003)A\u00075\u0006A\u0001+\u0011#E\u0013:;\u0005\u0005C\u0004d'\t\u0007IQ\u00013\u0002\u00071|w-F\u0001f!\t17.D\u0001h\u0015\tA\u0017.A\u0003tY\u001a$$NC\u0001k\u0003\ry'oZ\u0005\u0003Y\u001e\u0014a\u0001T8hO\u0016\u0014\bB\u00028\u0014A\u00035Q-\u0001\u0003m_\u001e\u0004c\u0001\u0002\u000b\u0003\u0001A\u001c2a\u001c\fr!\t\u0011\"/\u0003\u0002t\u0005\tqQ*Z:tC\u001e,WI\\2pI\u0016\u0014\b\u0002C;p\u0005\u0003\u0005\u000b\u0011\u0002<\u0002\u000f\rD\u0017M]:fiB\u0011q/`\u0007\u0002q*\u0011Q/\u001f\u0006\u0003un\f1A\\5p\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A =\u0003\u000f\rC\u0017M]:fi\"Q\u0011\u0011A8\u0003\u0002\u0003\u0006I!a\u0001\u0002\u001b\rD\u0017M]:fi6\u000b\u0007\u000f]3s!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\t\u0005!Q\u000f^5m\u0013\u0011\ti!a\u0002\u0003\u001b\rC\u0017M]:fi6\u000b\u0007\u000f]3s\u0011\u0019ir\u000e\"\u0001\u0002\u0012Q1\u00111CA\u000b\u0003/\u0001\"AE8\t\rU\fy\u00011\u0001w\u0011!\t\t!a\u0004A\u0002\u0005\r\u0001\"CA\u000e_\n\u0007I\u0011BA\u000f\u0003U\tW\u000f\u001e5f]RL7-\u0019;j_:lU\r\u001e5pIN,\"!a\b\u0011\u0011\u0005\u0005\u00121FA\u0018\u0003wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\nS6lW\u000f^1cY\u0016T1!!\u000b\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\t\u0019CA\u0002NCB\u0004B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kY\u0018\u0001\u00027b]\u001eLA!!\u000f\u00024\t11\u000b\u001e:j]\u001e\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003\u0012\u0011\u0001B1vi\"LA!!\u0012\u0002@\t\tS*_*R\u0019:\u000bG/\u001b<f!\u0006\u001c8o^8sI\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\"A\u0011\u0011J8!\u0002\u0013\ty\"\u0001\fbkRDWM\u001c;jG\u0006$\u0018n\u001c8NKRDw\u000eZ:!\u0011\u001d\tie\u001cC\u0001\u0003\u001f\na!\u001a8d_\u0012,G\u0003BA)\u0003K\u0002B!a\u0015\u0002b5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0004ck\u001a4WM\u001d\u0006\u0005\u00037\ni&A\u0003oKR$\u0018P\u0003\u0002\u0002`\u0005\u0011\u0011n\\\u0005\u0005\u0003G\n)FA\u0004CsR,')\u001e4\t\u0011\u0005\u001d\u00141\na\u0001\u0003S\nq!\\3tg\u0006<W\r\u0005\u0003\u0002l\u0005MTBAA7\u0015\u0011\ty'!\u001d\u0002\r\rd\u0017.\u001a8u\u0015\r\t9\u0007B\u0005\u0005\u0003k\niGA\u0007DY&,g\u000e^'fgN\fw-\u001a")
public class HandshakeResponseEncoder
implements MessageEncoder {
    private final Charset charset;
    private final CharsetMapper charsetMapper;
    private final Map<String, MySQLNativePasswordAuthentication> authenticationMethods;

    public static Logger log() {
        return HandshakeResponseEncoder$.MODULE$.log();
    }

    public static byte[] PADDING() {
        return HandshakeResponseEncoder$.MODULE$.PADDING();
    }

    public static int MAX_3_BYTES() {
        return HandshakeResponseEncoder$.MODULE$.MAX_3_BYTES();
    }

    public static int CLIENT_PLUGIN_AUTH() {
        return HandshakeResponseEncoder$.MODULE$.CLIENT_PLUGIN_AUTH();
    }

    public static int CLIENT_LONG_FLAG() {
        return HandshakeResponseEncoder$.MODULE$.CLIENT_LONG_FLAG();
    }

    public static int CLIENT_MULTI_RESULTS() {
        return HandshakeResponseEncoder$.MODULE$.CLIENT_MULTI_RESULTS();
    }

    public static int CLIENT_TRANSACTIONS() {
        return HandshakeResponseEncoder$.MODULE$.CLIENT_TRANSACTIONS();
    }

    public static int CLIENT_CONNECT_WITH_DB() {
        return HandshakeResponseEncoder$.MODULE$.CLIENT_CONNECT_WITH_DB();
    }

    public static int CLIENT_SECURE_CONNECTION() {
        return HandshakeResponseEncoder$.MODULE$.CLIENT_SECURE_CONNECTION();
    }

    public static int CLIENT_PROTOCOL_41() {
        return HandshakeResponseEncoder$.MODULE$.CLIENT_PROTOCOL_41();
    }

    private Map<String, MySQLNativePasswordAuthentication> authenticationMethods() {
        return this.authenticationMethods;
    }

    @Override
    public ByteBuf encode(ClientMessage message) {
        ByteBuf byteBuf;
        ByteBuf byteBuf2;
        HandshakeResponseMessage m = (HandshakeResponseMessage)message;
        int clientCapabilities = 0;
        clientCapabilities |= 0x28A200;
        if (m.database().isDefined()) {
            clientCapabilities |= 8;
        }
        ByteBuf buffer = ChannelUtils$.MODULE$.packetBuffer(ChannelUtils$.MODULE$.packetBuffer$default$1());
        buffer.writeInt(clientCapabilities);
        buffer.writeInt(0xFFFFFF);
        buffer.writeByte(this.charsetMapper.toInt(this.charset));
        buffer.writeBytes(HandshakeResponseEncoder$.MODULE$.PADDING());
        ChannelUtils$.MODULE$.writeCString(m.username(), buffer, this.charset);
        if (m.password().isDefined()) {
            String method = (String)m.authenticationMethod().get();
            MySQLNativePasswordAuthentication authenticator = (MySQLNativePasswordAuthentication)this.authenticationMethods().getOrElse((Object)method, (Function0)new Serializable(this, method){
                public static final long serialVersionUID = 0L;
                private final String method$1;

                public final Nothing$ apply() {
                    throw new UnsupportedAuthenticationMethodException(this.method$1);
                }
                {
                    this.method$1 = method$1;
                }
            });
            byte[] bytes = authenticator.generateAuthentication(m.username(), m.password(), m.seed());
            buffer.writeByte(bytes.length);
            byteBuf2 = buffer.writeBytes(bytes);
        } else {
            byteBuf2 = buffer.writeByte(0);
        }
        if (m.database().isDefined()) {
            ChannelUtils$.MODULE$.writeCString((String)m.database().get(), buffer, this.charset);
        }
        if (m.authenticationMethod().isDefined()) {
            ChannelUtils$.MODULE$.writeCString((String)m.authenticationMethod().get(), buffer, this.charset);
            byteBuf = BoxedUnit.UNIT;
        } else {
            byteBuf = buffer.writeByte(0);
        }
        return buffer;
    }

    public HandshakeResponseEncoder(Charset charset, CharsetMapper charsetMapper) {
        this.charset = charset;
        this.charsetMapper = charsetMapper;
        this.authenticationMethods = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"mysql_native_password"), (Object)new MySQLNativePasswordAuthentication(charset))}));
    }
}

