/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.mysql.binary;

import com.github.mauricio.async.db.exceptions.BufferNotFullyConsumedException;
import com.github.mauricio.async.db.mysql.binary.BinaryRowDecoder$;
import com.github.mauricio.async.db.mysql.message.server.ColumnDefinitionMessage;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t<Q!\u0001\u0002\t\u0002E\t\u0001CQ5oCJL(k\\<EK\u000e|G-\u001a:\u000b\u0005\r!\u0011A\u00022j]\u0006\u0014\u0018P\u0003\u0002\u0006\r\u0005)Q._:rY*\u0011q\u0001C\u0001\u0003I\nT!!\u0003\u0006\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005-a\u0011\u0001C7bkJL7-[8\u000b\u00055q\u0011AB4ji\",(MC\u0001\u0010\u0003\r\u0019w.\\\u0002\u0001!\t\u00112#D\u0001\u0003\r\u0015!\"\u0001#\u0001\u0016\u0005A\u0011\u0015N\\1ssJ{w\u000fR3d_\u0012,'o\u0005\u0002\u0014-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001aDQ!H\n\u0005\u0002y\ta\u0001P5oSRtD#A\t\t\u000f\u0001\u001a\"\u0019!C\u0003C\u0005\u0019An\\4\u0016\u0003\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bMdg\r\u000e6\u000b\u0003\u001d\n1a\u001c:h\u0013\tICE\u0001\u0004M_\u001e<WM\u001d\u0005\u0007WM\u0001\u000bQ\u0002\u0012\u0002\t1|w\r\t\u0005\b[M\u0011\r\u0011\"\u0002/\u00031\u0011\u0015\u000e^'ba>3gm]3u+\u0005ys\"\u0001\u0019\u001e\u0003%AaAM\n!\u0002\u001by\u0013!\u0004\"ji6\u000b\u0007o\u00144gg\u0016$\bE\u0002\u0003\u0015\u0005\u0001!4CA\u001a\u0017\u0011\u0015i2\u0007\"\u00017)\u00059\u0004C\u0001\n4\u0011\u0015I4\u0007\"\u0001;\u0003\u0019!WmY8eKR\u00191HS+\u0011\u0007q\"uI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tE\u0001\u0007yI|w\u000e\u001e \n\u0003eI!a\u0011\r\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\u000b\u0013:$W\r_3e'\u0016\f(BA\"\u0019!\t9\u0002*\u0003\u0002J1\t\u0019\u0011I\\=\t\u000b-C\u0004\u0019\u0001'\u0002\r\t,hMZ3s!\ti5+D\u0001O\u0015\tYuJ\u0003\u0002Q#\u0006)a.\u001a;us*\t!+\u0001\u0002j_&\u0011AK\u0014\u0002\b\u0005f$XMQ;g\u0011\u00151\u0006\b1\u0001X\u0003\u001d\u0019w\u000e\\;n]N\u00042\u0001\u0010-[\u0013\tIfIA\u0002TKF\u0004\"a\u00171\u000e\u0003qS!!\u00180\u0002\rM,'O^3s\u0015\tyF!A\u0004nKN\u001c\u0018mZ3\n\u0005\u0005d&aF\"pYVlg\u000eR3gS:LG/[8o\u001b\u0016\u001c8/Y4f\u0001")
public class BinaryRowDecoder {
    public static int BitMapOffset() {
        return BinaryRowDecoder$.MODULE$.BitMapOffset();
    }

    public static Logger log() {
        return BinaryRowDecoder$.MODULE$.log();
    }

    public IndexedSeq<Object> decode(ByteBuf buffer, Seq<ColumnDefinitionMessage> columns) {
        int nullCount = (columns.size() + 9) / 8;
        byte[] nullBitMask = new byte[nullCount];
        buffer.readBytes(nullBitMask);
        int nullMaskPos = 0;
        int bit = 4;
        ArrayBuffer row = new ArrayBuffer(columns.size());
        for (int index = 0; index < columns.size(); ++index) {
            ArrayBuffer arrayBuffer;
            if ((nullBitMask[nullMaskPos] & bit) != 0) {
                arrayBuffer = row.$plus$eq(null);
            } else {
                ColumnDefinitionMessage column = (ColumnDefinitionMessage)columns.apply(index);
                arrayBuffer = row.$plus$eq(column.binaryDecoder().decode(buffer));
            }
            if (((bit <<= 1) & 0xFF) != 0) continue;
            bit = 1;
            ++nullMaskPos;
        }
        if (buffer.readableBytes() != 0) {
            throw new BufferNotFullyConsumedException(buffer);
        }
        return row;
    }
}

