/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.providers;

import io.valkey.CommandArguments;
import io.valkey.Connection;
import io.valkey.ConnectionPool;
import io.valkey.DefaultJedisClientConfig;
import io.valkey.HostAndPort;
import io.valkey.JedisClientConfig;
import io.valkey.exceptions.JedisException;
import io.valkey.providers.ConnectionProvider;
import io.valkey.util.Pool;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectConnectionProvider
implements ConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(RedirectConnectionProvider.class);
    private Pool<Connection> pool;
    private HostAndPort hostAndPort;
    private JedisClientConfig clientConfig;
    private GenericObjectPoolConfig<Connection> poolConfig;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final Lock rediscoverLock = new ReentrantLock();

    public RedirectConnectionProvider(HostAndPort hostAndPort) {
        this(hostAndPort, DefaultJedisClientConfig.builder().build());
    }

    public RedirectConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(hostAndPort, clientConfig, (GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig());
    }

    public RedirectConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this.hostAndPort = hostAndPort;
        this.clientConfig = clientConfig;
        this.poolConfig = poolConfig;
        this.pool = new ConnectionPool(hostAndPort, clientConfig, poolConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewPool(Connection connection, HostAndPort targetNode) {
        if (this.rediscoverLock.tryLock()) {
            try {
                if (connection != null && connection.getMemberOf().isClosed()) {
                    return;
                }
                HostAndPort oldNode = this.hostAndPort;
                if (targetNode != null) {
                    this.hostAndPort = targetNode;
                }
                this.w.lock();
                try {
                    if (!this.pool.isClosed()) {
                        try {
                            this.pool.close();
                        }
                        catch (JedisException e) {
                            logger.warn("close pool get exception, hostAndPort:{}", (Object)oldNode, (Object)e);
                        }
                    }
                    this.pool = new ConnectionPool(this.hostAndPort, this.clientConfig, this.poolConfig);
                }
                finally {
                    this.w.unlock();
                }
            }
            finally {
                this.rediscoverLock.unlock();
            }
        }
    }

    @Override
    public void close() {
        this.w.lock();
        try {
            this.pool.close();
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public Connection getConnection(CommandArguments args) {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() {
        this.r.lock();
        try {
            Connection connection = this.pool.getResource();
            return connection;
        }
        finally {
            this.r.unlock();
        }
    }

    public Map<?, Pool<Connection>> getConnectionMap() {
        this.r.lock();
        try {
            Map<HostAndPort, Pool<Connection>> map = Collections.singletonMap(this.hostAndPort, this.pool);
            return map;
        }
        finally {
            this.r.unlock();
        }
    }
}

