/*
 * Decompiled with CFR 0.152.
 */
package io.validly;

import io.validly.FlatNotification;
import io.validly.Then;
import io.validly.ValidlyNote;
import io.validly.excpetion.ValidationErrorException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class ValidationEngine<T, FV extends ValidationEngine> {
    private final String fieldName;
    private final T value;
    private final ValidlyNote note;
    private boolean stopValidation;
    private boolean nullIsValid;
    private boolean ignore;
    private boolean failOnFirst;

    protected ValidationEngine(String fieldName, T value, ValidlyNote note) {
        this.fieldName = fieldName;
        this.value = value;
        this.note = note;
    }

    protected ValidationEngine(T value, List<String> note) {
        this(null, value, new FlatNotification(note));
    }

    protected ValidationEngine(T value) {
        this.fieldName = null;
        this.value = value;
        this.note = null;
    }

    public ValidationEngine<T, FV> must(Predicate<T> predicate, String message) {
        if (this.checkFailure(predicate)) {
            this.markAsFailed(message);
        }
        return this;
    }

    public ValidationEngine<T, FV> mustFatally(Predicate<T> predicate, String message) {
        if (this.checkFailure(predicate)) {
            this.stopValidation = true;
            this.markAsFailed(message);
        }
        return this;
    }

    public <NEW_TYPE> ValidationEngine<NEW_TYPE, ValidationEngine> mustConvert(Function<T, NEW_TYPE> conversionFunction, String message) {
        NEW_TYPE convertedValue = null;
        try {
            if (!this.stopValidation) {
                convertedValue = conversionFunction.apply(this.value);
            }
            if (convertedValue == null) {
                this.markAsFailed(message);
                this.stopValidation = true;
            }
        }
        catch (Exception e) {
            this.markAsFailed(message);
            this.stopValidation = true;
        }
        return ValidationEngine.copyValidator(convertedValue, this);
    }

    @SafeVarargs
    public final ValidationEngine<T, FV> when(Predicate<T> predicate, Then<T> ... thenPredicates) {
        return this.thenValidation(this.evaluatePredicate() && predicate.test(this.value), thenPredicates);
    }

    @SafeVarargs
    public final ValidationEngine<T, FV> when(boolean value, Then<T> ... thenPredicates) {
        return this.thenValidation(value, thenPredicates);
    }

    private boolean checkFailure(Predicate<T> predicate) {
        return this.evaluatePredicate() && !predicate.test(this.value);
    }

    private boolean evaluatePredicate() {
        return !this.ignore && !this.stopValidation && !this.valueIsNullAndItsValid();
    }

    private boolean valueIsNullAndItsValid() {
        return this.value == null && this.nullIsValid;
    }

    @SafeVarargs
    private final ValidationEngine<T, FV> thenValidation(boolean whenConditionResult, Then<T> ... thenPredicates) {
        if (whenConditionResult) {
            Arrays.stream(thenPredicates).forEach(p -> this.must(p.getPredicate(), p.getMessage()));
        }
        return this;
    }

    private void markAsFailed(String message) {
        if (this.note == null) {
            throw new ValidationErrorException("Validation error: " + message);
        }
        this.note.addMessage(this.fieldName, message);
        if (this.failOnFirst) {
            this.stopValidation = true;
        }
    }

    private static <NEW_TYPE> ValidationEngine<NEW_TYPE, ValidationEngine> copyValidator(NEW_TYPE value, ValidationEngine source) {
        ValidationEngine newValidator = new ValidationEngine(source.fieldName, value, source.note);
        newValidator.setIgnore(source.ignore);
        newValidator.setNullIsValid(source.nullIsValid);
        newValidator.setStopValidation(source.stopValidation);
        newValidator.setFailOnFirst(source.failOnFirst);
        return newValidator;
    }

    protected void setFailOnFirst(boolean failOnFirst) {
        this.failOnFirst = failOnFirst;
    }

    protected void setStopValidation(boolean stopValidation) {
        this.stopValidation = stopValidation;
    }

    void setNullIsValid(boolean nullIsValid) {
        this.nullIsValid = nullIsValid;
    }

    void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }
}

