/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.io.Serializable;
import java.util.Map;

class CrawlerBindingListener
implements HttpSessionBindingListener,
Serializable {
    private static final long serialVersionUID = -8841692120840734349L;
    private transient Map<String, String> clientIpSessionId;
    private transient Map<String, String> sessionIdClientIp;

    CrawlerBindingListener(Map<String, String> clientIpSessionId, Map<String, String> sessionIdClientIp) {
        this.clientIpSessionId = clientIpSessionId;
        this.sessionIdClientIp = sessionIdClientIp;
    }

    @Override
    public void valueBound(HttpSessionBindingEvent event) {
    }

    @Override
    public void valueUnbound(HttpSessionBindingEvent event) {
        String clientIp;
        if (this.sessionIdClientIp != null && (clientIp = this.sessionIdClientIp.remove(event.getSession().getId())) != null) {
            this.clientIpSessionId.remove(clientIp);
        }
    }
}

