/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.modules.Module;
import org.jboss.modules.Version;

final class JDKSpecific {
    private static final Gateway GATEWAY = AccessController.doPrivileged(new PrivilegedAction<Gateway>(){

        @Override
        public Gateway run() {
            return new Gateway();
        }
    });
    private static final boolean JBOSS_MODULES;

    private JDKSpecific() {
    }

    static Class<?> findCallingClass(Set<ClassLoader> rejectClassLoaders) {
        for (Class<?> caller : GATEWAY.getClassContext()) {
            ClassLoader classLoader = caller.getClassLoader();
            if (classLoader == null || rejectClassLoaders.contains(classLoader)) continue;
            return caller;
        }
        return null;
    }

    static Collection<Class<?>> findCallingClasses(Set<ClassLoader> rejectClassLoaders) {
        LinkedHashSet result = new LinkedHashSet();
        for (Class<?> caller : GATEWAY.getClassContext()) {
            ClassLoader classLoader = caller.getClassLoader();
            if (classLoader == null || rejectClassLoaders.contains(classLoader)) continue;
            result.add(caller);
        }
        return result;
    }

    static void calculateCaller(ExtLogRecord logRecord) {
        String loggerClassName = logRecord.getLoggerClassName();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        Class<?>[] classes = GATEWAY.getClassContext();
        int i = 1;
        int j = 0;
        Class<?> clazz = classes[i++];
        StackTraceElement element = stackTrace[j++];
        boolean found = false;
        while (true) {
            if (clazz.getName().equals(element.getClassName())) {
                if (clazz.getName().equals(loggerClassName)) {
                    found = true;
                } else if (found) {
                    logRecord.setSourceClassName(element.getClassName());
                    logRecord.setSourceMethodName(element.getMethodName());
                    logRecord.setSourceFileName(element.getFileName());
                    logRecord.setSourceLineNumber(element.getLineNumber());
                    if (JBOSS_MODULES) {
                        JDKSpecific.calculateModule(logRecord, clazz);
                    }
                    return;
                }
                if (j == stackTrace.length) {
                    logRecord.setUnknownCaller();
                    return;
                }
                element = stackTrace[j++];
            }
            if (i == classes.length) {
                logRecord.setUnknownCaller();
                return;
            }
            clazz = classes[i++];
        }
    }

    private static void calculateModule(ExtLogRecord logRecord, Class<?> clazz) {
        Module module = Module.forClass(clazz);
        if (module != null) {
            logRecord.setSourceModuleName(module.getName());
            Version version = module.getVersion();
            if (version != null) {
                logRecord.setSourceModuleVersion(version.toString());
            } else {
                logRecord.setSourceModuleVersion(null);
            }
        }
    }

    static {
        boolean jbossModules = false;
        try {
            Module.getStartTime();
            jbossModules = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JBOSS_MODULES = jbossModules;
    }

    static final class Gateway
    extends SecurityManager {
        Gateway() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

