/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.MoreExecutors;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcJoinPushdownUtil;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgDecimal;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.sqlserver.DataCompression;
import io.trino.plugin.sqlserver.ImplementAvgBigint;
import io.trino.plugin.sqlserver.ImplementSqlServerCountBig;
import io.trino.plugin.sqlserver.ImplementSqlServerCountBigAll;
import io.trino.plugin.sqlserver.ImplementSqlServerStddevPop;
import io.trino.plugin.sqlserver.ImplementSqlServerStdev;
import io.trino.plugin.sqlserver.ImplementSqlServerVariance;
import io.trino.plugin.sqlserver.ImplementSqlServerVariancePop;
import io.trino.plugin.sqlserver.SqlServerSessionProperties;
import io.trino.plugin.sqlserver.SqlServerTableProperties;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;

public class SqlServerClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(SqlServerClient.class);
    public static final int SQL_SERVER_MAX_LIST_EXPRESSIONS = 500;
    public static final JdbcTypeHandle BIGINT_TYPE = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private final boolean statisticsEnabled;
    private final ConnectorExpressionRewriter<String> connectorExpressionRewriter;
    private final AggregateFunctionRewriter<JdbcExpression, String> aggregateFunctionRewriter;
    private static final int MAX_SUPPORTED_TEMPORAL_PRECISION = 7;

    @Inject
    public SqlServerClient(BaseJdbcConfig config, JdbcStatisticsConfig statisticsConfig, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping) {
        super(config, "\"", connectionFactory, queryBuilder, identifierMapping);
        this.statisticsEnabled = Objects.requireNonNull(statisticsConfig, "statisticsConfig is null").isEnabled();
        this.connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((SqlServerClient)this).quoted(arg_0)).build();
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementSqlServerCountBigAll()).add((Object)new ImplementSqlServerCountBig()).add((Object)new ImplementMinMax(false)).add((Object)new ImplementSum(SqlServerClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementSqlServerStdev()).add((Object)new ImplementSqlServerStddevPop()).add((Object)new ImplementSqlServerVariance()).add((Object)new ImplementSqlServerVariancePop()).build());
    }

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        JdbcOutputTableHandle table = super.beginCreateTable(session, tableMetadata);
        this.enableTableLockOnBulkLoadTableOption(session, table);
        return table;
    }

    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        JdbcOutputTableHandle table = super.beginInsertTable(session, tableHandle, columns);
        this.enableTableLockOnBulkLoadTableOption(session, table);
        return table;
    }

    protected void enableTableLockOnBulkLoadTableOption(ConnectorSession session, JdbcOutputTableHandle table) {
        if (!this.isTableLockNeeded(session)) {
            return;
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Object[] objectArray = new Object[1];
            objectArray[0] = this.quoted(table.getCatalogName(), table.getSchemaName(), table.getTemporaryTableName().orElseGet(() -> ((JdbcOutputTableHandle)table).getTableName()));
            String sql = String.format("EXEC sp_tableoption '%s', 'table lock on bulk load', '1'", objectArray);
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected boolean isTableLockNeeded(ConnectorSession session) {
        return SqlServerSessionProperties.isBulkCopyForWrite(session) && SqlServerSessionProperties.isBulkCopyForWriteLockDestinationTable(session);
    }

    protected void verifyTableName(DatabaseMetaData databaseMetadata, String tableName) throws SQLException {
        if (tableName.length() > databaseMetadata.getMaxTableNameLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Table name must be shorter than or equal to '%s' characters but got '%s'", databaseMetadata.getMaxTableNameLength(), tableName.length()));
        }
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        super.renameTable(session, catalogName, schemaName, tableName, newTable);
    }

    protected String renameTableSql(String catalogName, String remoteSchemaName, String remoteTableName, String newRemoteSchemaName, String newRemoteTableName) {
        return String.format("sp_rename %s, %s", SqlServerClient.singleQuote(catalogName, remoteSchemaName, remoteTableName), SqlServerClient.singleQuote(newRemoteTableName));
    }

    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        String sql = String.format("sp_rename %s, %s, 'COLUMN'", SqlServerClient.singleQuote(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), jdbcColumn.getColumnName()), SqlServerClient.singleQuote(newColumnName));
        this.execute(session, sql);
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    protected void copyTableSchema(Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String sql = String.format("SELECT %s INTO %s FROM %s WHERE 0 = 1", columnNames.stream().map(arg_0 -> ((SqlServerClient)this).quoted(arg_0)).collect(Collectors.joining(", ")), this.quoted(catalogName, schemaName, newTableName), this.quoted(catalogName, schemaName, tableName));
        this.execute(connection, sql);
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName;
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle))) {
            case "varbinary": {
                return Optional.of(SqlServerClient.varbinaryColumnMapping());
            }
            case "datetimeoffset": {
                return Optional.of(SqlServerClient.timestampWithTimeZoneColumnMapping(typeHandle.getRequiredDecimalDigits()));
            }
        }
        switch (typeHandle.getJdbcType()) {
            case -7: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: 
            case 3: {
                int columnSize = typeHandle.getRequiredColumnSize();
                int decimalDigits = typeHandle.getRequiredDecimalDigits();
                int precision = columnSize + Math.max(-decimalDigits, 0);
                if (precision > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0)), (RoundingMode)RoundingMode.UNNECESSARY));
            }
            case -15: 
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -9: 
            case 12: {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -16: 
            case -1: {
                return Optional.of(SqlServerClient.longVarcharColumnMapping(typeHandle.getRequiredColumnSize()));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(SqlServerClient.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, (LongReadFunction)SqlServerClient.sqlServerDateReadFunction(), (LongWriteFunction)SqlServerClient.sqlServerDateWriteFunction()));
            }
            case 92: {
                TimeType timeType = TimeType.createTimeType((int)typeHandle.getRequiredDecimalDigits());
                return Optional.of(ColumnMapping.longMapping((Type)timeType, (LongReadFunction)StandardColumnMappings.timeReadFunction((TimeType)timeType), (LongWriteFunction)this.sqlServerTimeWriteFunction(timeType.getPrecision())));
            }
            case 93: {
                int precision = typeHandle.getRequiredDecimalDigits();
                return Optional.of(StandardColumnMappings.timestampColumnMapping((TimestampType)TimestampType.createTimestampType((int)precision)));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return SqlServerClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"bit", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"real", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() || varcharType.getBoundedLength() > 4000 ? "nvarchar(max)" : "nvarchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            Object dataType = charType.getLength() > 4000 ? "nvarchar(max)" : "nchar(" + charType.getLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarbinaryType) {
            return WriteMapping.sliceMapping((String)"varbinary(max)", (SliceWriteFunction)SqlServerClient.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)SqlServerClient.sqlServerDateWriteFunction());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            int precision = Math.min(timeType.getPrecision(), 7);
            String dataType = String.format("time(%d)", precision);
            return WriteMapping.longMapping((String)dataType, (LongWriteFunction)this.sqlServerTimeWriteFunction(precision));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            int precision = Math.min(timestampType.getPrecision(), 7);
            String dataType = String.format("datetime2(%d)", precision);
            if (timestampType.getPrecision() <= 6) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((TimestampType)timestampType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longTimestampWriteFunction((TimestampType)timestampType, (int)precision));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        if (!this.statisticsEnabled) {
            return TableStatistics.empty();
        }
        if (!handle.isNamedRelation()) {
            return TableStatistics.empty();
        }
        try {
            return this.readTableStatistics(session, handle);
        }
        catch (RuntimeException | SQLException e) {
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed fetching statistics for table: " + handle, (Throwable)e);
        }
    }

    private TableStatistics readTableStatistics(ConnectorSession session, JdbcTableHandle table) throws SQLException {
        Preconditions.checkArgument((boolean)table.isNamedRelation(), (String)"Relation is not a table: %s", (Object)table);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            TableStatistics tableStatistics;
            block47: {
                Long rowCount;
                Long tableObjectId;
                StatisticsDao statisticsDao;
                String tableName;
                String schema;
                String catalog;
                Handle handle;
                block43: {
                    TableStatistics tableStatistics2;
                    block44: {
                        block41: {
                            TableStatistics tableStatistics3;
                            block42: {
                                block39: {
                                    TableStatistics tableStatistics4;
                                    block40: {
                                        handle = Jdbi.open((Connection)connection);
                                        catalog = table.getCatalogName();
                                        schema = table.getSchemaName();
                                        tableName = table.getTableName();
                                        statisticsDao = new StatisticsDao(handle);
                                        tableObjectId = statisticsDao.getTableObjectId(catalog, schema, tableName);
                                        if (tableObjectId != null) break block39;
                                        tableStatistics4 = TableStatistics.empty();
                                        if (handle == null) break block40;
                                        handle.close();
                                    }
                                    return tableStatistics4;
                                }
                                rowCount = statisticsDao.getRowCount(tableObjectId);
                                if (rowCount != null) break block41;
                                tableStatistics3 = TableStatistics.empty();
                                if (handle == null) break block42;
                                handle.close();
                            }
                            return tableStatistics3;
                        }
                        if (rowCount != 0L) break block43;
                        tableStatistics2 = TableStatistics.empty();
                        if (handle == null) break block44;
                        handle.close();
                    }
                    return tableStatistics2;
                }
                try {
                    TableStatistics.Builder tableStatistics5 = TableStatistics.builder();
                    tableStatistics5.setRowCount(Estimate.of((double)rowCount.longValue()));
                    Map<String, String> columnNameToStatisticsName = SqlServerClient.getColumnNameToStatisticsName(table, statisticsDao, tableObjectId);
                    for (JdbcColumnHandle column : this.getColumns(session, table)) {
                        double averageColumnLength;
                        String statisticName = columnNameToStatisticsName.get(column.getColumnName());
                        if (statisticName == null) continue;
                        long notNullValues = 0L;
                        long nullValues = 0L;
                        long distinctValues = 0L;
                        try (CallableStatement showStatistics = handle.getConnection().prepareCall("DBCC SHOW_STATISTICS (?, ?)");){
                            showStatistics.setString(1, String.format("%s.%s.%s", catalog, schema, tableName));
                            showStatistics.setString(2, statisticName);
                            boolean isResultSet = showStatistics.execute();
                            Preconditions.checkState((boolean)isResultSet, (Object)"Expected SHOW_STATISTICS to return a result set");
                            try (ResultSet resultSet = showStatistics.getResultSet();){
                                Preconditions.checkState((boolean)resultSet.next(), (Object)"No rows in result set");
                                averageColumnLength = resultSet.getDouble("Average Key Length");
                                Preconditions.checkState((!resultSet.next() ? 1 : 0) != 0, (Object)"More than one row in result set");
                            }
                            isResultSet = showStatistics.getMoreResults();
                            Preconditions.checkState((boolean)isResultSet, (Object)"Expected SHOW_STATISTICS to return second result set");
                            showStatistics.getResultSet().close();
                            isResultSet = showStatistics.getMoreResults();
                            Preconditions.checkState((boolean)isResultSet, (Object)"Expected SHOW_STATISTICS to return third result set");
                            resultSet = showStatistics.getResultSet();
                            try {
                                while (resultSet.next()) {
                                    resultSet.getObject("RANGE_HI_KEY");
                                    if (resultSet.wasNull()) {
                                        Preconditions.checkState((resultSet.getLong("RANGE_ROWS") == 0L ? 1 : 0) != 0, (Object)"Unexpected RANGE_ROWS for null fraction");
                                        Preconditions.checkState((resultSet.getLong("DISTINCT_RANGE_ROWS") == 0L ? 1 : 0) != 0, (Object)"Unexpected DISTINCT_RANGE_ROWS for null fraction");
                                        Preconditions.checkState((nullValues == 0L ? 1 : 0) != 0, (Object)"Multiple null fraction entries");
                                        nullValues += resultSet.getLong("EQ_ROWS");
                                        continue;
                                    }
                                    notNullValues += resultSet.getLong("RANGE_ROWS") + resultSet.getLong("EQ_ROWS");
                                    distinctValues += resultSet.getLong("DISTINCT_RANGE_ROWS") + (long)(resultSet.getLong("EQ_ROWS") > 0L ? 1 : 0);
                                }
                            }
                            finally {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                        }
                        ColumnStatistics statistics = ColumnStatistics.builder().setNullsFraction(Estimate.of((double)(notNullValues + nullValues == 0L ? 1.0 : 1.0 * (double)nullValues / (double)(notNullValues + nullValues)))).setDistinctValuesCount(Estimate.of((double)distinctValues)).setDataSize(Estimate.of((double)((double)rowCount.longValue() * averageColumnLength))).build();
                        tableStatistics5.setColumnStatistics((ColumnHandle)column, statistics);
                    }
                    tableStatistics = tableStatistics5.build();
                    if (handle == null) break block47;
                }
                catch (Throwable throwable) {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handle.close();
            }
            return tableStatistics;
        }
    }

    private static Map<String, String> getColumnNameToStatisticsName(JdbcTableHandle table, StatisticsDao statisticsDao, Long tableObjectId) {
        List<String> singleColumnStatistics = statisticsDao.getSingleColumnStatistics(tableObjectId);
        HashMap<String, String> columnNameToStatisticsName = new HashMap<String, String>();
        for (String statisticName : singleColumnStatistics) {
            String columnName = statisticsDao.getSingleColumnStatisticsColumnName(tableObjectId, statisticName);
            if (columnName == null || columnNameToStatisticsName.putIfAbsent(columnName, statisticName) == null) continue;
            log.debug("Multiple statistics for %s in %s: %s and %s", new Object[]{columnName, table, columnNameToStatisticsName.get(columnName), statisticName});
        }
        return columnNameToStatisticsName;
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        return JdbcJoinPushdownUtil.implementJoinCostAware((ConnectorSession)session, (JoinType)joinType, (PreparedQuery)leftSource, (PreparedQuery)rightSource, (JoinStatistics)statistics, () -> super.implementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics));
    }

    private LongWriteFunction sqlServerTimeWriteFunction(final int precision) {
        return new LongWriteFunction(){

            public String getBindExpression() {
                return String.format("CAST(? AS time(%s))", precision);
            }

            public void set(PreparedStatement statement, int index, long picosOfDay) throws SQLException {
                if ((picosOfDay = Timestamps.round((long)picosOfDay, (int)(12 - precision))) == 86400000000000000L) {
                    picosOfDay = 0L;
                }
                LocalTime localTime = StandardColumnMappings.fromTrinoTime((long)picosOfDay);
                statement.setString(index, localTime.toString());
            }
        };
    }

    private static LongWriteFunction sqlServerDateWriteFunction() {
        return (statement, index, day) -> statement.setString(index, DATE_FORMATTER.format(LocalDate.ofEpochDay(day)));
    }

    private static LongReadFunction sqlServerDateReadFunction() {
        return (resultSet, index) -> LocalDate.parse(resultSet.getString(index), DATE_FORMATTER).toEpochDay();
    }

    private static ColumnMapping timestampWithTimeZoneColumnMapping(int precision) {
        Preconditions.checkArgument((precision <= 7 ? 1 : 0) != 0, (String)"Unsupported datetimeoffset precision %s", (int)precision);
        if (precision <= 3) {
            return ColumnMapping.longMapping((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), (LongReadFunction)SqlServerClient.shortTimestampWithTimeZoneReadFunction(), (LongWriteFunction)SqlServerClient.shortTimestampWithTimeZoneWriteFunction());
        }
        return ColumnMapping.objectMapping((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), (ObjectReadFunction)SqlServerClient.longTimestampWithTimeZoneReadFunction(), (ObjectWriteFunction)SqlServerClient.longTimestampWithTimeZoneWriteFunction());
    }

    private static LongReadFunction shortTimestampWithTimeZoneReadFunction() {
        return (resultSet, columnIndex) -> {
            OffsetDateTime offsetDateTime = resultSet.getObject(columnIndex, OffsetDateTime.class);
            ZonedDateTime zonedDateTime = offsetDateTime.toZonedDateTime();
            return DateTimeEncoding.packDateTimeWithZone((long)zonedDateTime.toInstant().toEpochMilli(), (String)zonedDateTime.getZone().getId());
        };
    }

    private static LongWriteFunction shortTimestampWithTimeZoneWriteFunction() {
        return (statement, index, value) -> {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)value);
            TimeZoneKey timeZoneKey = DateTimeEncoding.unpackZoneKey((long)value);
            statement.setObject(index, OffsetDateTime.ofInstant(Instant.ofEpochMilli(millisUtc), timeZoneKey.getZoneId()));
        };
    }

    private static ObjectReadFunction longTimestampWithTimeZoneReadFunction() {
        return ObjectReadFunction.of(LongTimestampWithTimeZone.class, (resultSet, columnIndex) -> {
            OffsetDateTime offsetDateTime = resultSet.getObject(columnIndex, OffsetDateTime.class);
            return LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)offsetDateTime.toEpochSecond(), (long)((long)offsetDateTime.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)offsetDateTime.toZonedDateTime().getZone().getId()));
        });
    }

    private static ObjectWriteFunction longTimestampWithTimeZoneWriteFunction() {
        return ObjectWriteFunction.of(LongTimestampWithTimeZone.class, (statement, index, value) -> {
            long epochMillis = value.getEpochMillis();
            long epochSeconds = Math.floorDiv(epochMillis, 1000);
            int nanoAdjustment = Math.floorMod(epochMillis, 1000) * 1000000 + value.getPicosOfMilli() / 1000;
            ZoneId zoneId = TimeZoneKey.getTimeZoneKey((short)value.getTimeZoneKey()).getZoneId();
            Instant instant = Instant.ofEpochSecond(epochSeconds, nanoAdjustment);
            statement.setObject(index, OffsetDateTime.ofInstant(instant, zoneId));
        });
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return SqlServerClient.preventTextualTypeAggregationPushdown(groupingSets);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> String.format("SELECT TOP %s * FROM (%s) o", limit, sql));
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        for (JdbcSortItem sortItem : sortOrder) {
            Type sortItemType = sortItem.getColumn().getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType)) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().flatMap(sortItem -> {
                String ordering = sortItem.getSortOrder().isAscending() ? "ASC" : "DESC";
                String columnSorting = String.format("%s %s", this.quoted(sortItem.getColumn().getColumnName()), ordering);
                switch (sortItem.getSortOrder()) {
                    case ASC_NULLS_FIRST: 
                    case DESC_NULLS_LAST: {
                        return Stream.of(columnSorting);
                    }
                    case ASC_NULLS_LAST: {
                        return Stream.of(String.format("(CASE WHEN %s IS NULL THEN 1 ELSE 0 END) ASC", this.quoted(sortItem.getColumn().getColumnName())), columnSorting);
                    }
                    case DESC_NULLS_FIRST: {
                        return Stream.of(String.format("(CASE WHEN %s IS NULL THEN 1 ELSE 0 END) DESC", this.quoted(sortItem.getColumn().getColumnName())), columnSorting);
                    }
                }
                throw new UnsupportedOperationException("Unsupported sort order: " + sortItem.getSortOrder());
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s OFFSET 0 ROWS FETCH NEXT %s ROWS ONLY", query, orderBy, limit);
        });
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        if (joinCondition.getOperator() == JoinCondition.Operator.IS_DISTINCT_FROM) {
            return false;
        }
        return Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).noneMatch(type -> type instanceof CharType || type instanceof VarcharType);
    }

    protected String createTableSql(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        if (tableMetadata.getComment().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with table comment");
        }
        return String.format("CREATE TABLE %s (%s) %s", this.quoted(remoteTableName), String.join((CharSequence)", ", columns), SqlServerTableProperties.getDataCompression(tableMetadata.getProperties()).map(dataCompression -> String.format("WITH (DATA_COMPRESSION = %s)", dataCompression)).orElse(""));
    }

    protected String buildInsertSql(ConnectorSession session, RemoteTableName targetTable, RemoteTableName sourceTable, List<String> columnNames) {
        String columns = columnNames.stream().map(arg_0 -> ((SqlServerClient)this).quoted(arg_0)).collect(Collectors.joining(", "));
        return String.format("INSERT INTO %s %s (%s) SELECT %s FROM %s", targetTable, this.isTableLockNeeded(session) ? "WITH (TABLOCK)" : "", columns, columns, sourceTable);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (!tableHandle.isNamedRelation()) {
            return ImmutableMap.of();
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Map map;
            block15: {
                Handle handle = Jdbi.open((Connection)connection);
                try {
                    map = (Map)SqlServerClient.getTableDataCompressionWithRetries(handle, tableHandle).map(dataCompression -> ImmutableMap.of((Object)"data_compression", (Object)dataCompression)).orElseGet(ImmutableMap::of);
                    if (handle == null) break block15;
                }
                catch (Throwable throwable) {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handle.close();
            }
            return map;
        }
        catch (SQLException exception) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)exception);
        }
    }

    public void abortReadConnection(Connection connection, ResultSet resultSet) throws SQLException {
        if (!resultSet.isAfterLast()) {
            connection.abort(MoreExecutors.directExecutor());
        }
    }

    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        Connection connection = super.getConnection(session, handle);
        try {
            connection.unwrap(SQLServerConnection.class).setUseBulkCopyForBatchInsert(SqlServerSessionProperties.isBulkCopyForWrite(session));
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    private static String singleQuote(String ... objects) {
        return SqlServerClient.singleQuote(DOT_JOINER.join((Object[])objects));
    }

    private static String singleQuote(String literal) {
        return "'" + literal + "'";
    }

    public static ColumnMapping varbinaryColumnMapping() {
        return ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (resultSet, columnIndex) -> Slices.wrappedBuffer((byte[])resultSet.getBytes(columnIndex)), (SliceWriteFunction)SqlServerClient.varbinaryWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    public static SliceWriteFunction varbinaryWriteFunction() {
        return new SliceWriteFunction(){

            public void set(PreparedStatement statement, int index, Slice value) throws SQLException {
                statement.setBytes(index, value.getBytes());
            }

            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setBytes(index, null);
            }
        };
    }

    private static ColumnMapping longVarcharColumnMapping(int columnSize) {
        if (columnSize > 0x7FFFFFFE) {
            return ColumnMapping.sliceMapping((Type)VarcharType.createUnboundedVarcharType(), (SliceReadFunction)StandardColumnMappings.varcharReadFunction((VarcharType)VarcharType.createUnboundedVarcharType()), (SliceWriteFunction)SqlServerClient.nvarcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
        }
        return ColumnMapping.sliceMapping((Type)VarcharType.createVarcharType((int)columnSize), (SliceReadFunction)StandardColumnMappings.varcharReadFunction((VarcharType)VarcharType.createVarcharType((int)columnSize)), (SliceWriteFunction)SqlServerClient.nvarcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static SliceWriteFunction nvarcharWriteFunction() {
        return (statement, index, value) -> statement.setNString(index, value.toStringUtf8());
    }

    private static Optional<DataCompression> getTableDataCompression(Handle handle, JdbcTableHandle table) {
        return ((Query)((Query)handle.createQuery("SELECT data_compression_desc FROM sys.partitions p INNER JOIN sys.tables t ON p.object_id = t.object_id INNER JOIN sys.schemas s ON t.schema_id = s.schema_id INNER JOIN sys.indexes i ON t.object_id = i.object_id WHERE s.name = :schema AND t.name = :table_name AND p.index_id = 0 AND i.type = 0 AND i.data_space_id NOT IN (SELECT data_space_id FROM sys.partition_schemes)").bind("schema", table.getSchemaName())).bind("table_name", table.getTableName())).mapTo(String.class).findOne().flatMap(dataCompression -> Enums.getIfPresent(DataCompression.class, (String)dataCompression).toJavaUtil());
    }

    private static Optional<DataCompression> getTableDataCompressionWithRetries(Handle handle, JdbcTableHandle table) {
        int maxAttemptCount = 3;
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().withMaxAttempts(3).handleIf(throwable -> {
            int deadlockErrorCode = 1205;
            Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
            return rootCause instanceof SQLServerException && ((SQLServerException)rootCause).getSQLServerError().getErrorNumber() == 1205;
        })).onFailedAttempt(event -> log.warn(event.getLastFailure(), "Attempt %d of %d: error when getting table compression info for '%s'", new Object[]{event.getAttemptCount(), 3, table}));
        return (Optional)Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get(() -> SqlServerClient.getTableDataCompression(handle, table));
    }

    private static class StatisticsDao {
        private final Handle handle;

        public StatisticsDao(Handle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        Long getTableObjectId(String catalog, String schema, String tableName) {
            return (Long)((Query)this.handle.createQuery("SELECT object_id(:table)").bind("table", String.format("%s.%s.%s", catalog, schema, tableName))).mapTo(Long.class).findOnly();
        }

        Long getRowCount(long tableObjectId) {
            return (Long)((Query)this.handle.createQuery("SELECT sum(rows) row_count FROM sys.partitions WHERE object_id = :object_id AND index_id IN (0, 1)").bind("object_id", tableObjectId)).mapTo(Long.class).findOnly();
        }

        List<String> getSingleColumnStatistics(long tableObjectId) {
            return ((Query)this.handle.createQuery("SELECT s.name FROM sys.stats AS s JOIN sys.stats_columns AS sc ON s.object_id = sc.object_id AND s.stats_id = sc.stats_id WHERE s.object_id = :object_id GROUP BY s.name HAVING count(*) = 1 ORDER BY s.name").bind("object_id", tableObjectId)).mapTo(String.class).list();
        }

        String getSingleColumnStatisticsColumnName(long tableObjectId, String statisticsName) {
            return ((Optional)((Query)((Query)this.handle.createQuery("SELECT c.name FROM sys.stats AS s JOIN sys.stats_columns AS sc ON s.object_id = sc.object_id AND s.stats_id = sc.stats_id JOIN sys.columns AS c ON sc.object_id = c.object_id AND c.column_id = sc.column_id WHERE s.object_id = :object_id AND s.name = :statistics_name").bind("object_id", tableObjectId)).bind("statistics_name", statisticsName)).mapTo(String.class).collect(MoreCollectors.toOptional())).orElse(null);
        }
    }
}

