/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.protobuf.Descriptors;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

public interface DescriptorProvider {
    public Optional<Descriptors.Descriptor> getDescriptorFromTypeUrl(String var1);

    default public String getContents(String url) {
        Objects.requireNonNull(url, "url is null");
        ByteArrayOutputStream typeBytes = new ByteArrayOutputStream();
        try (InputStream stream = URI.create(url).toURL().openStream();){
            stream.transferTo(typeBytes);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Failed to read schema from URL", (Throwable)e);
        }
        return typeBytes.toString(StandardCharsets.UTF_8);
    }
}

