/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import com.google.common.collect.Iterables;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderFactory;
import io.trino.decoder.avro.AvroDeserializer;
import io.trino.decoder.avro.AvroReaderSupplier;
import io.trino.decoder.avro.GenericRecordRowDecoder;
import io.trino.decoder.avro.SingleValueRowDecoder;
import io.trino.decoder.dummy.DummyRowDecoderFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class AvroRowDecoderFactory
implements RowDecoderFactory {
    public static final String NAME = "avro";
    public static final String DATA_SCHEMA = "dataSchema";
    private final AvroReaderSupplier.Factory avroReaderSupplierFactory;
    private final AvroDeserializer.Factory avroDeserializerFactory;

    @Inject
    public AvroRowDecoderFactory(AvroReaderSupplier.Factory avroReaderSupplierFactory, AvroDeserializer.Factory avroDeserializerFactory) {
        this.avroReaderSupplierFactory = Objects.requireNonNull(avroReaderSupplierFactory, "avroReaderSupplierFactory is null");
        this.avroDeserializerFactory = Objects.requireNonNull(avroDeserializerFactory, "avroDeserializerFactory is null");
    }

    @Override
    public RowDecoder create(Map<String, String> decoderParams, Set<DecoderColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.isEmpty()) {
            return DummyRowDecoderFactory.DECODER_INSTANCE;
        }
        String dataSchema = Objects.requireNonNull(decoderParams.get(DATA_SCHEMA), String.format("%s cannot be null", DATA_SCHEMA));
        Schema parsedSchema = new Schema.Parser().parse(dataSchema);
        if (parsedSchema.getType().equals((Object)Schema.Type.RECORD)) {
            AvroReaderSupplier avroReaderSupplier = this.avroReaderSupplierFactory.create(parsedSchema);
            AvroDeserializer<GenericRecord> dataDecoder = this.avroDeserializerFactory.create(avroReaderSupplier);
            return new GenericRecordRowDecoder(dataDecoder, columns);
        }
        AvroReaderSupplier avroReaderSupplier = this.avroReaderSupplierFactory.create(parsedSchema);
        AvroDeserializer<Object> dataDecoder = this.avroDeserializerFactory.create(avroReaderSupplier);
        return new SingleValueRowDecoder(dataDecoder, (DecoderColumnHandle)Iterables.getOnlyElement(columns));
    }
}

