/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import java.util.Properties;
import org.postgresql.Driver;
import org.postgresql.PGProperty;

public class PostgreSqlConnectionFactoryModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory getConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider, OpenTelemetry openTelemetry) {
        Properties connectionProperties = new Properties();
        connectionProperties.put(PGProperty.REWRITE_BATCHED_INSERTS.getName(), "true");
        return new DriverConnectionFactory((java.sql.Driver)new Driver(), config.getConnectionUrl(), connectionProperties, credentialProvider, openTelemetry);
    }
}

