/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.RemoteQueryCancellationModule;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.postgresql.PostgreSqlClient;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlSessionProperties;
import org.postgresql.Driver;

public class PostgreSqlClientModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(PostgreSqlClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PostgreSqlConfig.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, PostgreSqlSessionProperties.class);
        this.install((Module)new DecimalModule());
        this.install((Module)new RemoteQueryCancellationModule());
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public ConnectionFactory getConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider) {
        return new DriverConnectionFactory((java.sql.Driver)new Driver(), config, credentialProvider);
    }
}

