/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.server.PluginClassLoader;
import io.trino.server.PluginManager;
import io.trino.server.ServerPluginsProvider;
import io.trino.server.ServerPluginsProviderConfig;
import io.trino.spi.Plugin;
import io.trino.spi.classloader.ThreadContextClassLoader;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public class PluginLoader {
    public static final String CONNECTOR = "connector:";
    public static final String BLOCK_ENCODING = "blockEncoding:";
    public static final String PARAMETRIC_TYPE = "parametricType:";
    public static final String FUNCTION = "function:";
    public static final String LANGUAGE_FUNCTION_ENGINE = "languageFunctionEngine:";
    public static final String SYSTEM_ACCESS_CONTROL = "systemAccessControl:";
    public static final String GROUP_PROVIDER = "groupProvider:";
    public static final String PASSWORD_AUTHENTICATOR = "passwordAuthenticator:";
    public static final String HEADER_AUTHENTICATOR = "headerAuthenticator:";
    public static final String CERTIFICATE_AUTHENTICATOR = "certificateAuthenticator:";
    public static final String EVENT_LISTENER = "eventListener:";
    public static final String RESOURCE_GROUP_CONFIGURATION_MANAGER = "resourceGroupConfigurationManager:";
    public static final String SESSION_PROPERTY_CONFIGURATION_MANAGER = "sessionPropertyConfigurationManager:";
    public static final String EXCHANGE_MANAGER = "exchangeManager:";

    private PluginLoader() {
    }

    public static void printPluginFeatures(Plugin plugin) {
        plugin.getConnectorFactories().forEach(factory -> System.out.println(CONNECTOR + factory.getName()));
        plugin.getBlockEncodings().forEach(encoding -> System.out.println(BLOCK_ENCODING + encoding.getName()));
        plugin.getTypes().forEach(type -> System.out.println(type.getTypeId()));
        plugin.getParametricTypes().forEach(type -> System.out.println(PARAMETRIC_TYPE + type.getName()));
        plugin.getFunctions().forEach(functionClass -> InternalFunctionBundle.extractFunctions((Class)functionClass).getFunctions().forEach(function -> System.out.println(FUNCTION + String.valueOf(function.getSignature()))));
        plugin.getLanguageFunctionEngines().forEach(engine -> System.out.println(LANGUAGE_FUNCTION_ENGINE + engine.getLanguage()));
        plugin.getSystemAccessControlFactories().forEach(factory -> System.out.println(SYSTEM_ACCESS_CONTROL + factory.getName()));
        plugin.getGroupProviderFactories().forEach(factory -> System.out.println(GROUP_PROVIDER + factory.getName()));
        plugin.getPasswordAuthenticatorFactories().forEach(factory -> System.out.println(PASSWORD_AUTHENTICATOR + factory.getName()));
        plugin.getHeaderAuthenticatorFactories().forEach(factory -> System.out.println(HEADER_AUTHENTICATOR + factory.getName()));
        plugin.getCertificateAuthenticatorFactories().forEach(factory -> System.out.println(CERTIFICATE_AUTHENTICATOR + factory.getName()));
        plugin.getEventListenerFactories().forEach(factory -> System.out.println(EVENT_LISTENER + factory.getName()));
        plugin.getResourceGroupConfigurationManagerFactories().forEach(factory -> System.out.println(RESOURCE_GROUP_CONFIGURATION_MANAGER + factory.getName()));
        plugin.getSessionPropertyConfigurationManagerFactories().forEach(factory -> System.out.println(SESSION_PROPERTY_CONFIGURATION_MANAGER + factory.getName()));
        plugin.getExchangeManagerFactories().forEach(factory -> System.out.println(EXCHANGE_MANAGER + factory.getName()));
    }

    public static List<Plugin> loadPlugins(File path) {
        ServerPluginsProviderConfig config = new ServerPluginsProviderConfig();
        config.setInstalledPluginsDir(path);
        ServerPluginsProvider pluginsProvider = new ServerPluginsProvider(config, MoreExecutors.directExecutor());
        ImmutableList.Builder plugins = ImmutableList.builder();
        pluginsProvider.loadPlugins((plugin, createClassLoader) -> PluginLoader.loadPlugin(createClassLoader, (ImmutableList.Builder<Plugin>)plugins), PluginManager::createClassLoader);
        return plugins.build();
    }

    private static void loadPlugin(Supplier<PluginClassLoader> createClassLoader, ImmutableList.Builder<Plugin> plugins) {
        PluginClassLoader pluginClassLoader = createClassLoader.get();
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader((ClassLoader)pluginClassLoader);){
            PluginLoader.loadServicePlugin(pluginClassLoader, plugins);
        }
    }

    private static void loadServicePlugin(PluginClassLoader pluginClassLoader, ImmutableList.Builder<Plugin> plugins) {
        ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class, (ClassLoader)pluginClassLoader);
        ImmutableList loadedPlugins = ImmutableList.copyOf(serviceLoader);
        Preconditions.checkState((!loadedPlugins.isEmpty() ? 1 : 0) != 0, (String)"No service providers of type %s in the classpath: %s", (Object)Plugin.class.getName(), Arrays.asList(pluginClassLoader.getURLs()));
        plugins.addAll((Iterable)loadedPlugins);
    }
}

