/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.MoreObjects;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.cli.ClientOptions;
import io.trino.cli.Console;
import io.trino.cli.ValidatingPropertiesDefaultProvider;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import picocli.CommandLine;

public final class Trino {
    private Trino() {
    }

    public static void main(String[] args) {
        System.exit(Trino.createCommandLine(new Console()).execute(args));
    }

    public static CommandLine createCommandLine(Object command) {
        CommandLine commandLine = new CommandLine(command).setCaseInsensitiveEnumValuesAllowed(true).registerConverter(ClientOptions.ClientResourceEstimate.class, ClientOptions.ClientResourceEstimate::new).registerConverter(ClientOptions.ClientSessionProperty.class, ClientOptions.ClientSessionProperty::new).registerConverter(ClientOptions.ClientExtraCredential.class, ClientOptions.ClientExtraCredential::new).registerConverter(HostAndPort.class, HostAndPort::fromString).registerConverter(Duration.class, Duration::valueOf).setExecutionExceptionHandler((e, cmd, parseResult) -> {
            System.err.println(Trino.formatCliErrorMessage(e, parseResult.hasMatchedOption("--debug")));
            return 1;
        });
        Trino.getConfigFile().ifPresent(file -> ValidatingPropertiesDefaultProvider.attach(commandLine, file));
        return commandLine;
    }

    public static String formatCliErrorMessage(Throwable throwable, boolean debug) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        if (debug) {
            builder.append((CharSequence)throwable.getClass().getName()).append((CharSequence)": ");
        }
        builder.append((CharSequence)throwable.getMessage(), AttributedStyle.BOLD.foreground(1));
        if (debug) {
            String messagePattern = Pattern.quote(throwable.getClass().getName() + ": " + throwable.getMessage());
            String stackTraceWithoutMessage = Throwables.getStackTraceAsString((Throwable)throwable).replaceFirst(messagePattern, "");
            builder.append((CharSequence)stackTraceWithoutMessage);
        }
        return builder.toAnsi();
    }

    private static Optional<File> getConfigFile() {
        return Trino.getConfigSearchPaths().filter(Optional::isPresent).map(Optional::get).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().map(Path::toFile);
    }

    private static Stream<Optional<String>> getConfigSearchPaths() {
        return Stream.of(Optional.ofNullable(Strings.emptyToNull((String)System.getenv("TRINO_CONFIG"))), Trino.resolveConfigPath(StandardSystemProperty.USER_HOME.value(), ".trino_config"), Trino.resolveConfigPath(System.getenv("XDG_CONFIG_HOME"), "/trino/config"));
    }

    private static Optional<String> resolveConfigPath(String root, String file) {
        return Optional.ofNullable(Strings.emptyToNull((String)root)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(path -> path.resolve(file).toString());
    }

    public static class VersionProvider
    implements CommandLine.IVersionProvider {
        public String[] getVersion() {
            String version = this.getClass().getPackage().getImplementationVersion();
            return new String[]{"Trino CLI " + (String)MoreObjects.firstNonNull((Object)version, (Object)"(version unknown)")};
        }
    }
}

