/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import io.trino.cli.Query;
import io.trino.client.ClientSession;
import io.trino.client.OkHttpUtil;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.client.uri.TrinoUri;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class QueryRunner
implements Closeable {
    private final AtomicReference<ClientSession> session;
    private final boolean debug;
    private final OkHttpClient httpClient;
    private final Consumer<OkHttpClient.Builder> sslSetup;

    public QueryRunner(TrinoUri uri, ClientSession session, boolean debug, HttpLoggingInterceptor.Level networkLogging) {
        this.session = new AtomicReference<ClientSession>(Objects.requireNonNull(session, "session is null"));
        this.debug = debug;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        try {
            this.sslSetup = uri.getSetupSsl();
            uri.setupClient(builder);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
        OkHttpUtil.setupTimeouts((OkHttpClient.Builder)builder, (int)30, (TimeUnit)TimeUnit.SECONDS);
        builder.addNetworkInterceptor((Interceptor)new HttpLoggingInterceptor(System.err::println).setLevel(networkLogging));
        this.httpClient = builder.build();
    }

    public ClientSession getSession() {
        return this.session.get();
    }

    public void setSession(ClientSession session) {
        this.session.set(Objects.requireNonNull(session, "session is null"));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Query startQuery(String query) {
        return new Query(this.startInternalQuery(this.session.get(), query), this.debug);
    }

    public StatementClient startInternalQuery(String query) {
        return this.startInternalQuery(ClientSession.stripTransactionId((ClientSession)this.session.get()), query);
    }

    private StatementClient startInternalQuery(ClientSession session, String query) {
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        this.sslSetup.accept(builder);
        OkHttpClient client = builder.build();
        return StatementClientFactory.newStatementClient((Call.Factory)client, (ClientSession)session, (String)query);
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }
}

