/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.annotations.VisibleForTesting;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.serviceclient.ServiceStubsOptions;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.worker.WorkerFactoryOptions;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@VisibleForTesting
public final class TestEnvironmentOptions {
    private static final TestEnvironmentOptions DEFAULT_INSTANCE = TestEnvironmentOptions.newBuilder().build();
    private final WorkerFactoryOptions workerFactoryOptions;
    private final WorkflowClientOptions workflowClientOptions;
    private final WorkflowServiceStubsOptions workflowServiceStubsOptions;
    private final Scope metricsScope;
    private final boolean useExternalService;
    private final String target;
    private final long initialTimeMillis;
    private final boolean useTimeskipping;
    @Nonnull
    private final Map<String, IndexedValueType> searchAttributes;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(TestEnvironmentOptions options) {
        return new Builder(options);
    }

    public static TestEnvironmentOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private TestEnvironmentOptions(WorkflowClientOptions workflowClientOptions, WorkerFactoryOptions workerFactoryOptions, WorkflowServiceStubsOptions workflowServiceStubsOptions, boolean useExternalService, String target, long initialTimeMillis, Scope metricsScope, boolean useTimeskipping, @Nonnull Map<String, IndexedValueType> searchAttributes) {
        this.workflowClientOptions = workflowClientOptions;
        this.workerFactoryOptions = workerFactoryOptions;
        this.workflowServiceStubsOptions = workflowServiceStubsOptions;
        this.metricsScope = metricsScope;
        this.useExternalService = useExternalService;
        this.target = target;
        this.initialTimeMillis = initialTimeMillis;
        this.useTimeskipping = useTimeskipping;
        this.searchAttributes = searchAttributes;
    }

    public WorkerFactoryOptions getWorkerFactoryOptions() {
        return this.workerFactoryOptions;
    }

    public WorkflowClientOptions getWorkflowClientOptions() {
        return this.workflowClientOptions;
    }

    public WorkflowServiceStubsOptions getWorkflowServiceStubsOptions() {
        return this.workflowServiceStubsOptions;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public boolean isUseExternalService() {
        return this.useExternalService;
    }

    public boolean isUseTimeskipping() {
        return this.useTimeskipping;
    }

    public String getTarget() {
        return this.target;
    }

    public long getInitialTimeMillis() {
        return this.initialTimeMillis;
    }

    @Nonnull
    public Map<String, IndexedValueType> getSearchAttributes() {
        return this.searchAttributes;
    }

    public String toString() {
        return "TestEnvironmentOptions{workerFactoryOptions=" + this.workerFactoryOptions + ", workflowClientOptions=" + this.workflowClientOptions + ", workflowServiceStubsOptions=" + this.workflowServiceStubsOptions + ", metricsScope=" + this.metricsScope + ", useExternalService=" + this.useExternalService + ", target=" + this.target + ", initialTimeMillis=" + this.initialTimeMillis + ", searchAttributes=" + this.searchAttributes + '}';
    }

    public static final class Builder {
        private WorkerFactoryOptions workerFactoryOptions;
        private WorkflowClientOptions workflowClientOptions;
        private WorkflowServiceStubsOptions workflowServiceStubsOptions;
        private Scope metricsScope;
        private boolean useExternalService;
        private String target;
        private long initialTimeMillis;
        private boolean useTimeskipping = true;
        private Map<String, IndexedValueType> searchAttributes = new HashMap<String, IndexedValueType>();

        private Builder() {
        }

        private Builder(TestEnvironmentOptions o) {
            this.workerFactoryOptions = o.workerFactoryOptions;
            this.workflowClientOptions = o.workflowClientOptions;
            this.workflowServiceStubsOptions = o.workflowServiceStubsOptions;
            this.metricsScope = o.metricsScope;
            this.useExternalService = o.useExternalService;
            this.target = o.target;
            this.initialTimeMillis = o.initialTimeMillis;
            this.useTimeskipping = o.useTimeskipping;
            this.searchAttributes = o.searchAttributes;
        }

        public Builder setWorkflowClientOptions(WorkflowClientOptions workflowClientOptions) {
            this.workflowClientOptions = workflowClientOptions;
            return this;
        }

        public Builder setWorkerFactoryOptions(WorkerFactoryOptions options) {
            this.workerFactoryOptions = options;
            return this;
        }

        public Builder setWorkflowServiceStubsOptions(WorkflowServiceStubsOptions options) {
            this.workflowServiceStubsOptions = options;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setUseExternalService(boolean useExternalService) {
            this.useExternalService = useExternalService;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setInitialTimeMillis(long initialTimeMillis) {
            this.initialTimeMillis = initialTimeMillis;
            return this;
        }

        public Builder setInitialTime(Instant initialTime) {
            this.initialTimeMillis = initialTime.toEpochMilli();
            return this;
        }

        public Builder setUseTimeskipping(boolean useTimeskipping) {
            this.useTimeskipping = useTimeskipping;
            return this;
        }

        public Builder registerSearchAttribute(String name, IndexedValueType type) {
            this.searchAttributes.put(name, type);
            return this;
        }

        Builder setSearchAttributes(@Nonnull Map<String, IndexedValueType> searchAttributes) {
            this.searchAttributes = new HashMap<String, IndexedValueType>(searchAttributes);
            return this;
        }

        public TestEnvironmentOptions build() {
            return new TestEnvironmentOptions(this.workflowClientOptions, this.workerFactoryOptions, this.workflowServiceStubsOptions, this.useExternalService, this.target, this.initialTimeMillis, this.metricsScope, this.useTimeskipping, this.searchAttributes);
        }

        public TestEnvironmentOptions validateAndBuildWithDefaults() {
            return new TestEnvironmentOptions((this.workflowClientOptions != null ? WorkflowClientOptions.newBuilder((WorkflowClientOptions)this.workflowClientOptions) : WorkflowClientOptions.newBuilder()).validateAndBuildWithDefaults(), (this.workerFactoryOptions != null ? WorkerFactoryOptions.newBuilder((WorkerFactoryOptions)this.workerFactoryOptions) : WorkerFactoryOptions.newBuilder()).validateAndBuildWithDefaults(), (this.workflowServiceStubsOptions != null ? WorkflowServiceStubsOptions.newBuilder((ServiceStubsOptions)this.workflowServiceStubsOptions) : WorkflowServiceStubsOptions.newBuilder()).validateAndBuildWithDefaults(), this.useExternalService, this.target, this.initialTimeMillis, (Scope)(this.metricsScope == null ? new NoopScope() : this.metricsScope), this.useTimeskipping, this.searchAttributes);
        }
    }
}

