/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;

class CronUtils {
    CronUtils() {
    }

    static Cron parseCron(String schedule) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
        CronParser parser = new CronParser(cronDefinition);
        return parser.parse(schedule);
    }

    static Duration getBackoffInterval(String schedule, Timestamp timestamp) {
        if (schedule == null || schedule.isEmpty()) {
            return Duration.ZERO;
        }
        Cron cron = CronUtils.parseCron(schedule);
        Instant i = Instant.ofEpochMilli(Timestamps.toMillis((Timestamp)timestamp));
        ZonedDateTime now = ZonedDateTime.ofInstant(i, ZoneOffset.UTC);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        Optional backoff = executionTime.timeToNextExecution(now);
        Duration backoffInterval = backoff.orElse(Duration.ZERO);
        if (backoffInterval == Duration.ZERO) {
            backoff = executionTime.timeToNextExecution(now.plusSeconds(1L));
            backoffInterval = (Duration)backoff.get();
        }
        return backoffInterval;
    }
}

