/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.refs.RefFormat;
import io.swagger.models.refs.RefType;
import io.swagger.parser.util.DeserializationUtils;
import io.swagger.parser.util.PathUtils;
import io.swagger.parser.util.RefUtils;
import io.swagger.parser.util.SwaggerDeserializer;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResolverCache {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^" + RefType.PARAMETER.getInternalPrefix() + "(?<name>.+)");
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("^" + RefType.DEFINITION.getInternalPrefix() + "(?<name>.+)");
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("^" + RefType.RESPONSE.getInternalPrefix() + "(?<name>.+)");
    private final Swagger swagger;
    private final List<AuthorizationValue> auths;
    private final Path parentDirectory;
    private final String rootPath;
    private Map<String, Object> resolutionCache = new HashMap<String, Object>();
    private Map<String, String> externalFileCache = new HashMap<String, String>();
    private Map<String, String> renameCache = new HashMap<String, String>();

    public ResolverCache(Swagger swagger, List<AuthorizationValue> auths, String parentFileLocation) {
        this.swagger = swagger;
        this.auths = auths;
        this.rootPath = parentFileLocation;
        if (parentFileLocation != null) {
            this.parentDirectory = parentFileLocation.startsWith("http") ? null : PathUtils.getParentDirectoryOfFile(parentFileLocation);
        } else {
            File file = new File(".");
            this.parentDirectory = file.toPath();
        }
    }

    public <T> T loadRef(String ref, RefFormat refFormat, Class<T> expectedType) {
        Object result;
        String[] jsonPathElements;
        if (refFormat == RefFormat.INTERNAL) {
            return expectedType.cast(this.loadInternalRef(ref));
        }
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String definitionPath = refParts.length == 2 ? refParts[1] : null;
        Object previouslyResolvedEntity = this.resolutionCache.get(ref);
        if (previouslyResolvedEntity != null) {
            return expectedType.cast(previouslyResolvedEntity);
        }
        String contents = this.externalFileCache.get(file);
        if (contents == null) {
            if (this.parentDirectory != null) {
                contents = RefUtils.readExternalRef(file, refFormat, this.auths, this.parentDirectory);
            } else if (this.rootPath != null) {
                contents = RefUtils.readExternalUrlRef(file, refFormat, this.auths, this.rootPath);
            }
            this.externalFileCache.put(file, contents);
        }
        if (definitionPath == null) {
            T result2 = DeserializationUtils.deserialize(contents, file, expectedType);
            this.resolutionCache.put(ref, result2);
            return result2;
        }
        JsonNode tree = DeserializationUtils.deserializeIntoTree(contents, file);
        for (String jsonPathElement : jsonPathElements = definitionPath.split("/")) {
            if ((tree = tree.get(jsonPathElement)) != null) continue;
            throw new RuntimeException("Could not find " + definitionPath + " in contents of " + file);
        }
        if (expectedType.equals(Model.class)) {
            SwaggerDeserializer ser = new SwaggerDeserializer();
            result = ser.definition((ObjectNode)tree, definitionPath.replace("/", "."), null);
        } else {
            result = DeserializationUtils.deserialize(tree, file, expectedType);
        }
        this.resolutionCache.put(ref, result);
        return result;
    }

    private Object loadInternalRef(String ref) {
        Object result = null;
        if (ref.startsWith("#/definitions")) {
            result = this.getFromMap(ref, this.swagger.getParameters(), PARAMETER_PATTERN);
        } else if (ref.startsWith("#/responses")) {
            result = this.getFromMap(ref, this.swagger.getResponses(), RESPONSE_PATTERN);
        } else if (ref.startsWith("#/parameters")) {
            result = this.getFromMap(ref, this.swagger.getParameters(), PARAMETER_PATTERN);
        }
        if (result == null) {
            result = this.getFromMap(ref, this.swagger.getDefinitions(), DEFINITION_PATTERN);
        }
        return result;
    }

    private Object getFromMap(String ref, Map map, Pattern pattern) {
        Matcher parameterMatcher = pattern.matcher(ref);
        if (parameterMatcher.matches()) {
            String paramName = parameterMatcher.group("name");
            if (map != null) {
                return map.get(paramName);
            }
        }
        return null;
    }

    public String getRenamedRef(String originalRef) {
        return this.renameCache.get(originalRef);
    }

    public void putRenamedRef(String originalRef, String newRef) {
        this.renameCache.put(originalRef, newRef);
    }

    public Map<String, Object> getResolutionCache() {
        return Collections.unmodifiableMap(this.resolutionCache);
    }

    public Map<String, String> getExternalFileCache() {
        return Collections.unmodifiableMap(this.externalFileCache);
    }

    public Map<String, String> getRenameCache() {
        return Collections.unmodifiableMap(this.renameCache);
    }
}

