/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.wordnik.swagger.models.ArrayModel;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.ModelImpl;
import com.wordnik.swagger.models.Operation;
import com.wordnik.swagger.models.Path;
import com.wordnik.swagger.models.RefModel;
import com.wordnik.swagger.models.Response;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.auth.AuthorizationValue;
import com.wordnik.swagger.models.parameters.BodyParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.RefParameter;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.util.Json;
import io.swagger.parser.ResolverOptions;
import io.swagger.parser.util.RemoteUrl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerResolver {
    Logger LOGGER = LoggerFactory.getLogger(SwaggerResolver.class);
    protected Swagger swagger;
    protected Map<String, ResolutionContext> resolutionMap = new HashMap<String, ResolutionContext>();
    protected ResolverOptions opts;

    public SwaggerResolver() {
    }

    public SwaggerResolver(ResolverOptions opts) {
        this.opts = opts;
    }

    public Swagger resolve(Swagger swagger, List<AuthorizationValue> auths) {
        if (swagger == null) {
            return null;
        }
        this.swagger = swagger;
        this.detectModelRefs();
        this.detectOperationRefs();
        this.applyResolutions(auths);
        return this.swagger;
    }

    public void applyResolutions(List<AuthorizationValue> auths) {
        HashMap hostToObjectMap = new HashMap();
        for (String path : this.resolutionMap.keySet()) {
            String[] parts = path.split("#");
            if (parts.length != 2) continue;
            String host = parts[0];
            String definitionPath = parts[1];
            ArrayList objectList = (ArrayList)hostToObjectMap.get(host);
            if (objectList == null) {
                objectList = new ArrayList();
                hostToObjectMap.put(host, objectList);
            }
            ResolutionContext ctx = this.resolutionMap.get(path);
            Object mapping = ctx.object;
            Object target = ctx.parent;
            try {
                RefProperty ref;
                Model model;
                String contents = null;
                if (host.startsWith("http")) {
                    new RemoteUrl();
                    contents = RemoteUrl.urlToString(host, auths);
                } else {
                    contents = Json.mapper().writeValueAsString((Object)this.swagger);
                }
                JsonNode location = null;
                String locationName = null;
                if (contents != null) {
                    String[] objectPath;
                    location = Json.mapper().readTree(contents);
                    for (String objectPathPart : objectPath = definitionPath.split("/")) {
                        this.LOGGER.debug("getting part " + objectPathPart);
                        if (objectPathPart.length() <= 0 || location == null) continue;
                        location = location.get(objectPathPart);
                        locationName = objectPathPart;
                    }
                }
                if (location == null) continue;
                if (mapping instanceof Property) {
                    model = (Model)Json.mapper().convertValue((Object)location, Model.class);
                    if (!(mapping instanceof RefProperty)) continue;
                    ref = (RefProperty)mapping;
                    ref.set$ref(locationName);
                    this.swagger.addDefinition(locationName, model);
                    continue;
                }
                if (target instanceof Parameter) {
                    if (!(mapping instanceof RefModel)) continue;
                    model = (Model)Json.mapper().convertValue((Object)location, Model.class);
                    ref = (RefModel)mapping;
                    ref.set$ref(locationName);
                    this.swagger.addDefinition(locationName, model);
                    continue;
                }
                if (!(target instanceof Operation)) continue;
                Operation operation = (Operation)target;
                int position = 0;
                for (Parameter param : operation.getParameters()) {
                    RefParameter ref2;
                    if (param instanceof RefParameter && (ref2 = (RefParameter)param).getSimpleRef().equals(locationName)) {
                        Parameter remoteParam = (Parameter)Json.mapper().convertValue((Object)location, Parameter.class);
                        operation.getParameters().set(position, remoteParam);
                    }
                    ++position;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void detectOperationRefs() {
        Map paths = this.swagger.getPaths();
        if (paths == null) {
            return;
        }
        for (String pathName : paths.keySet()) {
            Path path = (Path)paths.get(pathName);
            List operations = path.getOperations();
            for (Operation operation : operations) {
                if (operation.getParameters() != null) {
                    for (Parameter parameter : operation.getParameters()) {
                        if (parameter instanceof BodyParameter) {
                            RefModel ref;
                            BodyParameter bp = (BodyParameter)parameter;
                            if (bp.getSchema() == null || !(bp.getSchema() instanceof RefModel) || !(ref = (RefModel)bp.getSchema()).get$ref().startsWith("http")) continue;
                            this.LOGGER.debug("added reference to " + ref.get$ref());
                            this.resolutionMap.put(ref.get$ref(), new ResolutionContext(ref, bp, "ref"));
                            continue;
                        }
                        if (!(parameter instanceof RefParameter)) continue;
                        RefParameter ref = (RefParameter)parameter;
                        this.LOGGER.debug("added reference to " + ref.get$ref());
                        this.resolutionMap.put(ref.get$ref(), new ResolutionContext(ref, operation, "inline"));
                    }
                }
                if (operation.getResponses() == null) continue;
                for (String responseCode : operation.getResponses().keySet()) {
                    RefProperty ref;
                    Property schema;
                    Response response = (Response)operation.getResponses().get(responseCode);
                    if (response.getSchema() == null || !((schema = response.getSchema()) instanceof RefProperty) || (ref = (RefProperty)schema).get$ref() == null || !ref.get$ref().startsWith("http")) continue;
                    this.resolutionMap.put(ref.get$ref(), new ResolutionContext(ref, response, "ref"));
                }
            }
        }
    }

    public void detectModelRefs() {
        Map models = this.swagger.getDefinitions();
        if (models != null) {
            for (String modelName : models.keySet()) {
                this.LOGGER.debug("looking at " + modelName);
                Model model = (Model)models.get(modelName);
                if (model instanceof RefModel) {
                    RefModel ref = (RefModel)model;
                    if (ref.get$ref() == null || !ref.get$ref().startsWith("http")) continue;
                    this.LOGGER.debug("added reference to " + ref.get$ref());
                    this.resolutionMap.put(ref.get$ref(), new ResolutionContext(ref, this.swagger.getDefinitions(), "ref"));
                    continue;
                }
                if (model instanceof ArrayModel) {
                    RefProperty ref;
                    ArrayModel arrayModel = (ArrayModel)model;
                    if (arrayModel.getItems() == null || !(arrayModel.getItems() instanceof RefProperty) || (ref = (RefProperty)arrayModel.getItems()).get$ref() == null || !ref.get$ref().startsWith("http")) continue;
                    this.LOGGER.debug("added reference to " + ref.get$ref());
                    this.resolutionMap.put(ref.get$ref(), new ResolutionContext(ref, this.swagger.getDefinitions(), "ref"));
                    continue;
                }
                if (!(model instanceof ModelImpl)) continue;
                ModelImpl impl = (ModelImpl)model;
                Map properties = impl.getProperties();
                for (String propertyName : properties.keySet()) {
                    MapProperty mp;
                    RefProperty ref;
                    Property property = (Property)properties.get(propertyName);
                    if (property instanceof RefProperty) {
                        RefProperty ref2 = (RefProperty)property;
                        if (ref2.get$ref() == null || !ref2.get$ref().startsWith("http")) continue;
                        this.LOGGER.debug("added reference to " + ref2.get$ref());
                        this.resolutionMap.put(ref2.get$ref(), new ResolutionContext(ref2, impl, "ref"));
                        continue;
                    }
                    if (property instanceof ArrayProperty) {
                        ArrayProperty arrayProperty = (ArrayProperty)property;
                        if (arrayProperty.getItems() == null || !(arrayProperty.getItems() instanceof RefProperty) || (ref = (RefProperty)arrayProperty.getItems()).get$ref() == null || !ref.get$ref().startsWith("http")) continue;
                        this.LOGGER.debug("added reference to " + ref.get$ref());
                        this.resolutionMap.put(ref.get$ref(), new ResolutionContext(ref, arrayProperty, "ref"));
                        continue;
                    }
                    if (!(property instanceof MapProperty) || (mp = (MapProperty)property).getAdditionalProperties() == null || !(mp.getAdditionalProperties() instanceof RefProperty) || (ref = (RefProperty)mp.getAdditionalProperties()).get$ref() == null || !ref.get$ref().startsWith("http")) continue;
                    this.LOGGER.debug("added reference to " + ref.get$ref());
                    this.resolutionMap.put(ref.get$ref(), new ResolutionContext(ref, mp, "ref"));
                }
            }
        }
    }

    static class ResolutionContext {
        private Object object;
        private Object parent;
        private String scope;

        public ResolutionContext(Object object, Object parent, String scope) {
            this.object = object;
            this.parent = parent;
            this.scope = scope;
        }
    }
}

