/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class TizenClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected static String PREFIX = "ArtikCloud";
    protected String sourceFolder = "src";
    protected String documentationFolder = "doc";

    public TizenClientCodegen() {
        this.outputFolder = "";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.templateDir = "tizen";
        this.embeddedTemplateDir = "tizen";
        this.modelPackage = "";
        this.defaultIncludes = new HashSet<String>(Arrays.asList("bool", "int", "long long", "double", "float"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "int", "long long", "double", "float", "std::string"));
        this.additionalProperties().put("prefix", PREFIX);
        this.setReservedWordsLowerCase(Arrays.asList("alignas", "alignof", "and", "and_eq", "asm", "atomic_cancel", "atomic_commit", "atomic_noexcept", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "class", "compl", "concept", "const", "constexpr", "const_cast", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "import", "long", "module", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "synchronized", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("string", "std::string");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "long long");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("array", "std::list");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("number", "long long");
        this.typeMapping.put("object", "std::string");
        this.typeMapping.put("binary", "std::string");
        this.typeMapping.put("password", "std::string");
        this.typeMapping.put("file", "std::string");
        this.typeMapping.put("DateTime", "std::string");
        this.typeMapping.put("Date", "std::string");
        this.typeMapping.put("UUID", "std::string");
        this.importMapping = new HashMap();
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, "Helpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, "Helpers.cpp"));
        this.supportingFiles.add(new SupportingFile("netclient-header.mustache", this.sourceFolder, "NetClient.h"));
        this.supportingFiles.add(new SupportingFile("netclient-body.mustache", this.sourceFolder, "NetClient.cpp"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, "Object.h"));
        this.supportingFiles.add(new SupportingFile("requestinfo.mustache", this.sourceFolder, "RequestInfo.h"));
        this.supportingFiles.add(new SupportingFile("error-header.mustache", this.sourceFolder, "Error.h"));
        this.supportingFiles.add(new SupportingFile("error-body.mustache", this.sourceFolder, "Error.cpp"));
        this.supportingFiles.add(new SupportingFile("Doxyfile.mustache", this.documentationFolder, "Doxyfile"));
        this.supportingFiles.add(new SupportingFile("generateDocumentation.mustache", this.documentationFolder, "generateDocumentation.sh"));
        this.supportingFiles.add(new SupportingFile("doc-readme.mustache", this.documentationFolder, "README.md"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "tizen";
    }

    @Override
    public String getHelp() {
        return "Generates a Samsung Tizen C++ client library.";
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (schema instanceof MapSchema) {
            return (String)this.instantiationTypes.get("map");
        }
        if (schema instanceof ArraySchema) {
            return (String)this.instantiationTypes.get("array");
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (this.languageSpecificPrimitives.contains(name)) {
            return name;
        }
        return name + "";
    }

    @Override
    public String getSchemaType(Schema schema) {
        String swaggerType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        String swaggerType = this.getSchemaType(schema);
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return swaggerType + "";
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toModelImport(String name) {
        if (name.equals("std::string")) {
            return "#include <string>";
        }
        if (name.equals("std::map")) {
            return "#include <map>";
        }
        if (name.equals("std::list")) {
            return "#include <list>";
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema instanceof StringSchema) {
            return "std::string()";
        }
        if (schema instanceof BooleanSchema) {
            return "bool(false)";
        }
        if (schema instanceof NumberSchema) {
            if ("float".equals(schema.getFormat())) {
                return "float(0)";
            }
            return "double(0)";
        }
        if (schema instanceof IntegerSchema) {
            if ("int64".equals(schema.getFormat())) {
                return "long(0)";
            }
            return "int(0)";
        }
        if (schema instanceof MapSchema) {
            return "new std::map()";
        }
        if (schema instanceof ArraySchema) {
            return "new std::list()";
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            return "new " + this.toModelName(schema.get$ref()) + "()";
        }
        return "null";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder;
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    @Override
    public String toApiName(String name) {
        return this.initialCaps(name) + "Manager";
    }

    @Override
    public String toApiFilename(String name) {
        return this.initialCaps(name) + "Manager";
    }

    @Override
    public String toVarName(String name) {
        String paramName = name.replaceAll("[^a-zA-Z0-9_]", "");
        if (this.isReservedWord(paramName = Character.toLowerCase(paramName.charAt(0)) + paramName.substring(1))) {
            return this.escapeReservedWord(paramName);
        }
        return "" + paramName;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toOperationId(String operationId) {
        if (operationId == "") {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            operationId = this.escapeReservedWord(operationId);
        }
        return TizenClientCodegen.camelize(operationId, true);
    }
}

